/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg;

import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.format.SupportedFormat;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;

public abstract class DsgSubsetWriter {
    protected final FeatureDatasetPoint fdPoint;
    protected final SubsetParams ncssParams;
    protected final List<VariableSimpleIF> wantedVariables;
    protected final CalendarDateRange wantedRange;

    public DsgSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams) throws NcssException {
        this.fdPoint = fdPoint;
        this.ncssParams = ncssParams;
        this.wantedVariables = DsgSubsetWriter.getWantedVariables(fdPoint, ncssParams);
        this.wantedRange = DsgSubsetWriter.getWantedDateRange(ncssParams);
    }

    public abstract HttpHeaders getHttpHeaders(String var1, boolean var2);

    public abstract void write() throws Exception;

    public void respond(HttpServletResponse res, FeatureDataset ft, String requestPathInfo, SubsetParams queryParams, SupportedFormat format) throws Exception {
        this.write();
    }

    public static List<VariableSimpleIF> getWantedVariables(FeatureDatasetPoint fdPoint, SubsetParams ncssParams) throws VariableNotContainedInDatasetException {
        List vars = ncssParams.getVariables();
        if (vars.size() == 1 && ((String)vars.get(0)).equals("all")) {
            return fdPoint.getDataVariables();
        }
        HashMap<String, VariableSimpleIF> dataVarsMap = new HashMap<String, VariableSimpleIF>();
        for (VariableSimpleIF dataVar : fdPoint.getDataVariables()) {
            dataVarsMap.put(dataVar.getShortName(), dataVar);
        }
        ArrayList allVarNames = new ArrayList(dataVarsMap.keySet());
        ArrayList<VariableSimpleIF> wantedVars = new ArrayList<VariableSimpleIF>();
        for (String varName : vars) {
            if (allVarNames.contains(varName)) {
                VariableSimpleIF var = (VariableSimpleIF)dataVarsMap.get(varName);
                wantedVars.add(var);
                continue;
            }
            throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
        }
        return wantedVars;
    }

    public static CalendarDateRange getWantedDateRange(SubsetParams ncssParams) throws NcssException {
        if (ncssParams.isTrue("timePresent")) {
            CalendarDate time = CalendarDate.present();
            CalendarPeriod timeWindow = ncssParams.getTimeWindow();
            if (timeWindow == null) {
                timeWindow = CalendarPeriod.Hour;
            }
            return CalendarDateRange.of((CalendarDate)time.subtract(timeWindow), (CalendarDate)time.add(timeWindow));
        }
        if (ncssParams.getTime() != null) {
            CalendarDate time = ncssParams.getTime();
            CalendarPeriod timeWindow = ncssParams.getTimeWindow();
            if (timeWindow == null) {
                timeWindow = CalendarPeriod.Hour;
            }
            return CalendarDateRange.of((CalendarDate)time.subtract(timeWindow), (CalendarDate)time.add(timeWindow));
        }
        if (ncssParams.getTimeRange() != null) {
            return ncssParams.getTimeRange();
        }
        if (ncssParams.isTrue("timeAll")) {
            return null;
        }
        return null;
    }
}

