/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.any_point;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft2.coverage.SubsetParams;

public abstract class AbstractMixedFeatureTypeSubsetWriter
extends DsgSubsetWriter {
    protected final List<DsgSubsetWriter> writers = new ArrayList<DsgSubsetWriter>();
    protected final OutputStream out;

    public AbstractMixedFeatureTypeSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException {
        super(fdPoint, ncssParams);
        this.out = out;
    }

    protected void initWriters() throws NcssException, IOException, XMLStreamException {
        List featColList = this.fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() > 1) : "This class only deals with multiple Feature Collections.";
        List allVars = this.ncssParams.getVariables();
        int i = 0;
        for (DsgFeatureCollection fc : featColList) {
            PointFeature pointFeature;
            FeatureType featureType = fc.getCollectionFeatureType();
            if (!featureType.isPointFeatureType()) {
                throw new NcssException(String.format("Expected a point feature type, not %s", featureType));
            }
            try {
                switch (featureType) {
                    case POINT: {
                        pointFeature = ((PointFeatureCollection)fc).hasNext() ? ((PointFeatureCollection)fc).next() : null;
                        break;
                    }
                    case STATION: {
                        PointFeatureCollection pfc = (PointFeatureCollection)((StationTimeSeriesFeatureCollection)fc).getCollectionIterator().next();
                        pointFeature = pfc.hasNext() ? pfc.next() : null;
                        break;
                    }
                    case STATION_PROFILE: {
                        ProfileFeature profile = (ProfileFeature)((StationProfileFeature)((StationProfileFeatureCollection)fc).getStationFeatures().get(0)).getCollectionIterator().next();
                        pointFeature = profile.hasNext() ? profile.next() : null;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("%s feature type is not yet supported.", featureType));
                    }
                }
            }
            catch (Exception e) {
                throw new NcssException("Could not read point from feature collection " + fc.getName() + ": " + e.getMessage());
            }
            StructureData data = pointFeature.getDataAll();
            List collectionVars = allVars.stream().filter(var -> data.findMember(var) != null).collect(Collectors.toList());
            this.ncssParams.setVariables(collectionVars);
            this.writers.add(this.newInstance(featureType, i));
            ++i;
        }
    }

    abstract DsgSubsetWriter newInstance(FeatureType var1, int var2) throws XMLStreamException, NcssException, IOException;
}

