/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.util.List;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.DsgSubsetWriter;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft2.coverage.SubsetParams;

public abstract class AbstractPointSubsetWriter
extends DsgSubsetWriter {
    protected final PointFeatureCollection pointFeatureCollection;

    public AbstractPointSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams) throws NcssException {
        this(fdPoint, ncssParams, 0);
    }

    public AbstractPointSubsetWriter(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, int collectionIndex) throws NcssException {
        super(fdPoint, ncssParams);
        List featColList = fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() > collectionIndex) : "Could not find feature collection.";
        assert (featColList.get(collectionIndex) instanceof PointFeatureCollection) : "This class only deals with PointFeatureCollections.";
        this.pointFeatureCollection = (PointFeatureCollection)featColList.get(collectionIndex);
    }

    public abstract void writeHeader(PointFeature var1) throws Exception;

    public abstract void writePoint(PointFeature var1) throws Exception;

    public abstract void writeFooter() throws Exception;

    @Override
    public void write() throws Exception {
        PointFeatureCollection subsettedPointFeatColl = this.pointFeatureCollection.subset(this.ncssParams.getLatLonBoundingBox(), this.wantedRange);
        if (subsettedPointFeatColl == null) {
            return;
        }
        int count = 0;
        boolean headerDone = false;
        for (PointFeature pointFeat : subsettedPointFeatColl) {
            if (!headerDone) {
                this.writeHeader(pointFeat);
                headerDone = true;
            }
            this.writePoint(pointFeat);
            ++count;
        }
        if (count == 0) {
            throw new NcssException("No features are in the requested subset");
        }
        this.writeFooter();
    }
}

