/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.WcsCoverage;
import thredds.server.wcs.v1_0_0_1.WcsDataset;
import thredds.server.wcs.v1_0_0_1.WcsException;
import thredds.server.wcs.v1_0_0_1.WcsRequest;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class GetCoverage
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(GetCoverage.class);
    private WcsCoverage coverage;
    private LatLonRect bboxLatLonRect = null;
    private CalendarDateRange timeRange;
    private WcsCoverage.VerticalRange verticalRange;
    private Request.Format format;
    private boolean isSingleTimeRequest = false;
    private boolean isSingleVerticalRequest = false;

    public GetCoverage(Request.Operation operation, String version, WcsDataset dataset, String coverageId, String crs, String responseCRS, Request.BoundingBox bbox, CalendarDateRange timeRange, WcsCoverage.VerticalRange verticalRange, Request.Format format) throws WcsException {
        super(operation, version, dataset);
        if (coverageId == null) {
            throw new WcsException(WcsException.Code.MissingParameterValue, "coverage", "Coverage identifier required.");
        }
        if (!this.getWcsDataset().isAvailableCoverageName(coverageId)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier [" + coverageId + "].");
        }
        this.coverage = this.getWcsDataset().getAvailableCoverage(coverageId);
        if (this.coverage == null) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier [" + coverageId + "].");
        }
        if (crs == null) {
            crs = this.coverage.getDefaultRequestCrs();
        }
        if (!crs.equalsIgnoreCase(this.coverage.getDefaultRequestCrs())) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "CRS", "Request CRS [" + crs + "] not allowed [" + this.coverage.getDefaultRequestCrs() + "].");
        }
        if (responseCRS == null) {
            responseCRS = this.coverage.getNativeCrs();
        } else if (!responseCRS.equalsIgnoreCase(this.coverage.getNativeCrs())) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "response_CRS", "Response CRS [" + responseCRS + "] not the supported CRS [" + this.coverage.getNativeCrs() + "].");
        }
        if (bbox != null) {
            this.bboxLatLonRect = this.convertBoundingBox(bbox, this.coverage.getCoordinateSystem());
        }
        CoverageCoordSys gcs = this.coverage.getCoordinateSystem();
        CoverageCoordAxis timeCoord = gcs.getTimeAxis();
        this.timeRange = timeRange;
        this.isSingleTimeRequest = timeRange != null ? timeRange.isPoint() : null == timeCoord;
        CoverageCoordAxis vertCoord = gcs.getZAxis();
        this.verticalRange = verticalRange;
        if (verticalRange != null) {
            this.isSingleVerticalRequest = verticalRange.isSinglePoint();
        } else {
            boolean bl = this.isSingleVerticalRequest = null == vertCoord;
        }
        if (format == null) {
            log.debug("GetCoverage(): FORMAT parameter required.");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", "FORMAT parameter required.");
        }
        if (!this.coverage.isSupportedCoverageFormat(format)) {
            String msg = "Unsupported format value [" + format + "].";
            log.debug("GetCoverage(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msg);
        }
        this.format = format;
        if (!(this.format != Request.Format.GeoTIFF && this.format != Request.Format.GeoTIFF_Float || this.isSingleTimeRequest || this.isSingleVerticalRequest)) {
            StringBuilder msgB = new StringBuilder("GeoTIFF supported only for requests at a single time [");
            if (this.timeRange != null) {
                msgB.append(this.timeRange);
            }
            msgB.append("] and a single vertical level [");
            if (verticalRange != null) {
                msgB.append(verticalRange);
            }
            msgB.append("].");
            log.debug("GetCoverage(): " + msgB);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msgB.toString());
        }
    }

    public Request.Format getFormat() {
        return this.format;
    }

    public File writeCoverageDataToFile() throws WcsException {
        return this.coverage.writeCoverageDataToFile(this.format, this.bboxLatLonRect, this.verticalRange, this.timeRange);
    }

    private LatLonRect convertBoundingBox(Request.BoundingBox bbox, CoverageCoordSys gcs) throws WcsException {
        if (bbox == null) {
            return null;
        }
        LatLonPoint minll = LatLonPoint.create((double)bbox.getMinPointValue(1), (double)bbox.getMinPointValue(0));
        LatLonPoint maxll = LatLonPoint.create((double)bbox.getMaxPointValue(1), (double)bbox.getMaxPointValue(0));
        LatLonRect bboxLatLonRect = new LatLonRect(minll, maxll);
        return bboxLatLonRect;
    }
}

