/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wfs;

import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.DatasetManager;
import thredds.core.TdsRequestedDataset;
import thredds.server.wfs.WFSDescribeFeatureTypeWriter;
import thredds.server.wfs.WFSExceptionWriter;
import thredds.server.wfs.WFSFeature;
import thredds.server.wfs.WFSFeatureAttribute;
import thredds.server.wfs.WFSGetCapabilitiesWriter;
import thredds.server.wfs.WFSGetFeatureWriter;
import thredds.server.wfs.WFSRequestType;
import thredds.servlet.ServletUtil;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.SimpleGeometry;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCSBuilder;

@Controller
@RequestMapping(value={"/wfs"})
public class WFSController
extends HttpServlet {
    public static final String TDSNAMESPACE = "tdswfs";

    public static String getXMLNamespaceXMLNSValue(HttpServletRequest hsreq) {
        return WFSController.constructServerPath(hsreq) + "geospatial";
    }

    public static String constructServerPath(HttpServletRequest hsreq) {
        return ServletUtil.getRequestServer(hsreq) + hsreq.getContextPath() + "/wfs/";
    }

    private void getCapabilities(PrintWriter out, HttpServletRequest hsreq, SimpleGeometryCSBuilder sgcs) {
        WFSGetCapabilitiesWriter gcdw = new WFSGetCapabilitiesWriter(out, WFSController.constructServerPath(hsreq));
        gcdw.startXML();
        gcdw.addOperation(WFSRequestType.GetCapabilities);
        gcdw.addOperation(WFSRequestType.DescribeFeatureType);
        gcdw.addOperation(WFSRequestType.GetFeature);
        gcdw.writeOperations();
        List seriesNames = sgcs.getGeometrySeriesNames();
        for (String name : seriesNames) {
            gcdw.addFeature(new WFSFeature("tdswfs:" + name, name));
        }
        gcdw.writeFeatureTypes();
        gcdw.finishXML();
    }

    private void describeFeatureType(PrintWriter out, HttpServletRequest hsreq, String ftName) {
        WFSDescribeFeatureTypeWriter dftw = new WFSDescribeFeatureTypeWriter(out, WFSController.constructServerPath(hsreq), WFSController.getXMLNamespaceXMLNSValue(hsreq));
        dftw.startXML();
        ArrayList<WFSFeatureAttribute> attributes = new ArrayList<WFSFeatureAttribute>();
        attributes.add(new WFSFeatureAttribute("geometryInformation", "gml:SurfaceArrayPropertyType"));
        attributes.add(new WFSFeatureAttribute("hruid", "int"));
        attributes.add(new WFSFeatureAttribute("lat", "double"));
        attributes.add(new WFSFeatureAttribute("lon", "double"));
        attributes.add(new WFSFeatureAttribute("catchments_area", "double"));
        attributes.add(new WFSFeatureAttribute("catchments_perimeter", "double"));
        attributes.add(new WFSFeatureAttribute("catchments_veght", "double"));
        attributes.add(new WFSFeatureAttribute("catchments_cov", "double"));
        dftw.addFeature(new WFSFeature(ftName, ftName + "Type", "AbstractFeatureType", attributes));
        dftw.writeFeatures();
        dftw.finishXML();
    }

    private WFSExceptionWriter getFeature(PrintWriter out, HttpServletRequest hsreq, SimpleGeometryCSBuilder sgcs, String ftName, String fullFtName) {
        ArrayList<SimpleGeometry> geometryList = new ArrayList<SimpleGeometry>();
        GeometryType geoT = sgcs.getGeometryType(ftName);
        if (geoT == null) {
            return new WFSExceptionWriter("Feature Type of " + fullFtName + " not found.", "GetFeature", "OperationProcessingFailed");
        }
        try {
            switch (geoT) {
                case POINT: {
                    Point pt = sgcs.getPoint(ftName, 0);
                    int j = 0;
                    while (pt != null) {
                        geometryList.add((SimpleGeometry)pt);
                        pt = sgcs.getPoint(ftName, ++j);
                    }
                    break;
                }
                case LINE: {
                    Line line = sgcs.getLine(ftName, 0);
                    int k = 0;
                    while (line != null) {
                        geometryList.add((SimpleGeometry)line);
                        line = sgcs.getLine(ftName, ++k);
                    }
                    break;
                }
                case POLYGON: {
                    Polygon poly = sgcs.getPolygon(ftName, 0);
                    int i = 0;
                    while (poly != null) {
                        geometryList.add((SimpleGeometry)poly);
                        poly = sgcs.getPolygon(ftName, ++i);
                    }
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException pt) {
            // empty catch block
        }
        WFSGetFeatureWriter gfdw = new WFSGetFeatureWriter(out, WFSController.constructServerPath(hsreq), WFSController.getXMLNamespaceXMLNSValue(hsreq), geometryList, ftName);
        gfdw.startXML();
        gfdw.writeMembers();
        gfdw.finishXML();
        return null;
    }

    private WFSExceptionWriter checkParametersForError(String request, String version, String service, String typeName) {
        if (service != null) {
            if (!service.equalsIgnoreCase("WFS")) {
                return new WFSExceptionWriter("WFS Server error. SERVICE parameter must be of value WFS.", "service", "InvalidParameterValue");
            }
        } else {
            return new WFSExceptionWriter("WFS server error. SERVICE parameter is required.", "request", "MissingParameterValue");
        }
        if (request != null) {
            WFSRequestType reqToProc;
            if (!request.equalsIgnoreCase(WFSRequestType.GetCapabilities.toString())) {
                if (version != null) {
                    String[] versionParts = version.split("\\.");
                    for (int ind = 0; ind < versionParts.length; ++ind) {
                        try {
                            Integer.valueOf(versionParts[ind]);
                            continue;
                        }
                        catch (NumberFormatException excep) {
                            return new WFSExceptionWriter("WFS server error. VERSION parameter consists of invalid characters.", "version", "InvalidParameterValue");
                        }
                    }
                    boolean validVersion = false;
                    if (versionParts.length == 1 && versionParts[0].equals("2")) {
                        validVersion = true;
                    }
                    if (versionParts.length >= 2 && versionParts[0].equals("2") && versionParts[1].equals("0")) {
                        validVersion = true;
                    }
                    if (!validVersion) {
                        return new WFSExceptionWriter("WFS Server error. Version requested is not supported.", null, "VersionNegotiationFailed");
                    }
                } else {
                    return new WFSExceptionWriter("WFS server error. VERSION parameter is required.", "request", "MissingParameterValue");
                }
                if (typeName == null) {
                    return new WFSExceptionWriter("WFS server error. For the specifed request, parameter typename or typenames must be specified.", "request", "MissingParameterValue");
                }
            }
            if ((reqToProc = WFSRequestType.getWFSRequestType(request)) == null) {
                return new WFSExceptionWriter("WFS server error. REQUEST parameter is not valid. Possible values: GetCapabilities, DescribeFeatureType, GetFeature", "request", "InvalidParameterValue");
            }
        } else {
            return new WFSExceptionWriter("WFS server error. REQUEST parameter is required.", "request", "MissingParameterValue");
        }
        return null;
    }

    @RequestMapping(value={"**"})
    public void httpHandler(HttpServletRequest hsreq, HttpServletResponse hsres) {
        try {
            PrintWriter wr = hsres.getWriter();
            LinkedList<String> paramNames = new LinkedList<String>();
            Enumeration paramNamesE = hsreq.getParameterNames();
            while (paramNamesE.hasMoreElements()) {
                paramNames.add((String)paramNamesE.nextElement());
            }
            String request = null;
            String version = null;
            String service = null;
            String typeNames = null;
            String datasetReqPath = null;
            String actualPath = null;
            String actualFTName = null;
            NetcdfDataset dataset = null;
            if (hsreq.getServletPath().length() > 4) {
                datasetReqPath = hsreq.getServletPath().substring(4, hsreq.getServletPath().length());
            }
            if ((actualPath = TdsRequestedDataset.getLocationFromRequestPath(datasetReqPath)) != null) {
                dataset = TdsRequestedDataset.getDatasetManager().useNetcdfJavaBuilders() || DatasetManager.isLocationObjectStore(actualPath) ? NetcdfDatasets.openDataset((String)actualPath) : NetcdfDataset.openDataset((String)actualPath);
            } else {
                return;
            }
            ImmutableList csList = dataset.getCoordinateSystems();
            SimpleGeometryCSBuilder cs = new SimpleGeometryCSBuilder(dataset, (CoordinateSystem)csList.get(0), null);
            for (String paramName : paramNames) {
                if (paramName.equalsIgnoreCase("REQUEST")) {
                    request = hsreq.getParameter(paramName);
                }
                if (paramName.equalsIgnoreCase("VERSION")) {
                    version = hsreq.getParameter(paramName);
                }
                if (paramName.equalsIgnoreCase("SERVICE")) {
                    service = hsreq.getParameter(paramName);
                }
                if (!paramName.equalsIgnoreCase("TYPENAMES") && !paramName.equalsIgnoreCase("TYPENAME") || (typeNames = hsreq.getParameter(paramName)) == null || typeNames.length() <= TDSNAMESPACE.length()) continue;
                actualFTName = typeNames.substring(TDSNAMESPACE.length() + 1, typeNames.length());
            }
            WFSExceptionWriter paramError = this.checkParametersForError(request, version, service, typeNames);
            WFSExceptionWriter requestProcessingError = null;
            if (paramError == null) {
                WFSRequestType reqToProc = WFSRequestType.getWFSRequestType(request);
                switch (reqToProc) {
                    case GetCapabilities: {
                        this.getCapabilities(wr, hsreq, cs);
                        break;
                    }
                    case DescribeFeatureType: {
                        this.describeFeatureType(wr, hsreq, actualFTName);
                        break;
                    }
                    case GetFeature: {
                        requestProcessingError = this.getFeature(wr, hsreq, cs, actualFTName, typeNames);
                    }
                }
            } else {
                paramError.write(hsres);
                return;
            }
            if (requestProcessingError != null) {
                requestProcessingError.write(hsres);
                return;
            }
        }
        catch (IOException io) {
            throw new RuntimeException("The writer may not have been able to been have retrieved or the requested dataset was not found", io);
        }
    }
}

