/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class CookieFilter
implements Filter {
    public static final String JSESSIONID = "JSESSIONID";
    public static final String SESSION_PATH = "SESSION_PATH";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(_request, _response);
        if (_response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)_request;
            HttpServletResponse httpResponse = (HttpServletResponse)_response;
            HttpSession session = httpRequest.getSession(false);
            if (session != null && session.getId() != null && session.getAttribute(SESSION_PATH) != null) {
                Cookie sessionCookie = new Cookie(JSESSIONID, session.getId());
                sessionCookie.setPath((String)session.getAttribute(SESSION_PATH));
                httpResponse.addCookie(sessionCookie);
            }
        }
    }

    public void destroy() {
    }
}

