/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.StringValidateEncodeUtils;

public class RequestQueryFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean allowAngleBrackets = false;

    public void setAllowAngleBrackets(boolean allowAngleBrackets) throws ServletException {
        this.allowAngleBrackets = allowAngleBrackets;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String query = request.getQueryString();
        if (query != null) {
            while (true) {
                String decodedQuery = URLDecoder.decode(query, "UTF-8");
                boolean badQuery = false;
                if (!this.allowAngleBrackets && StringValidateEncodeUtils.containsAngleBracketCharacters(decodedQuery)) {
                    badQuery = true;
                } else if (!StringValidateEncodeUtils.validSingleLineString(decodedQuery)) {
                    badQuery = true;
                }
                if (badQuery) {
                    this.log.debug("doFilter(): Invalid query string [" + query + "].");
                    String msg = "Invalid query string ";
                    response.sendError(400, msg);
                    return;
                }
                if (query.equals(decodedQuery)) break;
                query = decodedQuery;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

