/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestForwardUtils {
    private static Logger log = LoggerFactory.getLogger(RequestForwardUtils.class);

    private RequestForwardUtils() {
    }

    public static void forwardRequestRelativeToCurrentContext(String fwdPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        if (fwdPath == null || request == null || response == null) {
            String msg = "Path, request, and response may not be null";
            log.error("forwardRequestRelativeToCurrentContext() ERROR: " + msg + (String)(fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        Escaper urlPathEscaper = UrlEscapers.urlPathSegmentEscaper();
        String encodedPath = urlPathEscaper.escape(fwdPath);
        if (RequestForwardUtils.dispatcherWasFound(encodedPath, dispatcher = request.getRequestDispatcher(encodedPath), response)) {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static void forwardRequestRelativeToGivenContext(String fwdPath, ServletContext targetContext, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        if (fwdPath == null || targetContext == null || request == null || response == null) {
            String msg = "Path, context, request, and response may not be null";
            log.error("forwardRequestRelativeToGivenContext() ERROR: " + msg + (String)(fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        Escaper urlPathEscaper = UrlEscapers.urlPathSegmentEscaper();
        String encodedPath = urlPathEscaper.escape(fwdPath);
        if (RequestForwardUtils.dispatcherWasFound(encodedPath, dispatcher = targetContext.getRequestDispatcher(encodedPath), response)) {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static void forwardRequest(String fwdPath, RequestDispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (fwdPath == null || dispatcher == null || request == null || response == null) {
            String msg = "Path, dispatcher, request, and response may not be null";
            log.error("forwardRequestRelativeToGivenContext() ERROR: " + msg + (String)(fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean dispatcherWasFound(String fwdPath, RequestDispatcher dispatcher, HttpServletResponse response) throws IOException {
        if (dispatcher == null) {
            log.error("dispatcherWasFound() ERROR : Dispatcher for forwarding [" + fwdPath + "] not found:");
            response.sendError(404);
            return false;
        }
        return true;
    }
}

