/*
 * Decompiled with CFR 0.152.
 */
package thredds.core;

import com.coverity.security.Escape;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.core.AllowedServices;
import thredds.core.DataRootManager;
import thredds.core.DatasetManager;
import thredds.featurecollection.FeatureCollectionCache;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.ConfigCatalogCache;
import thredds.server.catalog.DataRootPathMatcher;
import thredds.server.catalog.DatasetRootConfig;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.builder.ConfigCatalogBuilder;
import thredds.server.catalog.tracker.CatalogExt;
import thredds.server.catalog.tracker.CatalogTracker;
import thredds.server.catalog.tracker.DataRootExt;
import thredds.server.catalog.tracker.DataRootTracker;
import thredds.server.catalog.tracker.DatasetExt;
import thredds.server.catalog.tracker.DatasetTracker;
import thredds.server.catalog.tracker.DatasetTrackerDiskPersistedCache;
import thredds.server.config.TdsContext;
import thredds.server.config.ThreddsConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Counters;
import ucar.util.prefs.PreferencesExt;

@Component
public class ConfigCatalogInitialization {
    private static final Logger logCatalogInit = LoggerFactory.getLogger(ConfigCatalogInitialization.class);
    private static final String ERROR = "*** ERROR: ";
    private static final boolean show = true;
    private static final ReadMode defaultReadMode = ReadMode.check;
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private AllowedServices allowedServices;
    @Autowired
    private ConfigCatalogCache ccc;
    @Autowired
    private DataRootManager dataRootManager;
    @Autowired
    private DatasetManager datasetManager;
    @Autowired
    private DebugCommands debugCommands;
    @Autowired
    private FeatureCollectionCache fcCache;
    private PreferencesExt prefs;
    private long readNow;
    private long trackerNumber = 1L;
    private long nextCatId = 1L;
    private int numberCatalogs = 10;
    private File contentRootPath;
    private String contextPath;
    private String trackerDir;
    private long maxDatasets;
    private DataRootPathMatcher dataRootPathMatcher;
    private DataRootTracker dataRootTracker;
    private DatasetTracker datasetTracker;
    private CatalogTracker catalogTracker;
    private Set<String> catPathMap;
    private Map<String, String> fcNameMap;
    private DatasetTracker.Callback callback;
    private boolean isDebugMode;
    private long countDatasets = 0L;
    private long maxDatasetsProcess;
    private boolean exceedLimit;

    public ConfigCatalogInitialization() {
    }

    public synchronized void setTrackerDir(String trackerDir) {
        this.trackerDir = trackerDir;
    }

    public void setMaxDatasetToTrack(long maxDatasets) {
        this.maxDatasets = maxDatasets;
    }

    public synchronized void init(ReadMode readMode, PreferencesExt prefs) {
        if (readMode == null) {
            readMode = defaultReadMode;
        }
        this.prefs = prefs;
        this.trackerNumber = prefs.getLong("trackerNumber", 1L);
        this.numberCatalogs = prefs.getInt("numberCatalogs", 10);
        this.nextCatId = prefs.getLong("nextCatId", 1L);
        this.makeDebugActions();
        this.contentRootPath = this.tdsContext.getThreddsDirectory();
        this.contextPath = this.tdsContext.getContextPath();
        this.reread(readMode, true);
    }

    public synchronized boolean reread(ReadMode readMode, boolean isStartup) {
        boolean databaseAlreadyExists;
        this.readNow = System.currentTimeMillis();
        logCatalogInit.info("=========================================================================================\nConfigCatalogInitialization readMode={} isStartup={}", (Object)readMode, (Object)isStartup);
        this.catPathMap = new HashSet<String>();
        this.fcNameMap = new HashMap<String, String>();
        if (this.ccc != null) {
            this.ccc.invalidateAll();
        }
        if (this.fcCache != null) {
            this.fcCache.invalidateAll();
        }
        if (!isStartup && readMode == ReadMode.always) {
            ++this.trackerNumber;
        }
        if (!this.isDebugMode || this.datasetTracker == null) {
            this.datasetTracker = new DatasetTrackerDiskPersistedCache(Paths.get(this.trackerDir, new String[0]).toString(), this.trackerNumber, this.maxDatasets);
        }
        if (!(databaseAlreadyExists = this.datasetTracker.exists())) {
            readMode = ReadMode.always;
            logCatalogInit.info("ConfigCatalogInitializion datasetTracker database does not exist, set readMode to=" + String.valueOf((Object)readMode));
        }
        if (this.callback == null) {
            this.callback = new StatCallback(readMode);
        }
        this.allowedServices.clearGlobalServices();
        switch (readMode) {
            case always: {
                if (databaseAlreadyExists) {
                    logCatalogInit.info("ConfigCatalogInitializion datasetTracker database already exists - closing it before reinitialization.");
                    try {
                        this.datasetTracker.close();
                    }
                    catch (IOException e) {
                        logCatalogInit.error("There was an error closing the datasetTracker database.", (Throwable)e);
                    }
                    this.datasetTracker.reinit();
                }
                this.catalogTracker = new CatalogTracker(this.trackerDir, true, this.numberCatalogs, this.nextCatId);
                this.dataRootTracker = new DataRootTracker(this.trackerDir, true, this.callback);
                this.dataRootPathMatcher = new DataRootPathMatcher(this.ccc, this.dataRootTracker);
                this.ccc.setRootCatalogKeys(this.readRootCatalogs(readMode));
                break;
            }
            case check: {
                this.catalogTracker = new CatalogTracker(this.trackerDir, false, this.numberCatalogs, this.nextCatId);
                this.dataRootTracker = new DataRootTracker(this.trackerDir, false, this.callback);
                this.dataRootPathMatcher = new DataRootPathMatcher(this.ccc, this.dataRootTracker);
                this.ccc.setRootCatalogKeys(this.readRootCatalogs(readMode));
                this.checkExistingCatalogs(readMode);
                break;
            }
            case triggerOnly: {
                this.catalogTracker = new CatalogTracker(this.trackerDir, false, this.numberCatalogs, this.nextCatId);
                this.dataRootTracker = new DataRootTracker(this.trackerDir, false, this.callback);
                this.dataRootPathMatcher = new DataRootPathMatcher(this.ccc, this.dataRootTracker);
                this.ccc.setRootCatalogKeys(this.readRootCatalogs(readMode));
            }
        }
        this.numberCatalogs = this.catalogTracker.size();
        this.nextCatId = this.catalogTracker.getNextCatId();
        if (this.prefs != null) {
            this.prefs.putLong("trackerNumber", this.trackerNumber);
            this.prefs.putLong("nextCatId", this.nextCatId);
            this.prefs.putInt("numberCatalogs", this.numberCatalogs);
        }
        this.callback.finish();
        logCatalogInit.info("\nConfigCatalogInitializion stats\n" + String.valueOf(this.callback));
        try {
            this.datasetTracker.save();
            this.catalogTracker.save();
            this.dataRootTracker.save();
        }
        catch (IOException e) {
            logCatalogInit.error("datasetTracker.save() failed", (Throwable)e);
        }
        if (this.dataRootManager != null) {
            this.dataRootManager.setDataRootPathMatcher(this.dataRootPathMatcher);
        }
        if (this.datasetManager != null) {
            this.datasetManager.setDatasetTracker(this.datasetTracker);
        }
        if (!isStartup && readMode == ReadMode.always) {
            DatasetTrackerDiskPersistedCache.cleanupBefore((String)this.trackerDir, (long)this.trackerNumber);
        }
        long took = System.currentTimeMillis() - this.readNow;
        logCatalogInit.info("ConfigCatalogInitializion finished took={} msecs", (Object)took);
        this.catPathMap = null;
        this.fcNameMap = null;
        this.catalogTracker = null;
        return true;
    }

    private List<String> readRootCatalogs(ReadMode readMode) {
        ArrayList<String> rootCatalogKeys = new ArrayList<String>();
        rootCatalogKeys.add("catalog.xml");
        for (String location : ThreddsConfig.getRootList("catalogRoot")) {
            rootCatalogKeys.add(location);
        }
        logCatalogInit.info("ConfigCatalogInit: initializing " + rootCatalogKeys.size() + " root catalogs.");
        for (String pathname : rootCatalogKeys) {
            try {
                pathname = StringUtils.cleanPath((String)pathname);
                logCatalogInit.info("Checking catalogRoot = " + pathname);
                this.checkCatalogToRead(readMode, pathname, true, 0L);
            }
            catch (Throwable e) {
                logCatalogInit.error("*** ERROR: initializing catalog " + pathname + "; " + e.getMessage(), e);
            }
        }
        return rootCatalogKeys;
    }

    private void checkExistingCatalogs(ReadMode readMode) {
        for (CatalogExt catalogExt : this.catalogTracker.getCatalogs()) {
            if (catalogExt.isRoot()) continue;
            String pathname = catalogExt.getCatRelLocation();
            try {
                logCatalogInit.info("\n**************************************\nCatalog init " + pathname + "[" + String.valueOf(CalendarDate.present()) + "]");
                pathname = StringUtils.cleanPath((String)pathname);
                this.checkCatalogToRead(readMode, pathname, catalogExt.isRoot(), catalogExt.getLastRead());
            }
            catch (Throwable e) {
                logCatalogInit.error("*** ERROR: initializing catalog " + pathname + "; " + e.getMessage(), e);
            }
        }
    }

    private void checkCatalogToRead(ReadMode readMode, String catalogRelPath, boolean isRoot, long lastRead) throws IOException {
        List<String> disallowedServices;
        if (this.exceedLimit) {
            return;
        }
        File catalogFile = new File(this.contentRootPath, catalogRelPath = StringUtils.cleanPath((String)catalogRelPath));
        if (!catalogFile.exists()) {
            this.catalogTracker.removeCatalog(catalogRelPath);
            logCatalogInit.error("*** ERROR: initCatalog(): Catalog [" + catalogRelPath + "] does not exist.");
            return;
        }
        long lastModified = catalogFile.lastModified();
        if (!isRoot && readMode != ReadMode.always && lastModified < lastRead) {
            return;
        }
        if (!isRoot && readMode == ReadMode.triggerOnly) {
            return;
        }
        System.out.printf("initCatalog %s%n", catalogRelPath);
        if (this.catPathMap.contains(catalogRelPath)) {
            logCatalogInit.error("*** ERROR: initCatalog(): Catalog [" + catalogRelPath + "] already seen, possible loop (skip).");
            return;
        }
        this.catPathMap.add(catalogRelPath);
        HashSet<String> idSet = new HashSet<String>();
        ConfigCatalog cat = this.readCatalog(catalogRelPath, catalogFile.getPath());
        if (cat == null) {
            logCatalogInit.error("*** ERROR: initCatalog(): failed to read catalog <" + catalogFile.getPath() + ">.");
            return;
        }
        long catId = this.catalogTracker.put(new CatalogExt(0L, catalogRelPath, isRoot, this.readNow));
        if (isRoot) {
            if (this.ccc != null) {
                this.ccc.put(catalogRelPath, cat);
            }
            this.allowedServices.addGlobalServices(cat.getServices());
            if (readMode == ReadMode.triggerOnly) {
                return;
            }
        }
        if (this.callback != null) {
            this.callback.hasCatalogRef(cat);
        }
        for (DatasetRootConfig p : cat.getDatasetRoots()) {
            this.dataRootPathMatcher.addRoot(p, catalogRelPath, readMode == ReadMode.always);
        }
        if (this.callback == null && !(disallowedServices = this.allowedServices.getDisallowedServices(cat.getServices())).isEmpty()) {
            this.allowedServices.getDisallowedServices(cat.getServices());
            logCatalogInit.error("*** ERROR: initCatalog(): declared services: " + Arrays.toString(disallowedServices.toArray()) + " in catalog: " + catalogFile.getPath() + " are disallowed in threddsConfig file");
        }
        this.dataRootPathMatcher.extractDataRoots(catalogRelPath, cat.getDatasetsLocal(), readMode == ReadMode.always, this.fcNameMap);
        int pos = catalogRelPath.lastIndexOf("/");
        String dirPath = pos > 0 ? catalogRelPath.substring(0, pos + 1) : "";
        this.processDatasets(catId, readMode, dirPath, cat.getDatasetsLocal(), idSet);
        for (CatalogScan catScan : cat.getCatalogScans()) {
            if (this.exceedLimit) {
                return;
            }
            Path relLocation = Paths.get(dirPath, catScan.getLocation());
            Path absLocation = Paths.get(catalogFile.getParent(), catScan.getLocation());
            this.readCatsInDirectory(readMode, relLocation.toString(), absLocation);
        }
    }

    private ConfigCatalog readCatalog(String catalogRelPath, String catalogFullPath) {
        URI uri;
        try {
            uri = new URI(this.contextPath + "/catalog/" + catalogRelPath);
        }
        catch (URISyntaxException e) {
            logCatalogInit.error("*** ERROR: readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        ConfigCatalogBuilder builder = new ConfigCatalogBuilder(this.contextPath);
        try {
            logCatalogInit.info("-------readCatalog(): path=" + catalogRelPath);
            ConfigCatalog cat = (ConfigCatalog)builder.buildFromLocation(catalogFullPath, uri);
            if (builder.hasFatalError()) {
                logCatalogInit.error("*** ERROR:    invalid catalog -- " + builder.getErrorMessage());
                return null;
            }
            if (builder.getErrorMessage().length() > 0) {
                logCatalogInit.debug(builder.getErrorMessage());
            }
            return cat;
        }
        catch (Throwable t) {
            logCatalogInit.error("*** ERROR:   Exception on catalog=" + catalogFullPath + " " + t.getMessage() + "\n log=" + builder.getErrorMessage(), t);
            return null;
        }
    }

    private void processDatasets(long catId, ReadMode readMode, String dirPath, List<Dataset> datasets, Set<String> idMap) throws IOException {
        if (this.exceedLimit) {
            return;
        }
        for (Dataset ds : datasets) {
            String id;
            if (this.datasetTracker.trackDataset(catId, ds, this.callback)) {
                ++this.countDatasets;
            }
            if (this.maxDatasetsProcess > 0L && this.countDatasets > this.maxDatasetsProcess) {
                this.exceedLimit = true;
            }
            if ((id = ds.getID()) != null) {
                if (idMap.contains(id)) {
                    logCatalogInit.error("*** ERROR: Duplicate id on  '" + ds.getName() + "' id= '" + id + "'");
                } else {
                    idMap.add(id);
                }
            }
            if (ds instanceof DatasetScan || ds instanceof FeatureCollectionRef || ds instanceof CatalogScan) continue;
            if (ds instanceof CatalogRef) {
                Object path;
                String contextPathPlus;
                CatalogRef catref = (CatalogRef)ds;
                String href = catref.getXlinkHref();
                if (href.startsWith("http:")) continue;
                if (href.startsWith("./")) {
                    href = href.substring(2);
                }
                if (href.startsWith(contextPathPlus = this.contextPath + "/")) {
                    path = href.substring(contextPathPlus.length());
                } else {
                    if (href.startsWith("/")) {
                        logCatalogInit.error("*** ERROR: Skipping catalogRef <xlink:href=" + href + ">. Reference is relative to the server outside the context path [" + contextPathPlus + "]. Parent catalog info: Name=\"" + catref.getParentCatalog().getName() + "\"; Base URI=\"" + catref.getParentCatalog().getUriString() + "\"; dirPath=\"" + dirPath + "\".");
                        continue;
                    }
                    path = dirPath + href;
                }
                CatalogExt ext = this.catalogTracker.get((String)path);
                long lastRead = ext == null ? 0L : ext.getLastRead();
                this.checkCatalogToRead(readMode, (String)path, false, lastRead);
                continue;
            }
            this.processDatasets(catId, readMode, dirPath, ds.getDatasetsLocal(), idMap);
        }
    }

    private void readCatsInDirectory(ReadMode readMode, String dirPath, Path directory) throws IOException {
        if (this.exceedLimit) {
            return;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory, "*.xml");){
            for (Path p : ds) {
                if (Files.isDirectory(p, new LinkOption[0])) continue;
                String filename = p.getFileName().toString();
                String path = dirPath.length() == 0 ? filename : dirPath + "/" + filename;
                CatalogExt ext = this.catalogTracker.get(path);
                long lastRead = ext == null ? 0L : ext.getLastRead();
                this.checkCatalogToRead(readMode, path, false, lastRead);
            }
        }
        ds = Files.newDirectoryStream(directory);
        try {
            for (Path dir : ds) {
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String dirPathChild = dirPath + "/" + dir.getFileName().toString();
                this.readCatsInDirectory(readMode, dirPathChild, dir);
            }
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
    }

    public void makeDebugActions() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Catalogs");
        DebugCommands.Action act = new DebugCommands.Action("showCatalogExt", "Show known catalogs"){

            @Override
            public void doAction(DebugCommands.Event e) {
                e.pw.printf("numberCatalogs=%d nextCatId=%d%n", ConfigCatalogInitialization.this.numberCatalogs, ConfigCatalogInitialization.this.nextCatId);
                e.pw.printf("%nid  root  lastRead     path%n", new Object[0]);
                CatalogTracker catalogTracker = new CatalogTracker(ConfigCatalogInitialization.this.trackerDir, false, ConfigCatalogInitialization.this.numberCatalogs, 0L);
                for (CatalogExt cat : catalogTracker.getCatalogs()) {
                    e.pw.printf("%3d: %5s %s %s%n", cat.getCatId(), cat.isRoot(), CalendarDate.of((long)cat.getLastRead()), cat.getCatRelLocation());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("showRoots", "Show root catalogs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(DebugCommands.Event e) {
                StringBuilder sbuff = new StringBuilder();
                ConfigCatalogInitialization configCatalogInitialization = ConfigCatalogInitialization.this;
                synchronized (configCatalogInitialization) {
                    for (String catPath : ConfigCatalogInitialization.this.ccc.getRootCatalogKeys()) {
                        sbuff.append(" catalog= ").append(catPath).append("\n");
                    }
                }
                e.pw.println();
                e.pw.println(Escape.html((String)sbuff.toString()));
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("showStats", "Show catalog initialization stats"){

            @Override
            public void doAction(DebugCommands.Event e) {
                if (ConfigCatalogInitialization.this.callback != null) {
                    e.pw.printf("%n%s%n", Escape.html((String)ConfigCatalogInitialization.this.callback.toString()));
                } else {
                    e.pw.printf("N/A%n", new Object[0]);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public ConfigCatalogInitialization(ReadMode readMode, File contentRootPath, String trackerDir, DatasetTracker datasetTracker, AllowedServices allowedServices, DatasetTracker.Callback callback, long maxDatasetsProcess) throws IOException {
        this.contentRootPath = contentRootPath;
        this.contextPath = "/thredds";
        this.trackerDir = trackerDir != null ? trackerDir : new File(contentRootPath, "cache/catalog").getPath();
        this.datasetTracker = datasetTracker;
        this.allowedServices = allowedServices;
        this.callback = callback;
        this.maxDatasetsProcess = maxDatasetsProcess;
        this.isDebugMode = true;
        File trackerFile = new File(this.trackerDir);
        if (!trackerFile.exists()) {
            boolean ok = trackerFile.mkdirs();
            System.out.printf("ConfigCatalogInitialization make tracker directory '%s' make ok = %s%n", this.trackerDir, ok);
        }
        this.reread(readMode, true);
    }

    public static enum ReadMode {
        always,
        check,
        triggerOnly;


        public static ReadMode get(String name) {
            for (ReadMode mode : ReadMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }
    }

    public static class StatCallback
    implements DatasetTracker.Callback {
        ReadMode readMode;
        Stats stat2;
        long start = System.currentTimeMillis();
        double took;

        public StatCallback(ReadMode readMode) {
            this.readMode = readMode;
            this.stat2 = new Stats();
        }

        public void finish() {
            this.took = (double)(System.currentTimeMillis() - this.start) / 1000.0;
        }

        public void hasDataRoot(DataRootExt dataRoot) {
            ++this.stat2.dataRoot;
            switch (dataRoot.getType()) {
                case featureCollection: {
                    ++this.stat2.dataRootFc;
                    break;
                }
                case catalogScan: {
                    ++this.stat2.catalogScan;
                    break;
                }
                case datasetScan: {
                    ++this.stat2.datasetScan;
                    break;
                }
                case datasetRoot: {
                    ++this.stat2.datasetRoot;
                }
            }
        }

        public void hasDataset(Dataset ds) {
            ++this.stat2.datasets;
            List access = ds.getAccess();
            this.stat2.counters.count("nAccess", (Comparable)Integer.valueOf(access.size()));
            for (Access acc : access) {
                if (acc.getService() == null) continue;
                this.stat2.counters.count("serviceType", (Comparable)((Object)acc.getService().toString()));
            }
        }

        public void hasTrackedDataset(Dataset ds) {
            ++this.stat2.trackedDatasets;
        }

        public void hasNcml(Dataset ds) {
            ++this.stat2.ncml;
            Element netcdfElem = ds.getNcmlElement();
            Element agg = netcdfElem.getChild("aggregation", Catalog.ncmlNS);
            if (agg == null) {
                return;
            }
            List nested = agg.getChildren("netcdf", Catalog.ncmlNS);
            if (nested == null) {
                return;
            }
            if (nested.size() == 1) {
                ++this.stat2.ncmlOne;
            }
            this.stat2.counters.count("ncmlAggSize", (Comparable)Integer.valueOf(nested.size()));
        }

        public void hasRestriction(Dataset ds) {
            ++this.stat2.restrict;
            String restrict = ds.getRestrictAccess();
            if (restrict != null) {
                this.stat2.counters.count("restrict", (Comparable)((Object)restrict));
            }
        }

        public void hasCatalogRef(ConfigCatalog dd) {
            ++this.stat2.catrefs;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("ConfigCatalogInitialization started %s took %f secs using readMode=%s%n", new Object[]{CalendarDate.of((long)this.start), this.took, this.readMode});
            return this.stat2.show(f);
        }
    }

    static class Stats {
        int catrefs;
        int datasets;
        int trackedDatasets;
        int dataRoot;
        int dataRootFc;
        int datasetScan;
        int datasetRoot;
        int catalogScan;
        int ncml;
        int ncmlOne;
        int restrict;
        Counters counters = new Counters();

        public Stats() {
            this.counters.add("restrict");
            this.counters.add("nAccess");
            this.counters.add("serviceType");
            this.counters.add("ncmlAggSize");
        }

        String show(Formatter f) {
            f.format("         catalogs=%d%n", this.catrefs);
            f.format("         datasets=%d%n", this.datasets);
            f.format("  trackedDatasets=%d%n", this.trackedDatasets);
            f.format("           restrict=%d%n", this.restrict);
            f.format("            hasNcml=%d%n%n", this.ncml);
            f.format("      dataRoot=%d%n", this.dataRoot);
            f.format("    featCollect=%d%n", this.dataRootFc);
            f.format("    datasetScan=%d%n", this.datasetScan);
            f.format("    catalogScan=%d%n", this.catalogScan);
            f.format("    datasetRoot=%d%n%n", this.datasetRoot);
            f.format("DatasetExt.total_count %d%n", DatasetExt.total_count);
            f.format("DatasetExt.total_nbytes %d%n", DatasetExt.total_nbytes);
            float avg = DatasetExt.total_count == 0 ? 0.0f : (float)DatasetExt.total_nbytes / (float)DatasetExt.total_count;
            f.format("DatasetExt.avg_nbytes %5.0f%n", Float.valueOf(avg));
            this.counters.show(f);
            return f.toString();
        }
    }
}

