/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.point.AbstractPointSubsetWriter;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IO;

public class PointSubsetWriterNetcdf
extends AbstractPointSubsetWriter {
    private final NcssDiskCache ncssDiskCache;
    private final OutputStream out;
    private final NetcdfFileWriter.Version version;
    private final File netcdfResult;
    private final WriterCFPointCollection cfWriter;

    public PointSubsetWriterNetcdf(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, NcssDiskCache ncssDiskCache, OutputStream out, NetcdfFileWriter.Version version) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        assert (fdPoint.getPointFeatureCollectionList().size() == 1) : "Multiple feature collections cannot be written as a CF dataset";
        this.ncssDiskCache = ncssDiskCache;
        this.out = out;
        this.version = version;
        this.netcdfResult = ncssDiskCache.getDiskCache().createUniqueFile("ncss-point", ".nc");
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        attribs.add(new Attribute("title", "Extracted data from TDS Feature Collection " + fdPoint.getLocation()));
        CalendarDateUnit timeUnit = this.pointFeatureCollection.getTimeUnit();
        if (timeUnit == null) {
            timeUnit = CalendarDateUnit.unixDateUnit;
        }
        String altUnit = this.pointFeatureCollection.getAltUnits();
        this.cfWriter = new WriterCFPointCollection(this.netcdfResult.getAbsolutePath(), attribs, this.wantedVariables, timeUnit, altUnit, new CFPointWriterConfig(version));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForNetcdf(datasetPath, this.ncssDiskCache, this.version);
    }

    @Override
    public void writeHeader(PointFeature pf) throws IOException {
        this.cfWriter.writeHeader(pf);
    }

    @Override
    public void writePoint(PointFeature pointFeat) throws Exception {
        this.cfWriter.writeRecord(pointFeat, pointFeat.getDataAll());
    }

    @Override
    public void writeFooter() throws IOException {
        this.cfWriter.finish();
        IO.copyFileB((File)this.netcdfResult, (OutputStream)this.out, (int)60000);
        this.out.flush();
    }
}

