/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.view.dsg.HttpHeaderWriter;
import thredds.server.ncss.view.dsg.station.AbstractStationProfileSubsetWriter;
import ucar.ma2.Array;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.util.Format;

public class StationProfileSubsetWriterCSV
extends AbstractStationProfileSubsetWriter {
    protected final PrintWriter writer;

    public StationProfileSubsetWriterCSV(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out) throws NcssException, IOException {
        this(fdPoint, ncssParams, out, 0);
    }

    public StationProfileSubsetWriterCSV(FeatureDatasetPoint fdPoint, SubsetParams ncssParams, OutputStream out, int collectionIndex) throws NcssException, IOException {
        super(fdPoint, ncssParams, collectionIndex);
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        return HttpHeaderWriter.getHttpHeadersForCSV(datasetPath, isStream);
    }

    @Override
    protected void writeHeader(StationProfileFeature stn) throws Exception {
        String altUnits = stn.getAltUnits();
        this.writer.print("time,alt[unit=\"" + altUnits + "\"],station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(",");
            this.writer.print(wantedVar.getShortName());
            if (wantedVar.getUnitsString() == null) continue;
            this.writer.print("[unit=\"" + wantedVar.getUnitsString() + "\"]");
        }
        this.writer.println();
    }

    @Override
    protected void writeStationPointFeature(StationProfileFeature stn, StationPointFeature pointFeat) throws IOException {
        this.writer.print(CalendarDateFormatter.toDateTimeStringISO((CalendarDate)pointFeat.getObservationTimeAsCalendarDate()));
        this.writer.print(',');
        this.writer.print(pointFeat.getLocation().getAltitude());
        this.writer.print(',');
        this.writer.print(stn.getName());
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)stn.getLatitude(), (int)3));
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)stn.getLongitude(), (int)3));
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(',');
            Array dataArray = pointFeat.getDataAll().getArray(wantedVar.getShortName());
            this.writer.print(dataArray.toString().trim());
        }
        this.writer.println();
    }

    @Override
    protected void writeFooter() throws IOException {
        this.writer.flush();
    }
}

