/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wfs;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import thredds.server.config.ThreddsConfig;
import thredds.server.wfs.WFSFeature;
import thredds.server.wfs.WFSRequestType;
import thredds.server.wfs.WFSXMLHelper;

public class WFSGetCapabilitiesWriter {
    private PrintWriter response;
    private String fileOutput;
    private final String server;
    private List<WFSRequestType> operationList;
    private List<WFSFeature> featureList;

    private void writeServiceInfo() {
        this.fileOutput = this.fileOutput + "<ows:ServiceIdentification> <ows:Title>WFS Server on THREDDS</ows:Title> <ows:Abstract>ncWFS uses the NetCDF Java Library to handle WFS requests</ows:Abstract> <ows:ServiceType codeSpace=\"OGC\">WFS</ows:ServiceType> <ows:ServiceTypeVersion>2.0.0</ows:ServiceTypeVersion> <ows:Fees/> <ows:AccessConstraints/> </ows:ServiceIdentification> ";
        this.fileOutput = this.fileOutput + "<ows:ServiceProvider> <ows:ProviderName>" + ThreddsConfig.get("serverInformation.hostInstitution.name", "hostInstitution") + "</ows:ProviderName> <ows:ProviderSite xlink:href=\"" + ThreddsConfig.get("serverInformation.hostInstitution.webSite", "") + "\" xlink:type=\"simple\"/> <ows:ServiceContact/> </ows:ServiceProvider> ";
    }

    private void writeAOperation(WFSRequestType rt) {
        this.fileOutput = this.fileOutput + "<ows:Operation name=\"" + rt.toString() + "\"> <ows:DCP> <ows:HTTP> <ows:Get xlink:href=\"" + this.server + "?\"/> <ows:Post xlink:href=\"" + this.server + "\"/> </ows:HTTP> </ows:DCP>";
        this.fileOutput = this.fileOutput + "</ows:Operation> ";
    }

    private void writeAConstraint(String name, boolean isImplemented) {
        String defValue = isImplemented ? "TRUE" : "FALSE";
        this.fileOutput = this.fileOutput + "<ows:Constraint name=\"" + name + "\"> <ows:NoValues/> <ows:DefaultValue>" + defValue + "</ows:DefaultValue> </ows:Constraint>";
    }

    private void writeHeadersAndSS() {
        this.fileOutput = this.fileOutput + "<wfs:WFS_Capabilities xsi:schemaLocation=" + WFSXMLHelper.encQuotes("http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd ") + " xmlns:xsi=" + WFSXMLHelper.encQuotes("http://www.w3.org/2001/XMLSchema-instance") + " xmlns:xlink=" + WFSXMLHelper.encQuotes("http://www.w3.org/1999/xlink") + " xmlns:gml=" + WFSXMLHelper.encQuotes("http://opengis.net/gml") + " xmlns:fes=" + WFSXMLHelper.encQuotes("http://www.opengis.net/fes/2.0") + " xmlns:ogc=" + WFSXMLHelper.encQuotes("http://www.opengis.net/ogc") + " xmlns:ows=" + WFSXMLHelper.encQuotes("http://www.opengis.net/ows/1.1\" xmlns:wfs=\"http://opengis.net/wfs/2.0") + " xmlns=" + WFSXMLHelper.encQuotes("http://www.opengis.net/wfs/2.0") + " version=\"2.0.0\">";
        this.writeServiceInfo();
    }

    public void startXML() {
        this.fileOutput = this.fileOutput + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        this.writeHeadersAndSS();
    }

    public void finishXML() {
        this.fileOutput = this.fileOutput + "</wfs:WFS_Capabilities>";
        this.response.append(this.fileOutput);
        this.response = null;
        this.fileOutput = null;
    }

    public void addOperation(WFSRequestType rt) {
        this.operationList.add(rt);
    }

    public void writeOperations() {
        this.fileOutput = this.fileOutput + "<ows:OperationsMetadata> ";
        for (WFSRequestType rt : this.operationList) {
            this.writeAOperation(rt);
        }
        this.fileOutput = this.fileOutput + "<ows:Parameter name=\"AcceptVersions\"> <ows:AllowedValues> <ows:Value>2.0.0</ows:Value></ows:AllowedValues></ows:Parameter>";
        this.fileOutput = this.fileOutput + "<ows:Parameter name=\"AcceptFormats\"><ows:AllowedValues> <ows:Value>text/xml</ows:Value></ows:AllowedValues></ows:Parameter>";
        this.fileOutput = this.fileOutput + "<ows:Parameter name=\"Sections\"> <ows:AllowedValues> <ows:Value>ServiceIdentification</ows:Value> <ows:Value>ServiceProvider</ows:Value> <ows:Value>OperationsMetadata</ows:Value> <ows:Value>FeatureTypeList</ows:Value> </ows:AllowedValues></ows:Parameter>";
        this.fileOutput = this.fileOutput + "<ows:Parameter name=\"version\"> <ows:AllowedValues> <ows:Value>2.0.0</ows:Value></ows:AllowedValues></ows:Parameter>";
        this.writeAConstraint("ImplementsBasicWFS", true);
        this.writeAConstraint("ImplementsTransactionalWFS", false);
        this.writeAConstraint("ImplementsLockingWFS", false);
        this.writeAConstraint("KVPEncoding", false);
        this.writeAConstraint("XMLEncoding", true);
        this.writeAConstraint("SOAPEncoding", false);
        this.writeAConstraint("ImplementsInheritance", false);
        this.writeAConstraint("ImplementsRemoteResolve", false);
        this.writeAConstraint("ImplementsResultPaging", false);
        this.writeAConstraint("ImplementsStandardJoins", false);
        this.writeAConstraint("ImplementsSpatialJoins", false);
        this.writeAConstraint("ImplementsTemporalJoins", false);
        this.writeAConstraint("ImplementsFeatureVersioning", false);
        this.writeAConstraint("ManageStoredQueries", false);
        this.writeAConstraint("PagingIsTransactionSafe", false);
        this.writeAConstraint("QueryExpressions", false);
        this.fileOutput = this.fileOutput + "</ows:OperationsMetadata>";
    }

    public void writeFeatureTypes() {
        this.fileOutput = this.fileOutput + "<FeatureTypeList> ";
        for (WFSFeature wf : this.featureList) {
            this.fileOutput = this.fileOutput + "<FeatureType> <Name>" + wf.getName() + "</Name> <Title>" + wf.getTitle() + "</Title> <DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><OutputFormats> <Format>text/xml; subtype=gml/3.2.1</Format> </OutputFormats> <ows:WGS84BoundingBox dimensions=\"2\"> <ows:LowerCorner>-180 -90</ows:LowerCorner> <ows:UpperCorner>180 90</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType> ";
        }
        this.fileOutput = this.fileOutput + "</FeatureTypeList> ";
    }

    public void addFeature(WFSFeature feature) {
        this.featureList.add(feature);
    }

    public WFSGetCapabilitiesWriter(PrintWriter response, String server) {
        this.response = response;
        this.fileOutput = "";
        this.server = server;
        this.operationList = new ArrayList<WFSRequestType>();
        this.featureList = new ArrayList<WFSFeature>();
    }
}

