/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import thredds.server.config.WmsConfigBean;
import thredds.server.wms.ThreddsWmsCatalogue;
import thredds.server.wms.config.LayerSettings;
import thredds.server.wms.config.WmsDetailedConfig;
import uk.ac.rdg.resc.edal.domain.Extent;
import uk.ac.rdg.resc.edal.graphics.utils.EnhancedVariableMetadata;
import uk.ac.rdg.resc.edal.graphics.utils.PlottingStyleParameters;
import uk.ac.rdg.resc.edal.metadata.VariableMetadata;

public class TdsEnhancedVariableMetadata
implements EnhancedVariableMetadata {
    static WmsConfigBean wmsConfig;
    final VariableMetadata metadata;
    final ThreddsWmsCatalogue layer;
    final LayerSettings layerSettings;

    public TdsEnhancedVariableMetadata(ThreddsWmsCatalogue layer, VariableMetadata metadata) {
        this.metadata = metadata;
        this.layer = layer;
        WmsDetailedConfig detailedWmsConfig = wmsConfig.getWmsDetailedConfig();
        this.layerSettings = detailedWmsConfig.getSettings(layer, metadata);
    }

    public static void setWmsConfig(WmsConfigBean config) {
        wmsConfig = config;
    }

    public String getId() {
        return this.metadata.getId();
    }

    public String getTitle() {
        return this.metadata.getParameter().getTitle();
    }

    public String getDescription() {
        return this.metadata.getParameter().getDescription();
    }

    public String getCopyright() {
        return null;
    }

    public String getMoreInfo() {
        return null;
    }

    public PlottingStyleParameters getDefaultPlottingParameters() {
        List<Extent<Float>> scaleRanges = Collections.singletonList(this.layerSettings.getDefaultColorScaleRange());
        String palette = this.layerSettings.getDefaultPaletteName();
        Color aboveMaxColour = this.layerSettings.getDefaultAboveMaxColor();
        Color belowMinColour = this.layerSettings.getDefaultBelowMinColor();
        Color noDataColour = this.layerSettings.getDefaultNoDataColor();
        Float opacity = this.layerSettings.getDefaultOpacity();
        Boolean logScaling = this.layerSettings.isLogScaling();
        Integer numColourBands = this.layerSettings.getDefaultNumColorBands();
        return new PlottingStyleParameters(scaleRanges, palette, aboveMaxColour, belowMinColour, noDataColour, logScaling, numColourBands, opacity);
    }

    public boolean isQueryable() {
        return this.layerSettings.isAllowFeatureInfo();
    }

    public boolean isDownloadable() {
        return this.layer.isDownloadable(this.metadata.getId());
    }

    public boolean isDisabled() {
        return this.layer.isDisabled(this.metadata.getId());
    }
}

