/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import com.google.common.eventbus.Subscribe;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.featurecollection.InvDatasetFcFmrc;
import thredds.featurecollection.InvDatasetFcGrib;
import thredds.featurecollection.InvDatasetFcPoint;
import thredds.inventory.CollectionUpdateEvent;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.server.catalog.FeatureCollectionRef;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryFeatureDataset;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.URLnaming;

@ThreadSafe
public abstract class InvDatasetFeatureCollection
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(InvDatasetFeatureCollection.class);
    protected static final String LATEST_DATASET_CATALOG = "latest.xml";
    protected static final String VARIABLES = "?metadata=variableMap";
    protected static final String FILES = "files";
    protected static final boolean useNetcdfJavaBuilders = true;
    protected static AllowedServices allowedServices;
    protected static String contextName;
    protected FeatureCollectionRef parent;
    protected Service orgService;
    protected Service virtualService;
    protected Service latestService;
    protected Service downloadService;
    protected final String name;
    protected final String configPath;
    protected final FeatureCollectionType fcType;
    protected final FeatureCollectionConfig config;
    protected String topDirectory;
    protected MFileCollectionManager datasetCollection;
    @GuardedBy(value="lock")
    protected State state;
    @GuardedBy(value="lock")
    protected boolean first = true;
    protected final Object lock = new Object();

    public static void setContextName(String c) {
        contextName = c;
    }

    public static void setAllowedServices(AllowedServices _allowedServices) {
        allowedServices = _allowedServices;
    }

    protected static String buildCatalogServiceHref(String path) {
        return contextName + "/catalog/" + path + "/catalog.xml";
    }

    public static InvDatasetFeatureCollection factory(FeatureCollectionRef parent, FeatureCollectionConfig config) {
        InvDatasetFeatureCollection result = config.type == FeatureCollectionType.FMRC ? new InvDatasetFcFmrc(parent, config) : (config.type == FeatureCollectionType.GRIB1 || config.type == FeatureCollectionType.GRIB2 ? new InvDatasetFcGrib(parent, config) : new InvDatasetFcPoint(parent, config));
        return result;
    }

    protected InvDatasetFeatureCollection(FeatureCollectionRef parent, FeatureCollectionConfig config) {
        this.parent = parent;
        this.name = config.name;
        this.configPath = config.path;
        this.fcType = config.type;
        this.config = config;
        this.makeDefaultServices();
        logger.info("FeatureCollection added = {}", (Object)this.getConfig());
    }

    protected void makeDefaultServices() {
        this.latestService = allowedServices.getStandardService(StandardService.resolver);
        this.downloadService = allowedServices.getStandardService(StandardService.httpServer);
        this.orgService = this.parent.getServiceDefault();
        if (this.orgService == null) {
            String orgServiceName = this.parent.getServiceNameDefault();
            this.orgService = allowedServices.findGlobalService(orgServiceName);
        }
        if (this.orgService == null) {
            this.orgService = allowedServices.getStandardServices(this.fcType.getFeatureType());
        }
        if (this.orgService == null) {
            return;
        }
        if (this.orgService.getType() != ServiceType.Compound) {
            this.virtualService = this.orgService;
            return;
        }
        ArrayList<Service> nestedOk = new ArrayList<Service>();
        for (Service service : this.orgService.getNestedServices()) {
            if (service.getType() == ServiceType.HTTPServer) continue;
            nestedOk.add(service);
        }
        this.virtualService = new Service("VirtualServices", "", ServiceType.Compound.toString(), ServiceType.Compound.getDescription(), null, nestedOk, this.orgService.getProperties(), ServiceType.Compound.getAccessType());
    }

    @Override
    public void close() {
        if (this.datasetCollection != null) {
            this.datasetCollection.close();
        }
    }

    protected void makeCollection() {
        Formatter errlog = new Formatter();
        this.datasetCollection = new MFileCollectionManager(this.config, errlog, logger);
        this.topDirectory = this.datasetCollection.getRoot();
        String errs = errlog.toString();
        if (errs.length() > 0) {
            logger.warn("MFileCollectionManager parse error = {} ", (Object)errs);
        }
    }

    @Subscribe
    public void processEvent(CollectionUpdateEvent event) {
        if (!this.config.collectionName.equals(event.getCollectionName())) {
            return;
        }
        try {
            this.update(event.getType());
        }
        catch (IOException e) {
            logger.error("Error processing event", (Throwable)e);
        }
    }

    public void showStatus(Formatter f) {
        try {
            this.checkState();
            this._showStatus(f, false, null);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(5000);
            t.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
        }
    }

    public String showStatusShort(String type) {
        Formatter f = new Formatter();
        try {
            this.checkState();
            this._showStatus(f, true, type);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(5000);
            t.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
        }
        return f.toString();
    }

    protected void _showStatus(Formatter f, boolean summaryOnly, String type) throws IOException {
    }

    protected String getPath() {
        return this.parent.getUrlPath();
    }

    protected abstract void updateCollection(State var1, CollectionUpdateType var2);

    protected String getCatalogHref(String what) {
        return InvDatasetFeatureCollection.buildCatalogServiceHref(this.configPath + "/" + what);
    }

    protected void firstInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State checkState() throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.firstInit();
                this.updateCollection(this.state, this.config.updateConfig.updateType);
                this.first = false;
            }
            localState = this.state.copy();
        }
        return localState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CollectionUpdateType force) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.state = this.checkState();
                this.state.lastInvChange = System.currentTimeMillis();
                return;
            }
            localState = this.state.copy();
        }
        this.updateCollection(localState, force);
        localState.lastInvChange = System.currentTimeMillis();
        object = this.lock;
        synchronized (object) {
            this.state = localState;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getLatestFileName() {
        if (this.config.gribConfig.latestNamer != null) {
            return this.config.gribConfig.latestNamer;
        }
        return "Latest " + this.name + " File";
    }

    public String getTopDirectoryLocation() {
        return this.topDirectory;
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public MCollection getDatasetCollectionManager() {
        return this.datasetCollection;
    }

    public Logger getLogger() {
        return logger;
    }

    protected String makeFullName(DatasetNode ds) {
        if (ds.getParent() == null) {
            return ds.getName();
        }
        String parentName = this.makeFullName(ds.getParent());
        if (parentName == null || parentName.length() == 0) {
            return ds.getName();
        }
        return parentName + "/" + ds.getName();
    }

    public abstract CatalogBuilder makeCatalog(String var1, String var2, URI var3) throws IOException;

    protected abstract DatasetBuilder makeDatasetTop(URI var1, State var2) throws IOException;

    protected CatalogBuilder makeCatalogTop(URI catURI, State localState) throws IOException, URISyntaxException {
        Catalog parentCatalog = this.parent.getParentCatalog();
        CatalogBuilder topCatalog = new CatalogBuilder();
        topCatalog.setName(this.makeFullName((DatasetNode)this.parent));
        topCatalog.setVersion(parentCatalog.getVersion());
        topCatalog.setBaseURI(catURI);
        DatasetBuilder top = this.makeDatasetTop(catURI, localState);
        topCatalog.addDataset(top);
        topCatalog.addService(this.virtualService);
        return topCatalog;
    }

    protected CatalogBuilder makeCatalogFiles(URI catURI, State localState, List<String> filenames, boolean addLatest) throws IOException {
        Catalog parentCatalog = this.parent.getParentCatalog();
        CatalogBuilder result = new CatalogBuilder();
        result.setName(this.makeFullName((DatasetNode)this.parent));
        result.setVersion(parentCatalog.getVersion());
        result.setBaseURI(catURI);
        result.addService(this.orgService);
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferInheritedMetadata((DatasetNode)this.parent);
        top.setName(FILES);
        ThreddsMetadata tmi = top.getInheritableMetadata();
        tmi.set("TimeCoverage", null);
        if (localState.coverage != null) {
            tmi.set("GeospatialCoverage", (Object)localState.coverage);
        }
        tmi.set("ServiceName", (Object)this.orgService.getName());
        result.addDataset(top);
        if (addLatest) {
            DatasetBuilder latest = new DatasetBuilder(top);
            latest.setName(this.getLatestFileName());
            latest.put("UrlPath", (Object)LATEST_DATASET_CATALOG);
            latest.put("Id", (Object)LATEST_DATASET_CATALOG);
            latest.put("ServiceName", (Object)this.latestService.getName());
            latest.addServiceToCatalog(this.latestService);
            top.addDataset(latest);
        }
        ArrayList<String> sortedFilenames = new ArrayList<String>(filenames);
        Collections.sort(sortedFilenames, String.CASE_INSENSITIVE_ORDER);
        if (!this.config.getSortFilesAscending()) {
            Collections.reverse(sortedFilenames);
        }
        for (String f : sortedFilenames) {
            if (!f.startsWith(this.topDirectory)) {
                logger.warn("File {} doesnt start with topDir {}", (Object)f, (Object)this.topDirectory);
            }
            DatasetBuilder ds = new DatasetBuilder(top);
            String fname = f.substring(this.topDirectory.length() + 1);
            ds.setName(fname);
            String lpath = this.configPath + "/files/" + fname;
            ds.put("UrlPath", (Object)lpath);
            ds.put("Id", (Object)lpath);
            ds.put("VariableMapLinkURI", (Object)new ThreddsMetadata.UriResolved(this.makeMetadataLink(lpath, VARIABLES), catURI));
            File file = new File(f);
            ds.put("DataSize", (Object)file.length());
            top.addDataset(ds);
        }
        return result;
    }

    protected String makeMetadataLink(String datasetName, String metadata) {
        return contextName + "/metadata/" + datasetName + metadata;
    }

    protected ThreddsMetadata.UriResolved makeUriResolved(URI baseURI, String href) {
        try {
            String mapUri = URLnaming.resolve((String)baseURI.toString(), (String)href);
            return new ThreddsMetadata.UriResolved(href, new URI(mapUri));
        }
        catch (Exception e) {
            logger.error(" ** Invalid URI= '" + baseURI.toString() + "' href='" + href + "'%n", (Throwable)e);
            return null;
        }
    }

    public CatalogBuilder makeLatest(String matchPath, String reqPath, URI catURI) throws IOException {
        this.checkState();
        Catalog parentCatalog = this.parent.getParentCatalog();
        CatalogBuilder result = new CatalogBuilder();
        result.setName(this.makeFullName((DatasetNode)this.parent));
        result.setVersion(parentCatalog.getVersion());
        result.setBaseURI(catURI);
        result.addService(this.orgService);
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferInheritedMetadata((DatasetNode)this.parent);
        top.setName(this.getLatestFileName());
        top.put("ServiceName", (Object)this.orgService.getName());
        result.addDataset(top);
        MFile mfile = this.datasetCollection.getLatestFile();
        if (mfile == null) {
            return null;
        }
        String mpath = mfile.getPath();
        if (!mpath.startsWith(this.topDirectory)) {
            logger.warn("File {} doesnt start with topDir {}", (Object)mpath, (Object)this.topDirectory);
        }
        String fname = mpath.substring(this.topDirectory.length() + 1);
        String path = "files/" + fname;
        top.put("UrlPath", (Object)(this.configPath + "/" + path));
        top.put("Id", (Object)(this.configPath + "/" + path));
        String lpath = this.configPath + "/" + path;
        top.put("VariableMapLinkURI", (Object)new ThreddsMetadata.UriResolved(this.makeMetadataLink(lpath, VARIABLES), catURI));
        top.put("DataSize", (Object)mfile.getLength());
        return result;
    }

    public FeatureDatasetPoint getPointDataset(String matchPath) throws IOException {
        return null;
    }

    public GridDataset getGridDataset(String matchPath) throws IOException {
        return null;
    }

    public CoverageCollection getGridCoverage(String matchPath) throws IOException {
        return null;
    }

    public SimpleGeometryFeatureDataset getSimpleGeometryDataset(String matchPath) throws IOException {
        return null;
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equalsIgnoreCase(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            DatasetUrl durl = DatasetUrl.create(null, (String)filename);
            return NetcdfDatasets.acquireDataset(null, (DatasetUrl)durl, null, (int)-1, null, null);
        }
        GridDataset gds = this.getGridDataset(matchPath);
        return gds == null ? null : (NetcdfDataset)gds.getNetcdfFile();
    }

    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        int pos = remaining.indexOf(FILES);
        StringBuilder fname = new StringBuilder(this.topDirectory);
        if (!this.topDirectory.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + FILES.length() + 1) : remaining);
        return new File(fname.toString());
    }

    static {
        contextName = "/thredds";
    }

    protected class State {
        protected ThreddsMetadata.VariableGroup vars;
        protected ThreddsMetadata.GeospatialCoverage coverage;
        protected CalendarDateRange dateRange;
        protected long lastInvChange;
        protected long lastProtoChange;

        protected State(State from) {
            if (from != null) {
                this.vars = from.vars;
                this.coverage = from.coverage;
                this.dateRange = from.dateRange;
                this.lastProtoChange = from.lastProtoChange;
                this.lastInvChange = from.lastInvChange;
            }
        }

        protected State copy() {
            return new State(this);
        }
    }
}

