/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin.collection;

import com.coverity.security.Escape;
import com.google.common.eventbus.EventBus;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import thredds.core.DataRootManager;
import thredds.core.DatasetManager;
import thredds.featurecollection.CollectionUpdater;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.inventory.CollectionUpdateEvent;
import thredds.inventory.CollectionUpdateType;
import thredds.server.admin.DebugCommands;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component
public class CollectionControllerCommon
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    static final String SHOW_COLLECTION = "showCollection";
    static final String SHOW = "showStatus";
    static final String SHOW_CSV = "showStatus.csv";
    static final String DOWNLOAD = "download";
    static final String DOWNLOAD_ALL = "downloadAll";
    static final String TRIGGER = "trigger";
    final DebugCommands debugCommands;
    final DataRootManager dataRootManager;
    private final TdsContext tdsContext;
    private final DatasetManager datasetManager;
    private final EventBus eventBus;
    final CollectionUpdater collectionUpdater;

    public CollectionControllerCommon(DebugCommands debugCommands, DataRootManager dataRootManager, TdsContext tdsContext, DatasetManager datasetManager, @Qualifier(value="fcTriggerEventBus") EventBus eventBus, CollectionUpdater collectionUpdater) {
        this.debugCommands = debugCommands;
        this.dataRootManager = dataRootManager;
        this.tdsContext = tdsContext;
        this.datasetManager = datasetManager;
        this.eventBus = eventBus;
        this.collectionUpdater = collectionUpdater;
    }

    public void afterPropertiesSet() {
        DebugCommands.Category debugHandler = this.debugCommands.findCategory("Collections");
        DebugCommands.Action act = new DebugCommands.Action(SHOW_COLLECTION, "Show Collections"){

            @Override
            public void doAction(DebugCommands.Event e) {
                List<FeatureCollectionRef> fcList = CollectionControllerCommon.this.dataRootManager.getFeatureCollections();
                fcList.sort(Comparator.comparing(FeatureCollectionRef::getCollectionName));
                for (FeatureCollectionRef fc : fcList) {
                    String uriParam = Escape.uriParam((String)fc.getCollectionName());
                    String url = CollectionControllerCommon.this.tdsContext.getContextPath() + "/admin/collection/showCollection?collection=" + uriParam;
                    e.pw.printf("<p/><a href='%s'>%s</a> (%s)%n", url, fc.getCollectionName(), fc.getName());
                    FeatureCollectionConfig config = fc.getConfig();
                    if (config == null) continue;
                    e.pw.printf("%s%n", config.spec);
                }
                String url = CollectionControllerCommon.this.tdsContext.getContextPath() + "/admin/collection/showStatus";
                e.pw.printf("<p/><a href='%s'>Show All Collection Status</a>%n", url);
                url = CollectionControllerCommon.this.tdsContext.getContextPath() + "/admin/collection/showStatus.csv";
                e.pw.printf("<p/><a href='%s'>Collection Status CSV</a>%n", url);
                url = CollectionControllerCommon.this.tdsContext.getContextPath() + "/admin/collection/downloadAll";
                e.pw.printf("<p/><a href='%s'>Download All top-level collection indices</a>%n", url);
            }
        };
        debugHandler.addAction(act);
        act = new DebugCommands.Action("sched", "Show FeatureCollection update scheduler"){

            @Override
            public void doAction(DebugCommands.Event e) {
                Scheduler scheduler = CollectionControllerCommon.this.collectionUpdater.getScheduler();
                if (scheduler == null) {
                    return;
                }
                try {
                    e.pw.println(scheduler.getMetaData());
                    for (String group : scheduler.getJobGroupNames()) {
                        e.pw.println("Group " + group);
                        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Job " + jobKey.getName());
                            e.pw.println("    " + String.valueOf(scheduler.getJobDetail(jobKey)));
                        }
                        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Trigger " + triggerKey.getName());
                            e.pw.println("    " + String.valueOf(scheduler.getTrigger(triggerKey)));
                        }
                    }
                }
                catch (SchedulerException se) {
                    e.pw.println("Error on scheduler " + se.getMessage());
                    CollectionControllerCommon.this.log.error("Error on scheduler {}", (Object)se.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    ResponseEntity<String> showCollection(String collection) {
        Formatter out = new Formatter();
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collection);
        HttpStatus status = HttpStatus.OK;
        if (want == null) {
            status = HttpStatus.NOT_FOUND;
            out.format("NOT FOUND", new Object[0]);
        } else {
            out.format("<h3>Collection %s</h3>%n%n", Escape.html((String)collection));
            this.showFeatureCollection(out, want);
            String uriParam = Escape.uriParam((String)want.getCollectionName());
            String url = this.tdsContext.getContextPath() + "/admin/collection/trigger?collection=" + uriParam + "&trigger=";
            out.format("<p/><a href='%s'>Send 'nocheck' trigger to %s</a>%n", url + String.valueOf(CollectionUpdateType.nocheck), Escape.html((String)want.getCollectionName()));
            out.format("<p/><a href='%s'>Send 'test' trigger to %s</a>%n", url + String.valueOf(CollectionUpdateType.test), Escape.html((String)want.getCollectionName()));
            String url2 = this.tdsContext.getContextPath() + "/admin/collection/download?collection=" + uriParam;
            out.format("<p/><a href='%s'>Download index file for %s</a>%n", url2, Escape.html((String)want.getCollectionName()));
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, (HttpStatusCode)status);
    }

    ResponseEntity<String> showCollectionStatus() {
        Formatter out = new Formatter();
        List<FeatureCollectionRef> fcList = this.dataRootManager.getFeatureCollections();
        fcList.sort(Comparator.comparing(FeatureCollectionRef::getCollectionName));
        for (FeatureCollectionRef fc : fcList) {
            String uriParam = Escape.uriParam((String)fc.getCollectionName());
            String url = this.tdsContext.getContextPath() + "/admin/collection/showCollection?collection=" + uriParam;
            out.format("<p/><a href='%s'>%s</a> (%s)%n", url, fc.getCollectionName(), fc.getName());
            try {
                InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
                out.format("<pre>%s</pre>%n", fcd.showStatusShort("txt"));
            }
            catch (IOException e) {
                out.format("<pre> %s</pre>%n", e.getMessage());
            }
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    ResponseEntity<String> showCollectionStatusCsv() {
        Formatter out = new Formatter();
        List<FeatureCollectionRef> fcList = this.dataRootManager.getFeatureCollections();
        fcList.sort(Comparator.comparing(o -> o.getConfig().type.toString()).thenComparing(FeatureCollectionRef::getCollectionName));
        out.format("%s, %s, %s, %s, %s, %s, %s, %s, %s%n", COLLECTION, "ed", "type", "group", "nrecords", "ndups", "%", "nmiss", "%");
        for (FeatureCollectionRef fc : fcList) {
            if (fc.getConfig().type != FeatureCollectionType.GRIB1 && fc.getConfig().type != FeatureCollectionType.GRIB2) continue;
            try {
                InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
                out.format("%s", fcd.showStatusShort("csv"));
            }
            catch (IOException ioe) {
                out.format("<pre> %s</pre>%n", ioe.getMessage());
            }
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    ResponseEntity<String> triggerFeatureCollection(HttpServletRequest req, HttpServletResponse res) {
        Formatter out = new Formatter();
        CollectionUpdateType triggerType = null;
        String triggerTypeS = req.getParameter(TRIGGER);
        try {
            triggerType = CollectionUpdateType.valueOf((String)triggerTypeS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (triggerType == null) {
            res.setStatus(400);
            out.format(" TRIGGER Type '%s' not legal%n", Escape.html((String)triggerTypeS));
            return null;
        }
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collectName);
        if (want == null) {
            res.setStatus(404);
            out.format("NOT FOUND", new Object[0]);
        } else {
            out.format("<h3>Collection %s</h3>%n", Escape.html((String)collectName));
            if (!want.getConfig().isTrigggerOk()) {
                res.setStatus(403);
                out.format(" TRIGGER NOT ENABLED%n", new Object[0]);
            } else {
                this.eventBus.post((Object)new CollectionUpdateEvent(triggerType, collectName, TRIGGER));
                out.format(" TRIGGER SENT%n", new Object[0]);
            }
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)out.toString(), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    protected void downloadAll(HttpServletRequest req, HttpServletResponse res) throws IOException {
        File tempFile = File.createTempFile("CollectionIndex", ".zip");
        tempFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tempFile.getPath());){
            ZipOutputStream zout = new ZipOutputStream(fos);
            for (FeatureCollectionRef fc : this.dataRootManager.getFeatureCollections()) {
                File idxFile = GribCdmIndex.getTopIndexFileFromConfig((FeatureCollectionConfig)fc.getConfig());
                if (idxFile == null) continue;
                ZipEntry entry = new ZipEntry(idxFile.getName());
                zout.putNextEntry(entry);
                IO.copyFile((String)idxFile.getPath(), (OutputStream)zout);
                zout.closeEntry();
            }
            zout.close();
        }
        ServletUtil.returnFile(req, res, tempFile, ContentType.binary.toString());
    }

    protected ResponseEntity<String> downloadIndex(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String collectName = StringUtil2.unescape((String)req.getParameter(COLLECTION));
        FeatureCollectionRef want = this.dataRootManager.findFeatureCollection(collectName);
        if (want == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)(Escape.html((String)collectName) + " NOT FOUND"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        File idxFile = GribCdmIndex.getTopIndexFileFromConfig((FeatureCollectionConfig)want.getConfig());
        if (idxFile == null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)(Escape.html((String)collectName) + " NOT FOUND"), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ServletUtil.returnFile(req, res, idxFile, ContentType.binary.toString());
        return null;
    }

    private void showFeatureCollection(Formatter out, FeatureCollectionRef fc) {
        FeatureCollectionConfig config = fc.getConfig();
        if (config != null) {
            Formatter f = new Formatter();
            config.show(f);
            out.format("%n<pre>%s%n</pre>", f);
        }
        try {
            InvDatasetFeatureCollection fcd = this.datasetManager.openFeatureCollection(fc);
            out.format("%n<pre>%n", new Object[0]);
            fcd.showStatus(out);
            out.format("%n</pre>%n", new Object[0]);
        }
        catch (IOException ioe) {
            out.format("<pre> %s</pre>%n", ioe.getMessage());
        }
    }
}

