/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.net.URI;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.server.catalogservice.CatalogViewContextParser;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.catalogservice.RemoteCatalogRequestValidator;
import thredds.server.config.HtmlConfigBean;
import thredds.server.config.TdsContext;
import thredds.server.exception.ServiceNotAllowed;
import thredds.util.ContentType;

@Controller
@RequestMapping(value={"/remoteCatalogService"})
public class RemoteCatalogServiceController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AllowedServices allowedServices;
    @Autowired
    private HtmlConfigBean htmlConfig;
    @Autowired
    private CatalogViewContextParser parser;
    @Autowired
    TdsContext tdsContext;

    @InitBinder(value={"remoteCatalogRequest"})
    protected void initRemoteCatalogRequestBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new RemoteCatalogRequestValidator());
    }

    @RequestMapping(method={RequestMethod.GET})
    protected ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response, @Valid RemoteCatalogRequest params, BindingResult validationResult) throws Exception {
        if (!this.allowedServices.isAllowed(StandardService.catalogRemote)) {
            throw new ServiceNotAllowed(StandardService.catalogRemote.toString());
        }
        if (validationResult.hasErrors()) {
            throw new BindException(validationResult);
        }
        URI uri = params.getCatalogUri();
        CatalogBuilder builder = new CatalogBuilder();
        Catalog catalog = builder.buildFromURI(uri);
        if (builder.hasFatalError() || catalog == null) {
            Formatter f = new Formatter();
            f.format("Error reading catalog '%s' err=%s%n", uri, builder.getErrorMessage());
            if (!uri.toString().toLowerCase(Locale.ROOT).endsWith(".xml")) {
                f.format("Expected catalog uri = '%s' to end with '.xml'", uri);
            }
            this.log.debug(f.toString());
            response.sendError(400, f.toString());
            return null;
        }
        String mess = builder.getErrorMessage();
        if (mess.length() > 0) {
            System.out.printf(" parse Messages = %s%n", builder.getErrorMessage());
        }
        switch (params.getCommand()) {
            case SHOW: {
                if (params.isHtmlView()) {
                    response.setContentType(ContentType.html.getContentHeader());
                    return new ModelAndView("templates/catalog", this.parser.getCatalogViewContext(catalog, request, false));
                }
                response.setContentType(ContentType.xml.getContentHeader());
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
            }
            case SUBSET: {
                String datasetId = params.getDataset();
                Dataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + HtmlUtils.htmlEscape((String)datasetId) + "] in catalog [" + String.valueOf(uri) + "].";
                    this.log.info("handleRequestInternal(): " + msg);
                    response.sendError(400, msg);
                    return null;
                }
                if (params.isHtmlView()) {
                    response.setContentType(ContentType.html.getContentHeader());
                    return new ModelAndView("templates/dataset", this.parser.getDatasetViewContext(dataset, request, false));
                }
                Catalog subsetCat = catalog.subsetCatalogOnDataset(dataset);
                response.setContentType(ContentType.xml.getContentHeader());
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            case VALIDATE: {
                response.setContentType(ContentType.html.getContentHeader());
                return RemoteCatalogServiceController.constructValidationMessageModelAndView(uri, builder.getValidationMessage(), this.htmlConfig);
            }
        }
        String msg = "Unsupported request command [" + String.valueOf((Object)params.getCommand()) + "].";
        this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
        response.sendError(400, msg);
        return null;
    }

    public static ModelAndView constructValidationMessageModelAndView(URI uri, String validationMessage, HtmlConfigBean htmlConfig) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("catalogUrl", uri);
        model.put("message", validationMessage);
        htmlConfig.addHtmlConfigInfoToModel(model);
        return new ModelAndView("/thredds/server/catalogservice/validationMessage", model);
    }
}

