/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dap4;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.servlet.CDMWrap;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;

@Controller
@RequestMapping(value={"/dap4"})
public class Dap4Controller
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final String SERVICEID = "/dap4";
    static Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    @Autowired
    private TdsContext tdscontext;

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        super.handleRequest(req, res);
    }

    protected void doFavicon(String icopath, DapContext cxt) throws IOException {
        throw new UnsupportedOperationException("Favicon");
    }

    protected void doCapabilities(DapRequest drq, DapContext cxt) throws IOException {
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, DapUtil.UTF8));
        pw.println("Capabilities page not supported");
        pw.flush();
    }

    public long getBinaryWriteLimit() {
        return 100000000L;
    }

    public String getServletID() {
        StringBuilder id;
        String cp = this.tdscontext.getContextPath();
        if (cp == null || cp.length() == 0) {
            cp = "dap4";
        }
        if ((id = new StringBuilder(cp)).charAt(id.length() - 1) == '/') {
            id.deleteCharAt(id.length());
        }
        if (id.charAt(0) != '/') {
            id.insert(0, '/');
        }
        return id.toString();
    }

    public String getWebContentRoot(DapRequest drq) throws DapException {
        File root = this.tdscontext.getServletRootDirectory();
        if (!(root.exists() && root.canRead() && root.isDirectory())) {
            throw new DapException("Cannot locate WEB-INF root").setCode(404);
        }
        String rootpath = root.getAbsolutePath() + "/WEB-INF";
        return DapUtil.canonicalpath((String)rootpath);
    }

    public CDMWrap getCDMWrap(DapRequest drq) throws IOException {
        String prefix;
        String datasetPath = drq.getDatasetPath();
        if (datasetPath.startsWith(prefix = "/dap4/")) {
            datasetPath = datasetPath.substring(prefix.length());
        }
        NetcdfFile ncf = TdsRequestedDataset.getNetcdfFile(drq.getRequest(), drq.getResponse(), datasetPath);
        NetcdfDataset ncd = NetcdfDataset.wrap((NetcdfFile)ncf, ENHANCEMENT);
        return new CDMWrap().open(ncd);
    }
}

