/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.ft.StationFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class StationWriterUtils {
    public static List<StationFeature> getStationsInSubset(StationFeatureCollection stationFeatCol, SubsetParams ncssParams) throws IOException {
        List wantedStations;
        if (ncssParams.getStations() != null) {
            List stnNames = ncssParams.getStations();
            wantedStations = ((String)stnNames.get(0)).equals("all") ? stationFeatCol.getStationFeatures() : stationFeatCol.getStationFeatures(stnNames);
        } else if (ncssParams.getLatLonBoundingBox() != null) {
            LatLonRect llrect = ncssParams.getLatLonBoundingBox();
            wantedStations = stationFeatCol.getStationFeatures(llrect);
        } else if (ncssParams.getLatLonPoint() != null) {
            Station closestStation = StationWriterUtils.findClosestStation(stationFeatCol, ncssParams.getLatLonPoint());
            ArrayList<String> stnList = new ArrayList<String>();
            stnList.add(closestStation.getName());
            wantedStations = stationFeatCol.getStationFeatures(stnList);
        } else {
            wantedStations = stationFeatCol.getStationFeatures();
        }
        return wantedStations;
    }

    public static Station findClosestStation(StationFeatureCollection stationFeatCol, LatLonPoint pt) {
        double lat = pt.getLatitude();
        double lon = pt.getLongitude();
        double cos = Math.cos(Math.toRadians(lat));
        List stations = stationFeatCol.getStationFeatures();
        Station min_station = (Station)stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLatitude();
            double lon1 = LatLonPoints.lonNormal((double)s.getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station;
    }
}

