/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.tools.CatalogXmlWriter;
import thredds.util.ContentType;

public class InvCatalogXmlView
extends AbstractView {
    private static final Logger logger = LoggerFactory.getLogger(InvCatalogXmlView.class);

    protected void renderMergedOutputModel(Map model, HttpServletRequest req, HttpServletResponse res) throws Exception {
        block11: {
            res.setContentType(this.getContentType());
            try {
                if (model == null || model.isEmpty()) {
                    throw new IllegalArgumentException("Model must not be null or empty.");
                }
                if (!model.containsKey("catalog")) {
                    throw new IllegalArgumentException("Model must contain 'catalog' key.");
                }
                Object o = model.get("catalog");
                if (!(o instanceof Catalog)) {
                    throw new IllegalArgumentException("Model must contain a Catalog object.");
                }
                Catalog cat = (Catalog)o;
                if (req.getMethod().equals("HEAD")) break block11;
                try (ServletOutputStream os = res.getOutputStream();){
                    CatalogXmlWriter catFactory = new CatalogXmlWriter();
                    catFactory.writeXML(cat, (OutputStream)os);
                }
            }
            catch (Exception e) {
                logger.error("InvCatalogXmlView failed", (Throwable)e);
            }
        }
    }

    public String getContentType() {
        return ContentType.xml.getContentHeader();
    }
}

