/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractView;
import thredds.util.ContentType;

@Component
public class XsltForHtmlView
extends AbstractView {
    protected void renderMergedOutputModel(Map model, HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setContentType(this.getContentType());
        Document doc = (Document)model.get("Document");
        String transform = (String)model.get("Transform");
        String resourceName = "/resources/xsl/" + transform;
        ClassPathResource resource = new ClassPathResource(resourceName);
        try (InputStream is = resource.getInputStream();){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
            transformer.setParameter("tdsContext", req.getContextPath());
            JDOMSource in = new JDOMSource(doc);
            JDOMResult out = new JDOMResult();
            transformer.transform((Source)in, (Result)out);
            Document html = out.getDocument();
            if (html == null) {
                throw new IllegalStateException("Bad XSLT=" + resourceName);
            }
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(html, (OutputStream)res.getOutputStream());
        }
    }

    public String getContentType() {
        return ContentType.html.getContentHeader();
    }
}

