/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import thredds.server.config.ThreddsConfig;
import thredds.server.wms.ThreddsWmsCatalogue;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import uk.ac.rdg.resc.edal.exceptions.EdalException;
import uk.ac.rdg.resc.edal.graphics.exceptions.EdalLayerNotFoundException;
import uk.ac.rdg.resc.edal.wms.RequestParams;
import uk.ac.rdg.resc.edal.wms.WmsCatalogue;
import uk.ac.rdg.resc.edal.wms.WmsServlet;

@Controller
@RequestMapping(value={"/wms"})
public class ThreddsWmsServlet
extends WmsServlet
implements InitializingBean {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static final Logger logger = LoggerFactory.getLogger(ThreddsWmsServlet.class);
    private static final Map<String, String> defaultStyles = Collections.singletonMap("styles", "default");
    private static boolean allow;
    @Autowired
    private TdsContext tdsContext;
    private static final RemovalListener<String, CachedWmsCatalogue> removalListener;
    private static final Cache<String, CachedWmsCatalogue> catalogueCache;

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getDisplayName().equals("Root WebApplicationContext")) {
            allow = ThreddsConfig.getBoolean("WMS.allow", true);
            startupLog.info("WMS:allow= " + allow);
            if (!allow) {
                startupLog.info("WMS service not enabled in threddsConfig.xml: ");
            }
        }
    }

    public void afterPropertiesSet() throws ServletException {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!allow) {
            httpServletResponse.sendError(404, "WMS service not enabled");
            return;
        }
        super.doGet(httpServletRequest, httpServletResponse);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    protected void dispatchWmsRequest(String request, RequestParams params, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WmsCatalogue wmsCatalogue) throws Exception {
        String removePrefix = null;
        TdsRequestedDataset tdsDataset = new TdsRequestedDataset(httpServletRequest, removePrefix);
        ThreddsWmsCatalogue catalogue = this.acquireCatalogue(httpServletRequest, httpServletResponse, tdsDataset.getPath());
        if (request.equals("GetMap") && params.getString("styles", "").isEmpty()) {
            params = params.mergeParameters(defaultStyles);
        }
        super.dispatchWmsRequest(request, params, httpServletRequest, httpServletResponse, (WmsCatalogue)catalogue);
    }

    private ThreddsWmsCatalogue acquireCatalogue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String tdsDatasetPath) throws IOException {
        ThreddsWmsServlet.invalidateIfOutdated(tdsDatasetPath);
        try {
            CachedWmsCatalogue catalogue = (CachedWmsCatalogue)catalogueCache.get((Object)tdsDatasetPath, () -> {
                NetcdfDataset ncd = ThreddsWmsServlet.acquireNetcdfDataset(httpServletRequest, httpServletResponse, tdsDatasetPath);
                if (ncd.getLocation() == null) {
                    ncd.close();
                    throw new EdalLayerNotFoundException("The requested dataset is not available on this server");
                }
                try {
                    ThreddsWmsCatalogue threddsWmsCatalogue = new ThreddsWmsCatalogue(ncd, tdsDatasetPath);
                    return new CachedWmsCatalogue(threddsWmsCatalogue, ncd.getLastModified());
                }
                catch (EdalException e) {
                    ncd.close();
                    throw e;
                }
            });
            return catalogue.wmsCatalogue;
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof EdalException) {
                throw (EdalException)e.getCause();
            }
            throw e;
        }
    }

    private static void invalidateIfOutdated(String tdsDatasetPath) {
        CachedWmsCatalogue cachedWmsCatalogue = (CachedWmsCatalogue)catalogueCache.getIfPresent((Object)tdsDatasetPath);
        if (cachedWmsCatalogue != null && cachedWmsCatalogue.lastModified != cachedWmsCatalogue.wmsCatalogue.getLastModified()) {
            catalogueCache.invalidate((Object)tdsDatasetPath);
        }
    }

    private static NetcdfDataset acquireNetcdfDataset(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String tdsDatasetPath) throws IOException {
        NetcdfFile ncf = TdsRequestedDataset.getNetcdfFile(httpServletRequest, httpServletResponse, tdsDatasetPath);
        if (TdsRequestedDataset.useNetcdfJavaBuilders()) {
            return NetcdfDatasets.enhance((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
        }
        return NetcdfDataset.wrap((NetcdfFile)ncf, (Set)NetcdfDataset.getDefaultEnhanceMode());
    }

    public static void showCache(Formatter formatter) {
        formatter.format("%nWmsCache:%n", new Object[0]);
        formatter.format("numberOfEntries=%d, ", ThreddsWmsServlet.getNumberOfEntries());
        formatter.format("loads=%d, ", ThreddsWmsServlet.getCacheLoads());
        formatter.format("evictionCount=%d ", catalogueCache.stats().evictionCount());
        formatter.format("%nentries:%n", new Object[0]);
        for (Map.Entry entry : catalogueCache.asMap().entrySet()) {
            formatter.format("  %s%n", entry.getKey());
        }
    }

    public static void resetCache() {
        catalogueCache.invalidateAll();
    }

    static boolean containsCachedCatalogue(String tdsDatasetPath) {
        return catalogueCache.asMap().containsKey(tdsDatasetPath);
    }

    static long getNumberOfEntries() {
        return catalogueCache.size();
    }

    static long getCacheLoads() {
        return catalogueCache.stats().loadCount();
    }

    static {
        removalListener = notification -> {
            try {
                ((CachedWmsCatalogue)notification.getValue()).wmsCatalogue.close();
            }
            catch (IOException e) {
                logger.warn("Could not close {}, exception = {}", notification.getKey(), (Object)e);
            }
        };
        catalogueCache = CacheBuilder.newBuilder().maximumSize(100L).removalListener(removalListener).recordStats().build();
    }

    private static class CachedWmsCatalogue {
        public final ThreddsWmsCatalogue wmsCatalogue;
        public final long lastModified;

        public CachedWmsCatalogue(ThreddsWmsCatalogue wmsCatalogue, long lastModified) {
            this.wmsCatalogue = wmsCatalogue;
            this.lastModified = lastModified;
        }
    }
}

