/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms.config;

import java.awt.Color;
import org.jdom2.Element;
import thredds.server.wms.config.WmsConfigException;
import uk.ac.rdg.resc.edal.domain.Extent;
import uk.ac.rdg.resc.edal.exceptions.EdalParseException;
import uk.ac.rdg.resc.edal.graphics.utils.GraphicsUtils;
import uk.ac.rdg.resc.edal.util.Extents;

public class LayerSettings {
    private Boolean allowFeatureInfo = null;
    private Extent<Float> defaultColorScaleRange = null;
    private Color defaultAboveMaxColor;
    private Color defaultBelowMinColor;
    private Color defaultNoDataColor = null;
    private Float defaultOpacity = null;
    private String defaultPaletteName = null;
    private Boolean logScaling = null;
    private Boolean intervalTime = null;
    private Integer defaultNumColorBands = null;

    LayerSettings(Element parentElement) throws WmsConfigException {
        if (parentElement == null) {
            return;
        }
        this.allowFeatureInfo = LayerSettings.getBoolean(parentElement, "allowFeatureInfo");
        this.defaultColorScaleRange = LayerSettings.getRange(parentElement, "defaultColorScaleRange");
        this.defaultAboveMaxColor = LayerSettings.getColor(parentElement, "defaultAboveMaxColor");
        this.defaultBelowMinColor = LayerSettings.getColor(parentElement, "defaultBelowMinColor");
        this.defaultNoDataColor = LayerSettings.getColor(parentElement, "defaultNoDataColor");
        this.defaultOpacity = LayerSettings.getFloat(parentElement, "defaultOpacity", (Extent<Float>)Extents.newExtent((Object)Float.valueOf(0.0f), (Object)Float.valueOf(100.0f)));
        this.defaultPaletteName = parentElement.getChildTextTrim("defaultPaletteName");
        if (this.defaultPaletteName != null && this.defaultPaletteName.isEmpty()) {
            throw new WmsConfigException("defaultPaletteName must contain a value");
        }
        this.defaultNumColorBands = LayerSettings.getInteger(parentElement, "defaultNumColorBands", (Extent<Integer>)Extents.newExtent((Object)5, (Object)250));
        this.logScaling = LayerSettings.getBoolean(parentElement, "logScaling");
        this.intervalTime = LayerSettings.getBoolean(parentElement, "intervalTime");
        if (this.intervalTime == null) {
            this.intervalTime = false;
        }
    }

    LayerSettings() {
    }

    private static Boolean getBoolean(Element parentElement, String childName) throws WmsConfigException {
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new WmsConfigException("Value of " + childName + " must be true or false");
    }

    private static Integer getInteger(Element parentElement, String childName, Extent<Integer> validRange) throws WmsConfigException {
        int val;
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new WmsConfigException(nfe);
        }
        if (val < (Integer)validRange.getLow()) {
            return (Integer)validRange.getLow();
        }
        if (val > (Integer)validRange.getHigh()) {
            return (Integer)validRange.getHigh();
        }
        return val;
    }

    private static Float getFloat(Element parentElement, String childName, Extent<Float> validRange) throws WmsConfigException {
        float val;
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        try {
            val = Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            throw new WmsConfigException(nfe);
        }
        if (val < ((Float)validRange.getLow()).floatValue()) {
            return (Float)validRange.getLow();
        }
        if (val > ((Float)validRange.getHigh()).floatValue()) {
            return (Float)validRange.getHigh();
        }
        return Float.valueOf(val);
    }

    private static Color getColor(Element parentElement, String childName) throws WmsConfigException {
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        try {
            return GraphicsUtils.parseColour((String)str);
        }
        catch (EdalParseException e) {
            throw new WmsConfigException(String.format("Invalid color value in %s", str));
        }
    }

    private static Extent<Float> getRange(Element parentElement, String childName) throws WmsConfigException {
        String str = parentElement.getChildTextTrim(childName);
        if (str == null) {
            return null;
        }
        String[] els = str.split(" ");
        if (els.length != 2) {
            throw new WmsConfigException("Invalid range format");
        }
        try {
            float min = Float.parseFloat(els[0]);
            float max = Float.parseFloat(els[1]);
            return Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max));
        }
        catch (NumberFormatException nfe) {
            throw new WmsConfigException("Invalid floating-point value in range");
        }
    }

    public Boolean isAllowFeatureInfo() {
        return this.allowFeatureInfo;
    }

    public Extent<Float> getDefaultColorScaleRange() {
        return this.defaultColorScaleRange;
    }

    public Color getDefaultAboveMaxColor() {
        return this.defaultAboveMaxColor;
    }

    public Color getDefaultBelowMinColor() {
        return this.defaultBelowMinColor;
    }

    public Color getDefaultNoDataColor() {
        return this.defaultNoDataColor;
    }

    public Float getDefaultOpacity() {
        return this.defaultOpacity;
    }

    public String getDefaultPaletteName() {
        return this.defaultPaletteName;
    }

    public Boolean isLogScaling() {
        return this.logScaling;
    }

    @Deprecated
    public boolean isIntervalTime() {
        return this.intervalTime;
    }

    public Integer getDefaultNumColorBands() {
        return this.defaultNumColorBands;
    }

    void replaceNullValues(LayerSettings newSettings) {
        if (this.allowFeatureInfo == null) {
            this.allowFeatureInfo = newSettings.allowFeatureInfo;
        }
        if (this.defaultColorScaleRange == null) {
            this.defaultColorScaleRange = newSettings.defaultColorScaleRange;
        }
        if (this.defaultAboveMaxColor == null) {
            this.defaultAboveMaxColor = newSettings.defaultAboveMaxColor;
        }
        if (this.defaultBelowMinColor == null) {
            this.defaultBelowMinColor = newSettings.defaultBelowMinColor;
        }
        if (this.defaultNoDataColor == null) {
            this.defaultNoDataColor = newSettings.defaultNoDataColor;
        }
        if (this.defaultOpacity == null) {
            this.defaultOpacity = newSettings.defaultOpacity;
        }
        if (this.defaultPaletteName == null) {
            this.defaultPaletteName = newSettings.defaultPaletteName;
        }
        if (this.logScaling == null) {
            this.logScaling = newSettings.logScaling;
        }
        if (this.intervalTime == null) {
            this.intervalTime = newSettings.intervalTime;
        }
        if (this.defaultNumColorBands == null) {
            this.defaultNumColorBands = newSettings.defaultNumColorBands;
        }
    }

    void setDefaultColorScaleRange(Extent<Float> defaultColorScaleRange) {
        this.defaultColorScaleRange = defaultColorScaleRange;
    }

    public String toString() {
        return String.format("allowFeatureInfo = %s, defaultColorScaleRange = %s, defaultAboveMaxColor = %s, defaultBelowMinColor = %s, defaultNoDataColor = %s, defaultOpacity = %s, defaultPaletteName = %s, defaultNumColorBands = %s, logScaling = %s", this.allowFeatureInfo, this.defaultColorScaleRange, this.defaultAboveMaxColor, this.defaultBelowMinColor, this.defaultNoDataColor, this.defaultOpacity, this.defaultPaletteName, this.defaultNumColorBands, this.logScaling);
    }
}

