/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class HttpHeadFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isHttpHead(httpServletRequest)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            NoBodyResponseWrapper noBodyResponseWrapper = new NoBodyResponseWrapper(httpServletResponse);
            chain.doFilter((ServletRequest)new ForceGetRequestWrapper(httpServletRequest), (ServletResponse)noBodyResponseWrapper);
            noBodyResponseWrapper.setContentLength();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isHttpHead(HttpServletRequest request) {
        return "HEAD".equals(request.getMethod());
    }

    private class NoBodyResponseWrapper
    extends HttpServletResponseWrapper {
        private final NoBodyOutputStream noBodyOutputStream;
        private PrintWriter writer;

        public NoBodyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.noBodyOutputStream = new NoBodyOutputStream();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.noBodyOutputStream;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.noBodyOutputStream), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        void setContentLength() {
            super.setContentLengthLong(this.noBodyOutputStream.getContentLength());
        }
    }

    private class ForceGetRequestWrapper
    extends HttpServletRequestWrapper {
        public ForceGetRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return "GET";
        }
    }

    private class NoBodyOutputStream
    extends ServletOutputStream {
        private long contentLength = 0L;

        private NoBodyOutputStream() {
        }

        long getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            this.contentLength += (long)len;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException("NoBodyOutputStream does not support setWriteListener");
        }
    }
}

