/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import thredds.servlet.UsageLog;
import thredds.servlet.filter.TdsServletResponseWrapper;

public class RequestBracketingLogMessageFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger((String)"threddsServlet");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        TdsServletResponseWrapper response = new TdsServletResponseWrapper((HttpServletResponse)servletResponse);
        if (response.isCommitted()) {
            this.log.error("doFilter(): Yikes! Response is already committed (Heiko's bug?).");
        }
        this.log.info(UsageLog.setupRequestContext(request));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        this.log.info(UsageLog.closingMessageForRequestContext(response.getHttpStatusCode(), response.getHttpResponseBodyLength()));
        MDC.clear();
    }
}

