/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import com.coverity.security.Escape;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;
import thredds.util.StringValidateEncodeUtils;
import thredds.util.TdsPathUtils;

public class RequestPathFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String path = TdsPathUtils.extractPath(request, null);
        if (path != null && (StringValidateEncodeUtils.containsAngleBracketCharacters(path) || !StringValidateEncodeUtils.validPath(path))) {
            String msg = "Invalid request path [" + Escape.html((String)ServletUtil.getRequestPath(request)) + "].";
            this.log.error("doFilter(): " + msg);
            response.sendError(400, msg);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

