/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.core.CatalogManager;
import thredds.core.ConfigCatalogHtmlWriter;
import thredds.core.TdsRequestedDataset;
import thredds.server.catalogservice.CatalogRequest;

@Controller
@RequestMapping(value={"/catalog"})
public class CatalogServiceController {
    @Autowired
    private CatalogManager catalogManager;
    @Autowired
    ConfigCatalogHtmlWriter writer;

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    protected ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response, CatalogRequest params) throws Exception {
        Catalog catalog;
        TdsRequestedDataset reqD = new TdsRequestedDataset(request, "/catalog");
        String path = reqD.getPath();
        boolean isHtml = path.endsWith(".html");
        String catalogPath = path.replaceAll(".html$", ".xml");
        String baseUriString = request.getRequestURL().toString();
        try {
            URI baseUri = new URI(baseUriString);
            catalog = this.catalogManager.getCatalog(catalogPath, baseUri);
        }
        catch (URISyntaxException e) {
            String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
            throw new URISyntaxException(msg, e.getReason());
        }
        if (catalog == null) {
            throw new FileNotFoundException(request.getRequestURI());
        }
        if (params.dataset != null) {
            Dataset dataset = catalog.findDatasetByID(params.dataset);
            if (dataset == null) {
                throw new FileNotFoundException("Did not find dataset [" + params.dataset + "] in catalog [" + baseUriString + "].");
            }
            if (isHtml) {
                int i = this.writer.showDataset(baseUriString, dataset, request, response, true);
                return null;
            }
            Catalog subsetCat = catalog.subsetCatalogOnDataset(dataset);
            return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
        }
        if (isHtml) {
            int i = this.writer.writeCatalog(request, response, catalog, true);
            return null;
        }
        return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
    }
}

