/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dap4;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.DapLog;
import dap4.servlet.DSPFactory;
import dap4.servlet.DapCache;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.TdsRequestedDataset;
import thredds.server.dap4.ThreddsDSP;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;

@Controller
@RequestMapping(value={"/dap4"})
public class Dap4Controller
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    @Autowired
    private ServletContext servletContext;

    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        super.handleRequest(req, res);
    }

    public void initialize() {
        super.initialize();
        try {
            NetcdfFile.iospDeRegister(Nc4Iosp.class);
            NetcdfFile.registerIOProviderPreferred(Nc4Iosp.class, H5iosp.class);
        }
        catch (Exception e) {
            DapLog.warn((String)"Cannot load ucar.nc2.jni.netcdf.Nc4Iosp");
        }
    }

    protected void doFavicon(String icopath, DapContext cxt) throws IOException {
        throw new UnsupportedOperationException("Favicon");
    }

    protected void doCapabilities(DapRequest drq, DapContext cxt) throws IOException {
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, DapUtil.UTF8));
        pw.println("Capabilities page not supported");
        pw.flush();
    }

    public long getBinaryWriteLimit() {
        return 100000000L;
    }

    public String getServletID() {
        return "dap4";
    }

    public String getResourcePath(DapRequest drq, String location) throws DapException {
        String prefix = drq.getResourceRoot();
        String realpath = prefix != null ? DapUtil.canonjoin((String)prefix, (String)location) : TdsRequestedDataset.getLocationFromRequestPath(location);
        if (!TESTING && !TdsRequestedDataset.resourceControlOk(drq.getRequest(), drq.getResponse(), realpath)) {
            throw new DapException("Not authorized: " + location).setCode(403);
        }
        File f = new File(realpath);
        if (!f.exists() || !f.canRead()) {
            throw new DapException("Not found: " + location).setCode(404);
        }
        return realpath;
    }

    static {
        DapCache.setFactory((DSPFactory)new Dap4Factory());
    }

    static class Dap4Factory
    extends DSPFactory {
        public Dap4Factory() {
            DapCache.dspregistry.register(ThreddsDSP.class, true);
        }
    }
}

