/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.InvDatasetFeatureCollection;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import thredds.server.catalog.FeatureCollectionRef;
import ucar.coord.CoordinateRuntime;
import ucar.nc2.AttributeContainer;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static Logger logger = LoggerFactory.getLogger(InvDatasetFcGrib.class);
    private static final String COLLECTION = "collection";
    private static final String BEST_DATASET = GribCollectionImmutable.Type.Best.toString();
    private static final String TWOD_DATASET = GribCollectionImmutable.Type.TwoD.toString();
    private static final String PARTITION_DATASET = "TP";
    private static final String COLLECTION_DATASET = "GC";

    public InvDatasetFcGrib(FeatureCollectionRef parent, FeatureCollectionConfig config) {
        super(parent, config);
        Formatter errlog = new Formatter();
        CollectionSpecParser sp = config.getCollectionSpecParser(errlog);
        this.topDirectory = sp.getRootDir();
        String errs = errlog.toString();
        if (errs.length() > 0) {
            logger.warn("{}: CollectionManager parse error = {} ", (Object)this.name, (Object)errs);
        }
        this.state = new StateGrib(null);
    }

    @Override
    public void close() {
        if (this.state != null) {
            StateGrib stateGrib = (StateGrib)this.state;
            if (stateGrib.gribCollection != null) {
                try {
                    stateGrib.gribCollection.close();
                }
                catch (IOException e) {
                    logger.error("Cant close {}", (Object)stateGrib.gribCollection.getName(), (Object)e);
                }
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _showStatus(Formatter f, boolean summaryOnly, String type) throws IOException {
        StateGrib localState;
        Object object = this.lock;
        synchronized (object) {
            localState = (StateGrib)this.state;
        }
        if (localState.gribCollection != null) {
            if (summaryOnly) {
                localState.gribCollection.showStatusSummary(f, type);
            } else {
                localState.gribCollection.showStatus(f);
            }
        }
    }

    @Override
    protected void updateCollection(InvDatasetFeatureCollection.State state, CollectionUpdateType force) {
        try {
            StateGrib localState = (StateGrib)state;
            GribCollectionImmutable previous = localState.gribCollection;
            GribCollectionImmutable previousLatest = localState.latest;
            localState.latest = null;
            localState.gribCollection = GribCdmIndex.openGribCollection((FeatureCollectionConfig)this.config, (CollectionUpdateType)force, (Logger)logger);
            if (localState.gribCollection == null) {
                logger.error("InvDatasetFcGrib.updateCollection failed " + this.config);
            }
            logger.debug("{}: GribCollection object was recreated", (Object)this.name);
            if (previous != null) {
                previous.close();
            }
            if (previousLatest != null) {
                previousLatest.close();
            }
        }
        catch (IOException ioe) {
            logger.error("GribFc updateCollection", (Throwable)ioe);
        }
    }

    private String makeCollectionShortName(String collectionName) {
        String topCollectionName = this.config.collectionName;
        if (collectionName.equals(topCollectionName)) {
            return topCollectionName;
        }
        if (collectionName.startsWith(topCollectionName)) {
            return this.name + collectionName.substring(topCollectionName.length());
        }
        return collectionName;
    }

    private DatasetBuilder makeDatasetFromCollection(URI catURI, boolean isTop, CatalogBuilder parentCatalog, String parentCollectionName, GribCollectionImmutable fromGc) throws IOException {
        if (fromGc == null) {
            throw new FileNotFoundException("Grib Collection '" + this.getName() + "' does not exist or is empty");
        }
        String dsName = isTop ? this.name : this.makeCollectionShortName(fromGc.getName());
        DatasetBuilder result = new DatasetBuilder(null);
        result.setName(dsName);
        if (this.parent != null) {
            result.transferInheritedMetadata((DatasetNode)this.parent);
        }
        result.addServiceToCatalog(this.virtualService);
        String tpath = this.config.path + "/" + COLLECTION;
        ThreddsMetadata tmi = result.getInheritableMetadata();
        tmi.set("VariableMapLinkURI", (Object)this.makeUriResolved(catURI, this.makeMetadataLink(tpath, "?metadata=variableMap")));
        tmi.set("ServiceName", (Object)this.virtualService.getName());
        tmi.set("DataFormatType", (Object)(fromGc.isGrib1 ? DataFormatType.GRIB1.toString() : DataFormatType.GRIB2.toString()));
        tmi.set("Properties", (Object)Property.convertToProperties((AttributeContainer)fromGc.getGlobalAttributes()));
        tmi.set("FeatureType", (Object)FeatureType.GRID.toString());
        String pathStart = parentCollectionName == null ? this.config.path : this.config.path + "/" + parentCollectionName;
        for (GribCollectionImmutable.Dataset ds : fromGc.getDatasets()) {
            boolean onlyOneFile;
            boolean isSingleGroup = ds.getGroupsSize() == 1;
            Iterable groups = ds.getGroups();
            if (ds.getType() == GribCollectionImmutable.Type.TwoD) {
                if (!this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.TwoD)) continue;
                DatasetBuilder twoD = new DatasetBuilder(result);
                twoD.setName(this.getDatasetNameTwoD(result.getName()));
                String path = pathStart + "/" + TWOD_DATASET;
                twoD.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Two time dimensions: reference and forecast; full access to all GRIB records"));
                result.addDataset(twoD);
                this.makeDatasetsFromGroups(catURI, twoD, path, groups, isSingleGroup);
                continue;
            }
            if (ds.getType() == GribCollectionImmutable.Type.Best) {
                if (!this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) continue;
                DatasetBuilder best = new DatasetBuilder(result);
                best.setName(this.getDatasetNameBest(result.getName()));
                String path = pathStart + "/" + BEST_DATASET;
                best.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Single time dimension: for each forecast time, use GRIB record with smallest offset from reference time"));
                result.addDataset(best);
                this.makeDatasetsFromGroups(catURI, best, path, groups, isSingleGroup);
                continue;
            }
            if (ds.getType() == GribCollectionImmutable.Type.MRUTP) {
                DatasetBuilder tp = new DatasetBuilder(result);
                tp.setName(this.getDatasetNameTP(result.getName()));
                String path = pathStart + "/" + PARTITION_DATASET;
                tp.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Multiple reference, unique time Grib Partition"));
                result.addDataset(tp);
                this.makeDatasetsFromGroups(catURI, tp, path, groups, isSingleGroup);
                continue;
            }
            boolean isFilePartition = this.config.ptype == FeatureCollectionConfig.PartitionType.file;
            boolean bl = onlyOneFile = isFilePartition && fromGc.getFiles().size() == 1;
            if (onlyOneFile) {
                result.addServiceToCatalog(this.orgService);
                tmi.set("ServiceName", (Object)this.orgService.getName());
                MFile mfile = fromGc.getFile(0);
                result.put("DataSize", (Object)mfile.getLength());
                if (mfile.getLastModified() > 0L) {
                    CalendarDate cdate = CalendarDate.of((long)mfile.getLastModified());
                    result.put("Dates", (Object)new DateType(cdate).setType("modified"));
                }
            }
            String path = pathStart;
            if (ds.getType() == GribCollectionImmutable.Type.SRC) {
                CoordinateRuntime runCoord = fromGc.getMasterRuntime();
                assert (runCoord.getSize() == 1);
                CalendarDate runtime = runCoord.getFirstDate();
                result.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Single reference time Grib Collection"));
                result.addToList("Documentation", (Object)new Documentation(null, null, null, "Reference Time", runtime.toString()));
            } else if (ds.getType() == GribCollectionImmutable.Type.MRC) {
                result.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Multiple reference time Grib Collection"));
            } else if (ds.getType() == GribCollectionImmutable.Type.MRUTC) {
                result.addToList("Documentation", (Object)new Documentation(null, null, null, "summary", "Multiple reference, unique time Grib Collection"));
            } else {
                throw new IllegalStateException("Grib Collection '" + this.getName() + "' has illegal type " + ds.getType());
            }
            this.makeDatasetsFromGroups(catURI, result, path, groups, isSingleGroup);
            if (onlyOneFile || !this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Files)) continue;
            this.addFileDatasets(result, path, fromGc);
        }
        if (fromGc instanceof PartitionCollectionImmutable) {
            if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Latest) && parentCollectionName == null) {
                DatasetBuilder ds = new DatasetBuilder(result);
                ds.setName(this.getDatasetNameLatest(result.getName()));
                ds.put("UrlPath", (Object)"latest.xml");
                ds.put("Id", (Object)"latest.xml");
                ds.addServiceToCatalog(this.latestService);
                ds.put("ServiceName", (Object)this.latestService.getName());
                result.addDataset(ds);
            }
            PartitionCollectionImmutable pc = (PartitionCollectionImmutable)fromGc;
            for (PartitionCollectionImmutable.Partition partition : pc.getPartitionsSorted()) {
                DatasetBuilder partDs = this.makeDatasetFromPartition(result, parentCollectionName, partition, pc.isPartitionOfPartitions());
                result.addDataset(partDs);
            }
        }
        return result;
    }

    private void makeDatasetsFromGroups(URI catURI, DatasetBuilder parent, String parentPath, Iterable<GribCollectionImmutable.GroupGC> groups, boolean isSingleGroup) {
        for (GribCollectionImmutable.GroupGC group : groups) {
            String dpath;
            DatasetBuilder ds;
            if (isSingleGroup) {
                ds = parent;
                dpath = parentPath;
                ds.put("Id", (Object)parentPath);
                ds.put("UrlPath", (Object)parentPath);
            } else {
                ds = new DatasetBuilder(parent);
                ds.setName(group.getDescription());
                dpath = parentPath + "/" + group.getId();
                ds.put("Id", (Object)dpath);
                ds.put("UrlPath", (Object)dpath);
                parent.addDataset(ds);
            }
            ThreddsMetadata tmi = ds.getInheritableMetadata();
            tmi.set("GeospatialCoverage", (Object)this.extractGeospatial(group));
            tmi.set("TimeCoverage", (Object)new DateRange(group.makeCalendarDateRange()));
            tmi.set("VariableMapLinkURI", (Object)this.makeUriResolved(catURI, this.makeMetadataLink(dpath, "?metadata=variableMap")));
        }
    }

    private DatasetBuilder makeDatasetFromPartition(DatasetBuilder parent, String parentCollectionName, PartitionCollectionImmutable.Partition partition, boolean isPofP) throws IOException {
        String dsName = this.makeCollectionShortName(partition.getName());
        String startPath = parentCollectionName == null ? this.config.path : this.config.path + "/" + parentCollectionName;
        String dpath = startPath + "/" + partition.getName();
        CatalogRefBuilder result = new CatalogRefBuilder(parent);
        result.setTitle(dsName);
        result.setHref(InvDatasetFcGrib.buildCatalogServiceHref(dpath));
        result.put("Id", (Object)dpath);
        result.put("UrlPath", (Object)dpath);
        result.addServiceToCatalog(this.virtualService);
        result.put("ServiceName", (Object)this.virtualService.getName());
        return result;
    }

    protected void addFileDatasets(DatasetBuilder parent, String parentPath, GribCollectionImmutable fromGc) throws IOException {
        DatasetBuilder filesParent = new DatasetBuilder(parent);
        filesParent.setName("Raw Files");
        filesParent.addServiceToCatalog(this.downloadService);
        ThreddsMetadata tmi = filesParent.getInheritableMetadata();
        tmi.set("ServiceName", (Object)this.downloadService.getName());
        parent.addDataset(filesParent);
        ArrayList mfiles = new ArrayList(fromGc.getFiles());
        Collections.sort(mfiles);
        if (!this.config.getSortFilesAscending()) {
            Collections.reverse(mfiles);
        }
        for (MFile mfile : mfiles) {
            DatasetBuilder ds = new DatasetBuilder(parent);
            ds.setName(mfile.getName());
            String lpath = parentPath + "/" + "files" + "/" + mfile.getName();
            ds.put("UrlPath", (Object)lpath);
            ds.put("Id", (Object)lpath);
            ds.put("DataSize", (Object)mfile.getLength());
            if (mfile.getLastModified() > 0L) {
                CalendarDate cdate = CalendarDate.of((long)mfile.getLastModified());
                ds.put("Dates", (Object)new DateType(cdate).setType("modified"));
            }
            filesParent.addDataset(ds);
        }
    }

    @Override
    public CatalogBuilder makeCatalog(String match, String reqPath, URI catURI) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        if (localState == null) {
            return null;
        }
        if (localState.gribCollection == null) {
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(catURI, localState);
            }
            if (localState.gribCollection instanceof PartitionCollectionImmutable) {
                String[] paths = match.split("/");
                PartitionCollectionImmutable pc = (PartitionCollectionImmutable)localState.gribCollection;
                return this.makeCatalogFromPartition(pc, paths, 0, catURI);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error making catalog for " + this.configPath, (Throwable)e);
        }
        return null;
    }

    private CatalogBuilder makeCatalogFromPartition(PartitionCollectionImmutable pc, String[] paths, int idx, URI catURI) throws IOException {
        if (((String[])paths).length < idx + 1) {
            return null;
        }
        PartitionCollectionImmutable.Partition pcp = pc.getPartitionByName(paths[idx]);
        if (pcp == null) {
            return null;
        }
        try (GribCollectionImmutable gc = pcp.getGribCollection();){
            PartitionCollectionImmutable pcNested;
            PartitionCollectionImmutable.Partition pcpNested;
            if (((String[])paths).length > idx + 1 && gc instanceof PartitionCollectionImmutable && (pcpNested = (pcNested = (PartitionCollectionImmutable)gc).getPartitionByName(paths[idx + 1])) != null) {
                CatalogBuilder catalogBuilder = this.makeCatalogFromPartition(pcNested, (String[])paths, idx + 1, catURI);
                return catalogBuilder;
            }
            int i = 0;
            StringBuilder parentName = new StringBuilder();
            for (String s : paths) {
                if (i++ > 0) {
                    parentName.append("/");
                }
                parentName.append(s);
            }
            CatalogBuilder catalogBuilder = this.makeCatalogFromCollection(gc, parentName.toString(), catURI);
            return catalogBuilder;
        }
    }

    private CatalogBuilder makeCatalogFromCollection(GribCollectionImmutable fromGc, String parentCollectionName, URI catURI) throws IOException {
        Catalog parentCatalog = this.parent.getParentCatalog();
        CatalogBuilder result = new CatalogBuilder();
        result.setName(this.makeCollectionShortName(fromGc.getName()));
        result.setVersion(parentCatalog.getVersion());
        result.setBaseURI(catURI);
        DatasetBuilder ds = this.makeDatasetFromCollection(catURI, false, result, parentCollectionName, fromGc);
        result.addDataset(ds);
        return result;
    }

    @Override
    protected DatasetBuilder makeDatasetTop(URI catURI, InvDatasetFeatureCollection.State state) throws IOException {
        StateGrib localState = (StateGrib)state;
        return this.makeDatasetFromCollection(catURI, true, null, null, localState.gribCollection);
    }

    @Override
    public CatalogBuilder makeLatest(String matchPath, String reqPath, URI catURI) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        if (!(localState.gribCollection instanceof PartitionCollectionImmutable)) {
            return null;
        }
        PartitionCollectionImmutable pc = (PartitionCollectionImmutable)localState.gribCollection;
        if (localState.latest == null) {
            ArrayList paths = new ArrayList();
            GribCollectionImmutable latest = pc.getLatestGribCollection(paths);
            if (latest == null) {
                return null;
            }
            latest.close();
            Formatter f = new Formatter();
            int count = 0;
            for (String p : paths) {
                if (count++ > 0) {
                    f.format("/", new Object[0]);
                }
                f.format("%s", p);
            }
            localState.latest = latest;
            localState.latestPath = f.toString();
        }
        return this.makeCatalogFromCollection(localState.latest, localState.latestPath, catURI);
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollectionImmutable.GroupGC group) {
        GdsHorizCoordSys gdsCoordSys = group.getGdsHorizCoordSys();
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox((Projection)gdsCoordSys.proj, (double)gdsCoordSys.getStartX(), (double)gdsCoordSys.getStartY(), (double)gdsCoordSys.getEndX(), (double)gdsCoordSys.getEndY());
        double dx = 0.0;
        double dy = 0.0;
        if (gdsCoordSys.isLatLon()) {
            dx = Math.abs(gdsCoordSys.dx);
            dy = Math.abs(gdsCoordSys.dy);
        }
        return new ThreddsMetadata.GeospatialCoverage(llbb, null, dx, dy);
    }

    private CalendarDateRange extractCalendarDateRange(Iterable<GribCollectionImmutable.GroupGC> groups) {
        CalendarDateRange gcAll = null;
        for (GribCollectionImmutable.GroupGC group : groups) {
            CalendarDateRange gc = group.makeCalendarDateRange();
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll = gcAll.extend(gc);
        }
        return gcAll;
    }

    protected String getDatasetNameLatest(String dsName) {
        if (this.config.gribConfig != null && this.config.gribConfig.latestNamer != null) {
            return this.config.gribConfig.latestNamer;
        }
        return "Latest Collection for " + dsName;
    }

    protected String getDatasetNameBest(String dsName) {
        if (this.config.gribConfig != null && this.config.gribConfig.bestNamer != null) {
            return this.config.gribConfig.bestNamer;
        }
        return "Best " + dsName + " Time Series";
    }

    protected String getDatasetNameTP(String dsName) {
        return "Full Collection Dataset";
    }

    protected String getDatasetNameTwoD(String dsName) {
        return "Full Collection (Reference / Forecast Time) Dataset";
    }

    @Override
    public File getFile(String remaining) {
        try {
            StateGrib localState = (StateGrib)this.checkState();
            int pos = remaining.lastIndexOf("/");
            final String filename = pos >= 0 && remaining.length() > 1 ? remaining.substring(pos + 1) : remaining;
            MFile result = (MFile)this.findDataset(remaining, localState.gribCollection, new DatasetCreator(){

                @Override
                public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                    return gc.findMFileByName(filename);
                }
            });
            if (result == null) {
                return null;
            }
            return new File(result.getPath());
        }
        catch (IOException iow) {
            return null;
        }
    }

    @Override
    public CoverageCollection getGridCoverage(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        return (CoverageCollection)this.findDataset(matchPath, localState.gribCollection, new DatasetCreator(){

            @Override
            public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                return gc.getGridCoverage(ds, group, null, InvDatasetFcGrib.this.config, null, logger);
            }
        });
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        return (GridDataset)this.findDataset(matchPath, localState.gribCollection, new DatasetCreator(){

            @Override
            public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                return gc.getGridDataset(ds, group, null, InvDatasetFcGrib.this.config, null, logger);
            }
        });
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        return (NetcdfDataset)this.findDataset(matchPath, localState.gribCollection, new DatasetCreator(){

            @Override
            public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                return gc.getNetcdfDataset(ds, group, null, InvDatasetFcGrib.this.config, null, logger);
            }
        });
    }

    private Object findDataset(String matchPath, GribCollectionImmutable topCollection, DatasetCreator visit) throws IOException {
        String[] paths = matchPath.split("/");
        List<Object> pathList = paths.length < 1 ? new ArrayList() : Arrays.asList(paths);
        DatasetAndGroup dg = this.findDatasetAndGroup(pathList, topCollection);
        if (dg != null) {
            return visit.obtain(topCollection, dg.ds, dg.group);
        }
        if (!(topCollection instanceof PartitionCollectionImmutable)) {
            return null;
        }
        PartitionCollectionImmutable pc = (PartitionCollectionImmutable)topCollection;
        return this.findDatasetPartition(visit, pc, pathList);
    }

    private DatasetAndGroup findDatasetAndGroup(List<String> paths, GribCollectionImmutable gc) {
        boolean isSingleGroup;
        if (paths.size() < 1 || paths.get(0).length() == 0) {
            GribCollectionImmutable.Dataset ds = gc.getDataset(0);
            GribCollectionImmutable.GroupGC dg = ds.getGroup(0);
            return new DatasetAndGroup(ds, dg);
        }
        GribCollectionImmutable.Dataset ds = this.getSingleDatasetOrByTypeName(gc, paths.get(0));
        if (ds == null) {
            return null;
        }
        boolean bl = isSingleGroup = ds.getGroupsSize() == 1;
        if (isSingleGroup) {
            GribCollectionImmutable.GroupGC g = ds.getGroup(0);
            return new DatasetAndGroup(ds, g);
        }
        String groupName = paths.size() == 1 ? paths.get(0) : paths.get(1);
        GribCollectionImmutable.GroupGC g = ds.findGroupById(groupName);
        if (g != null) {
            return new DatasetAndGroup(ds, g);
        }
        return null;
    }

    public GribCollectionImmutable.Dataset getSingleDatasetOrByTypeName(GribCollectionImmutable gc, String typeName) {
        if (gc.getDatasets().size() == 1) {
            return gc.getDataset(0);
        }
        for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
            if (!ds.getType().toString().equalsIgnoreCase(typeName)) continue;
            return ds;
        }
        return null;
    }

    private Object findDatasetPartition(DatasetCreator visit, PartitionCollectionImmutable outerPartition, List<String> pathList) throws IOException {
        int n = pathList.size();
        if (pathList.size() < 1) {
            return null;
        }
        PartitionCollectionImmutable.Partition pcp = outerPartition.getPartitionByName(pathList.get(0));
        if (pcp == null) {
            DatasetAndGroup dg = this.findDatasetAndGroup(pathList, (GribCollectionImmutable)outerPartition);
            if (dg != null) {
                return visit.obtain((GribCollectionImmutable)outerPartition, dg.ds, dg.group);
            }
            return null;
        }
        try (GribCollectionImmutable gc = pcp.getGribCollection();){
            if (gc instanceof PartitionCollectionImmutable) {
                PartitionCollectionImmutable pcNested = (PartitionCollectionImmutable)gc;
                Object object = this.findDatasetPartition(visit, pcNested, pathList.subList(1, n));
                return object;
            }
            DatasetAndGroup dg = this.findDatasetAndGroup(pathList.subList(1, n), gc);
            if (dg != null) {
                Object object = visit.obtain(gc, dg.ds, dg.group);
                return object;
            }
            GribCollectionImmutable.Dataset ds = gc.getDataset(0);
            GribCollectionImmutable.GroupGC group = ds.getGroup(0);
            Object object = visit.obtain(gc, ds, group);
            return object;
        }
    }

    private static interface DatasetCreator {
        public Object obtain(GribCollectionImmutable var1, GribCollectionImmutable.Dataset var2, GribCollectionImmutable.GroupGC var3) throws IOException;
    }

    private static class DatasetAndGroup {
        GribCollectionImmutable.Dataset ds;
        GribCollectionImmutable.GroupGC group;

        private DatasetAndGroup(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) {
            this.ds = ds;
            this.group = group;
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        GribCollectionImmutable gribCollection;
        GribCollectionImmutable latest;
        String latestPath;

        protected StateGrib(StateGrib from) {
            super(InvDatasetFcGrib.this, from);
            if (from != null) {
                this.gribCollection = from.gribCollection;
                this.latest = from.latest;
                this.latestPath = from.latestPath;
            }
        }

        @Override
        public InvDatasetFeatureCollection.State copy() {
            return new StateGrib(this);
        }
    }
}

