/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import thredds.server.catalogservice.RemoteCatalogRequest;

public class RemoteCatalogRequestValidator
implements Validator {
    public boolean supports(Class clazz) {
        return RemoteCatalogRequest.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors errs) {
        RemoteCatalogRequest rcr = (RemoteCatalogRequest)obj;
        try {
            URI catUri = new URI(rcr.getCatalog());
            if (!catUri.isAbsolute()) {
                errs.rejectValue("catalogUri", "catalogUri.notAbsolute", "The catalog parameter must be an absolute URI.");
            }
            if (catUri.getScheme() == null || !catUri.getScheme().equalsIgnoreCase("HTTP")) {
                errs.rejectValue("catalogUri", "catalogUri.notHttpUri", "The catalog parameter must be an HTTP URI.");
            }
            rcr.setCatalogUri(catUri);
        }
        catch (URISyntaxException e) {
            errs.rejectValue("catalog", "catalogUri.notAbsolute", "catalog parameter is not a valid URI");
        }
        if (rcr.getDataset() != null) {
            rcr.setCommand(RemoteCatalogRequest.Command.SUBSET);
        } else if (rcr.getCommand() == null) {
            rcr.setCommand(RemoteCatalogRequest.Command.SHOW);
        }
    }
}

