/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer2;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.server.radarServer2.RadarServerConfig;
import thredds.server.radarServer2.StationList;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.EarthLocation;

public class RadarDataInventory {
    private static final long updateIntervalMsec = 600000L;
    private EnumMap<DirType, Set<String>> items = new EnumMap(DirType.class);
    private Path collectionDir;
    private DirectoryStructure structure;
    private String fileTimeFmt;
    private String dataFormat;
    private Pattern fileTimeRegex;
    private boolean dirty;
    private CalendarDate lastUpdate;
    private int maxCrawlItems;
    private StationList stations;
    private CalendarPeriod nearestWindow;
    private CalendarPeriod rangeAdjustment;
    private String name;
    private String description;
    private DateRange timeCoverage;
    private RadarServerConfig.RadarConfigEntry.GeoInfo geoCoverage;

    public RadarDataInventory(Path datasetRoot, int numCrawl) {
        this.collectionDir = datasetRoot;
        this.structure = new DirectoryStructure(this.collectionDir);
        this.dirty = true;
        this.maxCrawlItems = numCrawl;
        this.stations = new StationList();
        this.nearestWindow = CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
    }

    public Path getCollectionDir() {
        return this.collectionDir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    CalendarDate getLastUpdate() {
        return this.lastUpdate;
    }

    public FeatureType getFeatureType() {
        return FeatureType.RADIAL;
    }

    public void setDataFormat(String format) {
        this.dataFormat = format;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTimeCoverage(DateRange range) {
        this.timeCoverage = range;
    }

    public DateRange getTimeCoverage() {
        return this.timeCoverage;
    }

    public void setGeoCoverage(RadarServerConfig.RadarConfigEntry.GeoInfo info) {
        this.geoCoverage = info;
    }

    public RadarServerConfig.RadarConfigEntry.GeoInfo getGeoCoverage() {
        return this.geoCoverage;
    }

    public boolean needsVar() {
        return this.items.containsKey((Object)DirType.Variable);
    }

    public StationList getStationList() {
        return this.stations;
    }

    public List<String> getVariableList() {
        return this.listItems(DirType.Variable);
    }

    public void setNearestWindow(CalendarPeriod pd) {
        this.nearestWindow = pd;
    }

    public void addStationDir() {
        this.structure.addSubDir(DirType.Station, null);
        this.dirty = true;
    }

    public void addVariableDir() {
        this.structure.addSubDir(DirType.Variable, null);
        this.dirty = true;
    }

    public void addDateDir(String fmt) {
        this.structure.addSubDir(DirType.Date, fmt);
        CalendarPeriod adjust = this.findRangeAdjustment(fmt);
        if (this.rangeAdjustment == null) {
            this.rangeAdjustment = adjust;
        } else if (adjust.getConvertFactor(this.rangeAdjustment) > 1.0) {
            this.rangeAdjustment = adjust;
        }
        this.dirty = true;
    }

    private CalendarPeriod findRangeAdjustment(String fmtString) {
        if (fmtString.contains("H") || fmtString.contains("k")) {
            return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
        }
        if (fmtString.contains("d")) {
            return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
        }
        if (fmtString.contains("M")) {
            return CalendarPeriod.of((int)31, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
        }
        return CalendarPeriod.of((int)366, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
    }

    public void addFileTime(String regex, String fmt) {
        this.fileTimeRegex = Pattern.compile(regex);
        this.fileTimeFmt = fmt;
    }

    private void findItems(Path start, int level) {
        Set<Object> values;
        if (level >= this.structure.order.size() || level >= this.structure.maxCrawlDepth) {
            return;
        }
        DirectoryStructure.DirEntry entry = (DirectoryStructure.DirEntry)this.structure.order.get(level);
        if (!this.items.containsKey((Object)entry.type)) {
            values = new TreeSet();
            this.items.put(entry.type, values);
        } else {
            values = this.items.get((Object)entry.type);
        }
        int crawled = 0;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(start);){
            for (Path p : dirStream) {
                if (!Files.isDirectory(p, new LinkOption[0])) continue;
                String item = p.getFileName().toString();
                values.add(item);
                if (crawled >= this.maxCrawlItems) continue;
                this.findItems(p, level + 1);
                ++crawled;
            }
        }
        catch (IOException e) {
            System.out.println("findItems(): Error reading directory: " + start.toString());
        }
    }

    private void updateStations(String station, Path path) {
        StationList.Station match = this.stations.get(station);
        if (match == null) {
            try {
                Files.walkFileTree(path, new StationVisitor());
            }
            catch (IOException e) {
                System.out.println("Error walking to find station info: " + station);
            }
        }
    }

    private void update() {
        if (this.dirty || this.timeToUpdate()) {
            this.findItems(this.structure.base, 0);
            this.dirty = false;
            this.lastUpdate = CalendarDate.present();
        }
    }

    boolean timeToUpdate() {
        CalendarDate now = CalendarDate.present();
        return now.getDifferenceInMsecs(this.lastUpdate) > 600000L;
    }

    public List<String> listItems(DirType type) {
        this.update();
        Set<String> vals = this.items.get((Object)type);
        if (vals == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(vals);
    }

    public Query newQuery() {
        this.update();
        return new Query();
    }

    public class Query {
        private EnumMap<DirType, List<Object>> q = new EnumMap(DirType.class);

        public void addCriteria(DirType type, Object val) {
            List<Object> curVals = this.q.get((Object)type);
            if (curVals == null) {
                curVals = new ArrayList<Object>();
                this.q.put(type, curVals);
            }
            curVals.add(val);
        }

        public void addStation(String stID) {
            this.addCriteria(DirType.Station, stID);
        }

        public void addVariable(String varName) {
            this.addCriteria(DirType.Variable, varName);
        }

        public void addDateRange(CalendarDateRange range) {
            this.addCriteria(DirType.Date, range);
        }

        private CalendarDateRange rangeFromFormat(SimpleDateFormat fmt, CalendarDateRange range) {
            if (range == null) {
                return null;
            }
            CalendarDate newStart = this.reparseDate(fmt, range.getStart());
            CalendarDate newEnd = this.reparseDate(fmt, range.getEnd());
            return CalendarDateRange.of((CalendarDate)newStart, (CalendarDate)newEnd.add(RadarDataInventory.this.rangeAdjustment));
        }

        private CalendarDate reparseDate(SimpleDateFormat fmt, CalendarDate d) {
            try {
                Date newDate = fmt.parse(fmt.format(d.toDate()));
                return CalendarDate.of((Date)newDate);
            }
            catch (ParseException e) {
                return d;
            }
        }

        private boolean checkDate(CalendarDateRange range, CalendarDate d) {
            return range == null || range.includes(d);
        }

        public Collection<QueryResultItem> results() {
            ArrayList<Path> results = new ArrayList<Path>();
            DirectoryStructure.DirectoryDateMatcher matcher = RadarDataInventory.this.structure.matcher();
            results.add(RadarDataInventory.this.structure.base);
            List<Object> dates = this.q.get((Object)DirType.Date);
            CalendarDateRange range = (CalendarDateRange)dates.get(0);
            if (range != null && range.isPoint()) {
                range = CalendarDateRange.of((CalendarDate)range.getStart().subtract(RadarDataInventory.this.nearestWindow), (CalendarDate)range.getEnd().add(RadarDataInventory.this.nearestWindow));
            }
            for (int i = 0; i < RadarDataInventory.this.structure.order.size(); ++i) {
                DirectoryStructure.DirEntry entry = (DirectoryStructure.DirEntry)RadarDataInventory.this.structure.order.get(i);
                ArrayList<Path> newResults = new ArrayList<Path>();
                List<Object> queryItem = this.q.get((Object)entry.type);
                switch (entry.type) {
                    case Date: {
                        matcher.add(i, entry.fmt);
                        SimpleDateFormat fmt = matcher.getFormat();
                        CalendarDateRange dirRange = this.rangeFromFormat(fmt, range);
                        for (Path p : results) {
                            try {
                                DirectoryStream<Path> dirStream = Files.newDirectoryStream(p);
                                Throwable throwable = null;
                                try {
                                    for (Path sub : dirStream) {
                                        Date d = matcher.getDate(sub);
                                        if (d == null || !this.checkDate(dirRange, CalendarDate.of((Date)d))) continue;
                                        newResults.add(sub);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (dirStream == null) continue;
                                    if (throwable != null) {
                                        try {
                                            dirStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    dirStream.close();
                                }
                            }
                            catch (IOException e) {
                                System.out.println("results(): Error reading dir: " + p.toString());
                            }
                        }
                        break;
                    }
                    default: {
                        for (Object next : queryItem) {
                            for (Path p : results) {
                                Path nextPath = p.resolve(next.toString());
                                if (!Files.exists(nextPath, new LinkOption[0])) continue;
                                newResults.add(nextPath);
                            }
                        }
                    }
                }
                results = newResults;
            }
            Collection<QueryResultItem> filteredFiles = new ArrayList<QueryResultItem>();
            for (Path p : results) {
                try {
                    DirectoryStream<Path> dirStream = Files.newDirectoryStream(p);
                    Object object = null;
                    try {
                        for (Path f : dirStream) {
                            Matcher regexMatcher = RadarDataInventory.this.fileTimeRegex.matcher(f.toString());
                            if (!regexMatcher.find()) continue;
                            try {
                                CalendarDate cd;
                                SimpleDateFormat fmt = new SimpleDateFormat(RadarDataInventory.this.fileTimeFmt);
                                fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
                                Date d = fmt.parse(regexMatcher.group());
                                if (d == null || !this.checkDate(range, cd = CalendarDate.of((Date)d))) continue;
                                filteredFiles.add(new QueryResultItem(f, cd));
                            }
                            catch (ParseException fmt) {}
                        }
                    }
                    catch (Throwable dirRange) {
                        object = dirRange;
                        throw dirRange;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (object != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable dirRange) {
                                ((Throwable)object).addSuppressed(dirRange);
                            }
                            continue;
                        }
                        dirStream.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("results(): Error getting files for: " + p.toString());
                }
            }
            CalendarDateRange originalRange = (CalendarDateRange)dates.get(0);
            if (originalRange != null && originalRange.isPoint()) {
                TreeMap<String, Long> offsets = new TreeMap<String, Long>();
                TreeMap<String, QueryResultItem> best = new TreeMap<String, QueryResultItem>();
                for (QueryResultItem it : filteredFiles) {
                    long check;
                    String key = RadarDataInventory.this.structure.getKey(it.file);
                    Long offset = (Long)offsets.get(key);
                    if (offset == null) {
                        offset = Long.MAX_VALUE;
                    }
                    if ((check = Math.abs(it.time.getDifferenceInMsecs(originalRange.getStart()))) >= offset) continue;
                    offsets.put(key, check);
                    best.put(key, it);
                }
                filteredFiles = best.values();
            }
            return filteredFiles;
        }

        public class QueryResultItem {
            public Path file;
            public CalendarDate time;

            private QueryResultItem(Path f, CalendarDate cd) {
                this.file = f;
                this.time = cd;
            }
        }
    }

    private class StationVisitor
    extends SimpleFileVisitor<Path> {
        private StationVisitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            try (RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.RADIAL, (String)file.toString(), null, (Formatter)new Formatter());){
                if (rds == null) {
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                EarthLocation loc = rds.getCommonOrigin();
                if (loc == null) {
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                StationList.Station added = RadarDataInventory.this.stations.addStation(rds.getRadarID(), loc.getLatLon());
                added.setElevation(loc.getAltitude());
                added.setName(rds.getRadarName());
                FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                return fileVisitResult;
            }
            catch (IOException e) {
                return FileVisitResult.CONTINUE;
            }
        }
    }

    public static class DirectoryStructure {
        int maxCrawlDepth = 1;
        private Path base;
        private List<DirEntry> order;
        private List<Integer> keyIndices;

        public DirectoryStructure(Path dir) {
            this.base = dir;
            this.order = new ArrayList<DirEntry>();
            this.keyIndices = new ArrayList<Integer>();
        }

        public void addSubDir(DirType type, String fmt) {
            if (type == DirType.Station || type == DirType.Variable) {
                this.maxCrawlDepth = this.order.size() + 1;
                this.keyIndices.add(this.order.size());
            }
            this.order.add(new DirEntry(type, fmt));
        }

        public String getKey(Path path) {
            Path relPath = this.base.relativize(path);
            StringBuilder sb = new StringBuilder("");
            for (int ind : this.keyIndices) {
                sb.append(relPath.getName(ind));
            }
            return sb.toString();
        }

        public DirectoryDateMatcher matcher() {
            return new DirectoryDateMatcher();
        }

        private class DirectoryDateMatcher {
            List<Integer> levels = new ArrayList<Integer>(4);
            String fmt = "";

            public void add(int level, String value) {
                this.levels.add(level);
                this.fmt = this.fmt + value;
            }

            public SimpleDateFormat getFormat() {
                SimpleDateFormat sdf = new SimpleDateFormat(this.fmt);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf;
            }

            public Date getDate(Path path) {
                Path relPath = DirectoryStructure.this.base.relativize(path);
                StringBuilder sb = new StringBuilder("");
                for (Integer l : this.levels) {
                    sb.append(relPath.getName(l));
                }
                try {
                    SimpleDateFormat fmt = this.getFormat();
                    return fmt.parse(sb.toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }

        private static class DirEntry {
            public DirType type;
            public String fmt;

            public DirEntry(DirType type, String fmt) {
                this.type = type;
                this.fmt = fmt;
            }
        }
    }

    public static enum DirType {
        Station,
        Variable,
        Date;

    }
}

