/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import thredds.server.reify.ReifyUtils;

class Parameters {
    public HttpServletRequest req;
    Map<String, String[]> params;
    public ReifyUtils.Command command = null;
    public ReifyUtils.FileFormat format = null;
    public String url = null;
    public String target = null;
    public String inquire = null;
    public Map<String, String> testinfo = new HashMap<String, String>();

    public Parameters(HttpServletRequest req) throws IOException {
        assert (req != null);
        this.req = req;
        this.params = new HashMap<String, String[]>();
        if (req.getParameterMap() != null) {
            this.params.putAll(req.getParameterMap());
        }
        String s = this.getparam("testinfo");
        this.testinfo = ReifyUtils.parseMap(s, ';', true);
        s = this.getparam("request");
        this.command = ReifyUtils.Command.parse(s);
        if (this.command == null) {
            throw new IOException("Unknown request: " + s);
        }
        this.format = ReifyUtils.FileFormat.getformat(this.getparam("format"));
        this.url = this.getparam("url");
        this.target = this.getparam("target");
        this.inquire = this.getparam("inquire");
    }

    protected String[] getparamset(String key) throws IOException {
        String[] values = this.params.get(key);
        return values == null ? new String[]{} : values;
    }

    public String getparam(String key) throws IOException {
        String[] values = this.getparamset(key);
        if (values.length == 0) {
            return null;
        }
        return URLDecoder.decode(values[0], "UTF-8");
    }
}

