/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.core.TdsRequestedDataset;
import thredds.server.config.TdsContext;
import thredds.server.reify.Parameters;
import thredds.server.reify.ReifyUtils;
import thredds.util.ContentType;
import ucar.httpservices.HTTPUtil;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CancelTaskImpl;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.unidata.io.RandomAccessFile;

@Controller
@RequestMapping(value={"/download"})
public class ReifyController {
    protected static final boolean DEBUG = true;
    protected static final String DEFAULTSERVLETNAME = "thredds";
    protected static final String DEFAULTREQUESTNAME = "download";
    protected static final String DEFAULTDOWNLOADDIR = "download";
    protected static final String STATUSCODEHEADER = "x-download-code";
    protected static final String FILESERVERSERVLET = "/fileServer/";
    static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    static Logger log = LoggerFactory.getLogger(ReifyController.class);
    public static TdsContext testTdsContext = null;
    @Autowired
    protected TdsContext tdsContext = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected Parameters params = null;
    protected String downloaddir = null;
    protected boolean initialized = false;
    protected boolean getInitialized = false;
    protected String server = null;
    protected String requestname = null;
    protected String threddsname = null;
    protected Nc4Chunking.Strategy strategy = Nc4Chunking.Strategy.standard;
    protected Nc4Chunking chunking = new Nc4ChunkingDefault();

    public ReifyController() throws ServletException {
        if (!this.initialized) {
            this.init();
        }
    }

    public void init() throws ServletException {
        try {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            logServerStartup.info(this.getClass().getName() + " initialization");
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void initGet(HttpServletRequest req) throws ReifyUtils.SendError {
        if (this.getInitialized) {
            return;
        }
        this.getInitialized = true;
        log.info(this.getClass().getName() + " GET initialization");
        String tmp = HTTPUtil.canonicalpath((String)req.getContextPath());
        this.threddsname = HTTPUtil.relpath((String)tmp);
        tmp = HTTPUtil.canonicalpath((String)req.getServletPath());
        this.requestname = HTTPUtil.relpath((String)tmp);
        if (this.threddsname == null || this.threddsname.length() == 0) {
            this.threddsname = DEFAULTSERVLETNAME;
        }
        if (this.requestname == null || this.requestname.length() == 0) {
            this.requestname = "download";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0) {
            buf.append(":");
            buf.append(port);
        }
        this.server = buf.toString();
        File downdir = null;
        if (this.tdsContext == null) {
            this.tdsContext = testTdsContext;
        }
        if (this.tdsContext != null) {
            downdir = this.tdsContext.getDownloadDir();
        }
        if (downdir == null) {
            throw new ReifyUtils.SendError(500, "No tds.download.dir specified");
        }
        this.downloaddir = HTTPUtil.canonicalpath((String)downdir.getAbsolutePath());
    }

    @RequestMapping(value={"**"})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            this.req = req;
            this.res = res;
            if (!this.getInitialized) {
                this.initGet(req);
            }
            try {
                this.params = new Parameters(req);
            }
            catch (IOException ioe) {
                throw new ReifyUtils.SendError(400, (Throwable)ioe);
            }
            HashMap<String, String> result = new HashMap<String, String>();
            switch (this.params.command) {
                case DOWNLOAD: {
                    this.download(result);
                    break;
                }
                case INQUIRE: {
                    this.inquire(result);
                }
            }
            this.reply(result);
        }
        catch (ReifyUtils.SendError se) {
            this.sendError(se.httpcode, se.msg);
        }
        catch (Exception e) {
            String msg = ReifyUtils.getStackTrace(e);
            this.sendError(500, msg);
        }
    }

    protected void sendError(int code, String msg) {
        block2: {
            System.err.println(String.format("xxx: error: code=%d msg=%s%n", code, msg));
            try {
                this.res.setIntHeader(STATUSCODEHEADER, code);
                this.reply(msg);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected failure");
            }
        }
    }

    protected void reply(Map<String, String> result) {
        String sresult = ReifyUtils.toString(result, true, "download");
        this.reply(sresult);
    }

    protected void reply(String sresult) {
        this.res.setContentType(ContentType.text.getContentHeader());
        try {
            ServletOutputStream out = this.res.getOutputStream();
            PrintStream pw = new PrintStream((OutputStream)out, false, "US-ASCII");
            pw.print(sresult);
            pw.close();
            out.flush();
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
    }

    protected void download(Map<String, String> result) {
        String truepath;
        URI uri;
        if (this.params.target == null) {
            throw new ReifyUtils.SendError(400, "No target specified");
        }
        if (this.params.target.indexOf("..") >= 0) {
            throw new ReifyUtils.SendError(400, "Target parameter contains '..': " + this.params.target);
        }
        File ftarget = new File(this.params.target);
        if (ftarget.isAbsolute()) {
            throw new ReifyUtils.SendError(400, "Target parameter must be a relative path: " + this.params.target);
        }
        if (this.downloaddir == null) {
            throw new ReifyUtils.SendError(400, "No download directory specified for relative target: " + this.params.target);
        }
        StringBuilder b = new StringBuilder();
        b.append(this.downloaddir);
        b.append('/');
        b.append(this.params.target);
        ftarget = new File(b.toString());
        String fulltarget = HTTPUtil.canonicalpath((String)ftarget.getAbsolutePath());
        File parent = ftarget.getParentFile();
        if (!parent.exists() && !ftarget.getParentFile().mkdirs()) {
            throw new ReifyUtils.SendError(403, "Target file parent directory cannot be created: " + fulltarget);
        }
        if (ftarget.exists() && !ftarget.delete()) {
            throw new ReifyUtils.SendError(403, "Target file exists and cannot be deleted: " + fulltarget);
        }
        String url = this.params.url;
        if (url == null) {
            throw new ReifyUtils.SendError(400, "no source url specified");
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new ReifyUtils.SendError(400, "Malformed source url:" + url);
        }
        String path = uri.getPath();
        if (path.toLowerCase().indexOf(this.requestname) >= 0) {
            throw new ReifyUtils.SendError(403, String.format("URL is recursive on /%s: %s", this.requestname, path));
        }
        if (!path.startsWith("/" + this.threddsname)) {
            throw new ReifyUtils.SendError(403, String.format("URL does not reference %s: %s", this.threddsname, path));
        }
        b.setLength(0);
        b.append(uri.getScheme());
        b.append("://");
        b.append(this.server);
        b.append(path);
        String trueurl = b.toString();
        boolean directcopy = false;
        if (path.indexOf(FILESERVERSERVLET) >= 0 && (directcopy = this.canCopy(truepath = this.directAccess(path, this.req, this.res), this.params.format))) {
            try {
                Path src = new File(truepath).toPath();
                Path dst = new File(fulltarget).toPath();
                Files.deleteIfExists(dst);
                Files.copy(src, dst, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new ReifyUtils.SendError(403, truepath);
            }
        }
        if (!directcopy) {
            NetcdfFile ncfile = null;
            try {
                CancelTaskImpl cancel = new CancelTaskImpl();
                ncfile = NetcdfDataset.openFile((String)trueurl, (CancelTask)cancel);
                switch (this.params.format) {
                    case NETCDF3: {
                        this.makeNetcdf3(ncfile, fulltarget);
                        break;
                    }
                    case NETCDF4: {
                        this.makeNetcdf4(ncfile, fulltarget);
                        break;
                    }
                    default: {
                        throw new ReifyUtils.SendError(501, String.format("%s: return format %s not implemented", path, this.params.format.getName()));
                    }
                }
            }
            catch (IOException ioe) {
                throw new ReifyUtils.SendError(400, (Throwable)ioe);
            }
        }
        result.put("download", fulltarget);
    }

    protected void inquire(Map<String, String> result) {
        String s = this.params.inquire;
        List<String> keys = ReifyUtils.parseList(s, ';', true);
        for (String key : keys) {
            ReifyUtils.Inquiry inq = ReifyUtils.Inquiry.parse(key);
            if (inq == null) continue;
            switch (inq) {
                case DOWNLOADDIR: {
                    result.put(inq.getKey(), this.downloaddir == null ? "null" : this.downloaddir);
                    break;
                }
                case USERNAME: {
                    String uname = System.getProperty("user.name");
                    result.put(inq.getKey(), uname == null ? "null" : uname);
                }
            }
        }
    }

    protected void makeNetcdf4(NetcdfFile ncfile, String target) throws IOException {
        CancelTaskImpl cancel = new CancelTaskImpl();
        FileWriter2 writer = new FileWriter2(ncfile, target, NetcdfFileWriter.Version.netcdf4, this.chunking);
        writer.getNetcdfFileWriter().setLargeFile(true);
        NetcdfFile ncfileOut = writer.write((CancelTask)cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        cancel.setDone(true);
    }

    protected void makeNetcdf3(NetcdfFile ncfile, String target) throws IOException {
        CancelTaskImpl cancel = new CancelTaskImpl();
        FileWriter2 writer = new FileWriter2(ncfile, target, NetcdfFileWriter.Version.netcdf3, this.chunking);
        writer.getNetcdfFileWriter().setLargeFile(true);
        NetcdfFile ncfileOut = writer.write((CancelTask)cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        cancel.setDone(true);
    }

    protected static String escapeString(String s) {
        StringBuilder buf = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    buf.append('\n');
                    continue block8;
                }
                case '\r': {
                    buf.append('\r');
                    continue block8;
                }
                case '\t': {
                    buf.append('\r');
                    continue block8;
                }
                case '\f': {
                    buf.append('\f');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        buf.append(String.format("\\x%02x", c & 0xFF));
                        continue block8;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected String directAccess(String relpath, HttpServletRequest req, HttpServletResponse res) {
        int index = relpath.indexOf(FILESERVERSERVLET);
        assert (index >= 0);
        relpath = relpath.substring(index + FILESERVERSERVLET.length(), relpath.length());
        String realpath = TdsRequestedDataset.getLocationFromRequestPath(relpath = HTTPUtil.abspath((String)HTTPUtil.canonicalpath((String)relpath)));
        File f = new File(realpath);
        if (!f.exists() || !f.canRead()) {
            throw new ReifyUtils.SendError(404, "Not found: " + realpath);
        }
        if (!TdsRequestedDataset.resourceControlOk(req, res, realpath)) {
            throw new ReifyUtils.SendError(403, "Permissions failure: " + realpath);
        }
        return realpath;
    }

    protected boolean canCopy(String truepath, ReifyUtils.FileFormat targetformat) {
        try {
            RandomAccessFile raf = new RandomAccessFile(truepath, "r");
            if (N3header.isValidFile((RandomAccessFile)raf) && targetformat == ReifyUtils.FileFormat.NETCDF3) {
                return true;
            }
            if (H5header.isValidFile((RandomAccessFile)raf) && targetformat == ReifyUtils.FileFormat.NETCDF4) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }
}

