/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.reify;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ReifyUtils {
    ReifyUtils() {
    }

    static File findSystemTempDir(String[] candidates) {
        for (String candidate : candidates) {
            File f = new File(candidate);
            if (f.exists() && f.canRead() && f.canWrite()) {
                return f;
            }
            if (!f.mkdirs()) continue;
            return f;
        }
        try {
            File tempfile = File.createTempFile("tmp", "tmp");
            File tempdir = tempfile.getParentFile();
            if (!tempdir.canWrite() || !tempdir.canRead()) {
                return null;
            }
            return tempdir;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toString(Map<String, String> map, boolean encode, String ... order) {
        List<String> orderlist = order == null ? new ArrayList<String>(map.keySet()) : Arrays.asList(order);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < orderlist.size(); ++i) {
            String key = orderlist.get(i);
            String value = map.get(key);
            if (value == null) continue;
            if (!first) {
                b.append("&");
            }
            b.append(key);
            b.append("=");
            b.append(encode ? ReifyUtils.urlEncode(value) : value);
            first = false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (orderlist.contains(entry.getKey())) continue;
            if (!first) {
                b.append("&");
            }
            b.append(entry.getKey());
            b.append("=");
            b.append(encode ? ReifyUtils.urlEncode(entry.getValue()) : entry.getValue());
            first = false;
        }
        return b.toString();
    }

    public static Map<String, String> parseMap(String params, char sep, boolean decode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (params == null || params.length() == 0) {
            return map;
        }
        String[] pieces = params.split("[&]");
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i].trim();
            String[] pair = piece.split("[=]");
            String key = pair[0].trim();
            if (pair.length >= 2) {
                String v = pair[1].trim();
                if (decode) {
                    v = ReifyUtils.urlDecode(v);
                }
                map.put(key, v);
                continue;
            }
            if (pair.length == 1) {
                map.put(key, "");
                continue;
            }
            assert (false) : "split() failed";
        }
        return map;
    }

    public static List<String> parseList(String params, char sep, boolean decode) {
        ArrayList<String> list = new ArrayList<String>();
        if (params == null || params.length() == 0) {
            return list;
        }
        String regex = "[ ]*[" + sep + "][ ]*";
        String[] pieces = params.split(regex);
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (decode) {
                piece = ReifyUtils.urlDecode(piece);
            }
            list.add(piece);
        }
        return list;
    }

    public static String urlEncode(String s) {
        block2: {
            try {
                s = URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return s;
    }

    public static String urlDecode(String s) {
        block2: {
            try {
                s = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return s;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        try {
            sw.close();
        }
        catch (IOException ioe) {
            return "close failure";
        }
        return sw.toString();
    }

    public static class SendError
    extends RuntimeException {
        public int httpcode = 0;
        public String msg = null;

        public SendError(int httpcode) {
            this(httpcode, (String)null);
        }

        public SendError(int httpcode, Throwable t) {
            this(httpcode, t.getMessage());
        }

        public SendError(int httpcode, String msg) {
            if (httpcode == 0) {
                httpcode = 400;
            }
            if (msg == null) {
                msg = "";
            }
            this.httpcode = httpcode;
            this.msg = msg;
        }
    }

    static enum FileFormat {
        NETCDF3("nc3"),
        NETCDF4("nc4");

        private String extension;

        public final String getName() {
            return this.toString().toLowerCase();
        }

        public final String getExtension() {
            return this.extension;
        }

        private FileFormat(String ext) {
            this.extension = ext;
        }

        public static FileFormat getformat(String fmt) {
            if (fmt == null) {
                return null;
            }
            for (FileFormat rf : FileFormat.values()) {
                if (!fmt.equalsIgnoreCase(rf.toString())) continue;
                return rf;
            }
            return null;
        }
    }

    static enum Inquiry {
        DOWNLOADDIR("downloaddir"),
        USERNAME("username");

        private String key;

        private Inquiry(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static Inquiry parse(String key) {
            if (key == null) {
                return null;
            }
            for (Inquiry x : Inquiry.values()) {
                if (!key.equalsIgnoreCase(x.toString())) continue;
                return x;
            }
            return null;
        }
    }

    static enum Command {
        DOWNLOAD,
        INQUIRE;


        public static Command parse(String cmd) {
            if (cmd == null) {
                return null;
            }
            for (Command x : Command.values()) {
                if (!cmd.equalsIgnoreCase(x.toString())) continue;
                return x;
            }
            return null;
        }
    }
}

