/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs.v1_0_0_1;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.wcs.Request;
import thredds.server.wcs.v1_0_0_1.WcsDataset;
import thredds.server.wcs.v1_0_0_1.WcsException;
import thredds.server.wcs.v1_0_0_1.WcsRangeField;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CFGridCoverageWriter2;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.NamedObject;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ogc.EPSG_OGC_CF_Helper;

public class WcsCoverage {
    private static Logger log = LoggerFactory.getLogger(WcsCoverage.class);
    private WcsDataset wcsDataset;
    private CoverageCollection dataset;
    private Coverage coverage;
    private CoverageCoordSys coordSys;
    private String nativeCRS;
    private String defaultRequestCrs;
    private List<Request.Format> supportedCoverageFormatList;
    private WcsRangeField range;
    private static DiskCache2 diskCache = null;

    public WcsCoverage(@Nonnull Coverage coverage, @Nonnull CoverageCoordSys coordSys, @Nonnull WcsDataset wcsDataset) {
        WcsRangeField.Axis vertAxis;
        this.wcsDataset = wcsDataset;
        this.coverage = coverage;
        this.coordSys = coordSys;
        this.dataset = wcsDataset.getDataset();
        ProjectionImpl proj = coordSys.getProjection();
        this.nativeCRS = EPSG_OGC_CF_Helper.getWcs1_0CrsId((Projection)proj);
        this.defaultRequestCrs = "OGC:CRS84";
        this.supportedCoverageFormatList = new ArrayList<Request.Format>();
        this.supportedCoverageFormatList.add(Request.Format.GeoTIFF);
        this.supportedCoverageFormatList.add(Request.Format.GeoTIFF_Float);
        this.supportedCoverageFormatList.add(Request.Format.NetCDF3);
        CoverageCoordAxis zaxis = coordSys.getZAxis();
        if (zaxis != null && zaxis.getDependenceType() == CoverageCoordAxis.DependenceType.independent) {
            ArrayList<String> names = new ArrayList<String>();
            for (NamedObject val : ((CoverageCoordAxis1D)zaxis).getCoordValueNames()) {
                names.add(val.getName());
            }
            vertAxis = new WcsRangeField.Axis("Vertical", zaxis.getName(), zaxis.getDescription(), true, names);
        } else {
            vertAxis = null;
        }
        this.range = new WcsRangeField(this.getName(), this.getLabel(), this.getDescription(), vertAxis);
    }

    public String getName() {
        return this.coverage.getName();
    }

    public String getLabel() {
        return this.coverage.getDescription();
    }

    public String getDescription() {
        return this.coverage.getDescription();
    }

    public CoverageCoordSys getCoordinateSystem() {
        return this.coordSys;
    }

    public boolean hasMissingData() {
        return this.coverage.hasMissing();
    }

    public String getDefaultRequestCrs() {
        return this.defaultRequestCrs;
    }

    public String getNativeCrs() {
        return this.nativeCRS;
    }

    public List<Request.Format> getSupportedCoverageFormatList() {
        return this.supportedCoverageFormatList;
    }

    public boolean isSupportedCoverageFormat(Request.Format covFormat) {
        return this.supportedCoverageFormatList.contains((Object)covFormat);
    }

    public WcsRangeField getRangeField() {
        return this.range;
    }

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            log.error("getDiskCache(): Disk cache has not been set.");
            throw new IllegalStateException("Disk cache must be set before calling GetCoverage.getDiskCache().");
        }
        return diskCache;
    }

    public File writeCoverageDataToFile(Request.Format format, LatLonRect bboxLatLonRect, VerticalRange verticalRange, CalendarDateRange timeRange) throws WcsException {
        SubsetParams params = new SubsetParams();
        if (bboxLatLonRect != null) {
            params.set("latlonBB", (Object)bboxLatLonRect);
        }
        if (timeRange != null) {
            params.set("timeRange", (Object)timeRange);
        }
        if (verticalRange != null) {
            double[] vr = new double[]{verticalRange.min, verticalRange.max};
            params.set("vertRange", (Object)vr);
        }
        try {
            File dir;
            if (format == Request.Format.GeoTIFF || format == Request.Format.GeoTIFF_Float) {
                dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File tifFile = File.createTempFile("WCS", ".tif", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): tifFile=" + tifFile.getPath());
                }
                GeoReferencedArray array = this.coverage.readData(params);
                try (GeotiffWriter writer = new GeotiffWriter(tifFile.getPath());){
                    writer.writeGrid(array, format == Request.Format.GeoTIFF);
                }
                catch (Throwable e) {
                    log.error("writeCoverageDataToFile(): Failed to write file for requested coverage <" + this.coverage.getName() + ">: ", e);
                    throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage [" + this.coverage.getName() + "].");
                }
                return tifFile;
            }
            if (format == Request.Format.NetCDF3) {
                dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File outFile = File.createTempFile("WCS", ".nc", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): ncFile=" + outFile.getPath());
                }
                NetcdfFileWriter writer = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)outFile.getAbsolutePath());
                Optional opt = CFGridCoverageWriter2.writeOrTestSize((CoverageCollection)this.wcsDataset.getDataset(), Collections.singletonList(this.coverage.getName()), (SubsetParams)params, (boolean)true, (boolean)false, (NetcdfFileWriter)writer);
                if (!opt.isPresent()) {
                    throw new InvalidRangeException("Request contains no data: " + opt.getErrorMessage());
                }
                return outFile;
            }
            log.error("writeCoverageDataToFile(): Unsupported response encoding format [" + (Object)((Object)format) + "].");
            throw new WcsException(WcsException.Code.InvalidFormat, "Format", "Unsupported response encoding format [" + (Object)((Object)format) + "].");
        }
        catch (InvalidRangeException e) {
            log.error("writeCoverageDataToFile(): Failed to subset coverage <" + this.coverage.getName() + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Failed to subset coverage [" + this.coverage.getName() + "].");
        }
        catch (IOException e) {
            log.error("writeCoverageDataToFile(): Failed to create or write temporary file for requested coverage <" + this.coverage.getName() + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage [" + this.coverage.getName() + "].");
        }
    }

    public static class VerticalRange {
        private double min;
        private double max;
        private int stride;
        private boolean singlePoint = false;

        public VerticalRange(double point, int stride) {
            this(point, point, stride);
            this.singlePoint = true;
        }

        public VerticalRange(double minimum, double maximum, int stride) {
            if (minimum > maximum) {
                log.error("VerticalRange(): Minimum <" + minimum + "> is greater than maximum <" + maximum + ">.");
                throw new IllegalArgumentException("VerticalRange minimum <" + minimum + "> greater than maximum <" + maximum + ">.");
            }
            if (stride < 1) {
                log.error("VerticalRange(): stride <" + stride + "> less than one (1 means all points).");
                throw new IllegalArgumentException("VerticalRange stride <" + stride + "> less than one (1 means all points).");
            }
            this.min = minimum;
            this.max = maximum;
            this.stride = stride;
        }

        public double getMinimum() {
            return this.min;
        }

        public double getMaximum() {
            return this.max;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean isSinglePoint() {
            return this.singlePoint;
        }

        public String toString() {
            return "[min=" + this.min + ",max=" + this.max + ",stride=" + this.stride + "]";
        }
    }
}

