/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

class CoordinateTime2DUnionizer<T>
extends CoordinateBuilderImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateTime2DUnionizer.class);
    boolean isTimeInterval;
    boolean makeVals;
    CalendarPeriod timeUnit;
    int code;
    SortedMap<Long, CoordinateTimeAbstract> timeMap = new TreeMap<Long, CoordinateTimeAbstract>();
    boolean shown;

    public CoordinateTime2DUnionizer(boolean isTimeInterval, CalendarPeriod timeUnit, int code, boolean makeVals) {
        this.isTimeInterval = isTimeInterval;
        this.timeUnit = timeUnit;
        this.code = code;
        this.makeVals = makeVals;
    }

    @Override
    public void addAll(Coordinate coord) {
        CoordinateTime2D coordT2D = (CoordinateTime2D)coord;
        for (int runIdx = 0; runIdx < coordT2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract times = coordT2D.getTimeCoordinate(runIdx);
            CoordinateTimeAbstract timesPrev = (CoordinateTimeAbstract)this.timeMap.get(coordT2D.getRuntime(runIdx));
            if (timesPrev != null && !this.shown) {
                logger.warn("CoordinateTime2DUnionizer duplicate runtimes from different partitions {}", Thread.currentThread().getStackTrace());
                this.shown = true;
            }
            this.timeMap.put(coordT2D.getRuntime(runIdx), times);
        }
    }

    @Override
    public Object extract(T gr) {
        throw new RuntimeException();
    }

    public void setRuntimeCoords(CoordinateRuntime runtimes) {
        for (int idx = 0; idx < runtimes.getSize(); ++idx) {
            CalendarDate cd = runtimes.getRuntimeDate(idx);
            long runtime = runtimes.getRuntime(idx);
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)this.timeMap.get(runtime);
            if (time != null) continue;
            time = this.isTimeInterval ? new CoordinateTimeIntv(this.code, this.timeUnit, cd, new ArrayList<TimeCoord.Tinv>(0), null) : new CoordinateTime(this.code, this.timeUnit, cd, new ArrayList<Integer>(0), null);
            this.timeMap.put(runtime, time);
        }
    }

    @Override
    public Coordinate makeCoordinate(List<Object> values) {
        ArrayList<Long> runtimes = new ArrayList<Long>();
        ArrayList<Coordinate> times = new ArrayList<Coordinate>();
        ArrayList<CoordinateTime2D.Time2D> allVals = new ArrayList<CoordinateTime2D.Time2D>();
        for (long runtime : this.timeMap.keySet()) {
            runtimes.add(runtime);
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)this.timeMap.get(runtime);
            times.add(time);
            if (!this.makeVals) continue;
            CalendarDate cd = CalendarDate.of(runtime);
            for (Object object : time.getValues()) {
                allVals.add(this.isTimeInterval ? new CoordinateTime2D.Time2D(cd, null, (TimeCoord.Tinv)object) : new CoordinateTime2D.Time2D(cd, (Integer)object, null));
            }
        }
        Collections.sort(allVals);
        CoordinateTimeAbstract maxCoord = CoordinateTime2DUnionizer.testOrthogonal(this.timeMap.values());
        if (maxCoord != null) {
            return new CoordinateTime2D(this.code, this.timeUnit, allVals, new CoordinateRuntime(runtimes, this.timeUnit), maxCoord, times);
        }
        List<Coordinate> regCoords = this.testIsRegular();
        if (regCoords != null) {
            return new CoordinateTime2D(this.code, this.timeUnit, allVals, new CoordinateRuntime(runtimes, this.timeUnit), regCoords, times);
        }
        return new CoordinateTime2D(this.code, this.timeUnit, allVals, new CoordinateRuntime(runtimes, this.timeUnit), times);
    }

    private List<Coordinate> testIsRegular() {
        TreeMap<Integer, ArrayList<CoordinateTimeAbstract>> hourMap = new TreeMap<Integer, ArrayList<CoordinateTimeAbstract>>();
        for (CoordinateTimeAbstract coord : this.timeMap.values()) {
            CalendarDate runDate = coord.getRefDate();
            int hour = runDate.getHourOfDay();
            ArrayList<CoordinateTimeAbstract> hg = (ArrayList<CoordinateTimeAbstract>)hourMap.get(hour);
            if (hg == null) {
                hg = new ArrayList<CoordinateTimeAbstract>();
                hourMap.put(hour, hg);
            }
            hg.add(coord);
        }
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        Iterator iterator = hourMap.keySet().iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            List hg = (List)hourMap.get(hour);
            CoordinateTimeAbstract maxCoord = CoordinateTime2DUnionizer.testOrthogonal(hg);
            if (maxCoord == null) {
                return null;
            }
            result.add(maxCoord);
        }
        return result;
    }

    public static CoordinateTimeAbstract testOrthogonal(Collection<CoordinateTimeAbstract> times) {
        CoordinateTimeAbstract maxCoord = null;
        HashSet<Object> result = new HashSet<Object>(100);
        int max = 0;
        for (CoordinateTimeAbstract coord : times) {
            if (max < coord.getSize()) {
                maxCoord = coord;
                max = coord.getSize();
            }
            for (Object object : coord.getValues()) {
                result.add(object);
            }
        }
        int totalMax = result.size();
        return totalMax == max ? maxCoord : null;
    }
}

