/*
 * Decompiled with CFR 0.152.
 */
package org.n52.oxf.xmlbeans.tools;

import java.util.Collection;
import java.util.UUID;
import javax.xml.namespace.QName;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.ExceptionType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.oxf.xmlbeans.parser.XMLBeansParser;
import org.n52.oxf.xmlbeans.parser.XMLHandlingException;
import org.n52.oxf.xmlbeans.tools.XmlUtil;
import org.w3.x2003.x05.soapEnvelope.Body;
import org.w3.x2003.x05.soapEnvelope.Envelope;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.FaultDocument;
import org.w3.x2003.x05.soapEnvelope.Header;
import org.w3.x2005.x08.addressing.ActionDocument;
import org.w3.x2005.x08.addressing.FromDocument;
import org.w3.x2005.x08.addressing.MessageIDDocument;
import org.w3.x2005.x08.addressing.RelatesToDocument;
import org.w3.x2005.x08.addressing.ReplyToDocument;
import org.w3.x2005.x08.addressing.ToDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SoapUtil {
    public static XmlObject createXmlExceptionResponse(Throwable t) {
        ExceptionReportDocument exceptionReportDoc = ExceptionReportDocument.Factory.newInstance();
        ExceptionReportDocument.ExceptionReport exceptionReport = exceptionReportDoc.addNewExceptionReport();
        ExceptionType exception = exceptionReport.addNewException();
        exception.setLocator("NoApplicableCode");
        exception.addExceptionText(t.getMessage());
        return exceptionReportDoc;
    }

    public static String getWsaRecipientUrlFromSoapHeader(XmlObject xml) throws XmlException {
        if (SoapUtil.isSoapEnvelope(xml)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xml;
            Header header = envelope.getEnvelope().getHeader();
            ToDocument wsaTo = (ToDocument)SoapUtil.getXmlFromDomNode(header, "To");
            return wsaTo.getTo().getStringValue();
        }
        return null;
    }

    public static String getWsaReplyToUrlFromSoapHeader(XmlObject xml) throws XmlException {
        if (SoapUtil.isSoapEnvelope(xml)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xml;
            Header header = envelope.getEnvelope().getHeader();
            ReplyToDocument wsaReplyTo = (ReplyToDocument)SoapUtil.getXmlFromDomNode(header, "ReplyTo");
            return wsaReplyTo.getReplyTo().getAddress().getStringValue();
        }
        return null;
    }

    public static String getWsaMessageIdFromSoapHeader(XmlObject xml) throws XmlException {
        if (SoapUtil.isSoapEnvelope(xml)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xml;
            Header header = envelope.getEnvelope().getHeader();
            MessageIDDocument msgIdDoc = (MessageIDDocument)SoapUtil.getXmlFromDomNode(header, "MessageID");
            return msgIdDoc.getMessageID().getStringValue();
        }
        return null;
    }

    public static String getWsaRelatesToFromSoapHeader(XmlObject xml) throws XmlException {
        if (SoapUtil.isSoapEnvelope(xml)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xml;
            Header header = envelope.getEnvelope().getHeader();
            RelatesToDocument relatesToDoc = (RelatesToDocument)SoapUtil.getXmlFromDomNode(header, "RelatesTo");
            return relatesToDoc.getRelatesTo().getStringValue();
        }
        return null;
    }

    public static String getWsaActionFromSoapHeader(XmlObject xml) throws XmlException {
        if (SoapUtil.isSoapEnvelope(xml)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xml;
            Header header = envelope.getEnvelope().getHeader();
            ActionDocument action = (ActionDocument)SoapUtil.getXmlFromDomNode(header, "Action");
            return action.getAction().getStringValue();
        }
        return null;
    }

    public static SchemaType getSchemaTypeOfXmlPayload(XmlObject xml) {
        if (SoapUtil.isSoapEnvelope(xml)) {
            return SoapUtil.stripSoapEnvelope((EnvelopeDocument)xml, null).schemaType();
        }
        return xml.schemaType();
    }

    public static XmlObject stripSoapEnvelope(XmlObject xmlToStrip) {
        return SoapUtil.stripSoapEnvelope(xmlToStrip, null);
    }

    public static XmlObject stripSoapEnvelope(XmlObject xmlToStrip, String nodeName) {
        if (SoapUtil.isSoapEnvelope(xmlToStrip)) {
            EnvelopeDocument envelope = (EnvelopeDocument)xmlToStrip;
            return SoapUtil.readPayload(envelope, nodeName);
        }
        return xmlToStrip;
    }

    public static boolean isSoapEnvelope(XmlObject xml) {
        return xml != null && xml.schemaType() == EnvelopeDocument.type;
    }

    public static boolean isSoapFault(XmlObject response) {
        XmlObject request = SoapUtil.stripSoapEnvelope(response, "Fault");
        return request != null && request instanceof FaultDocument;
    }

    public static XmlObject readPayload(EnvelopeDocument envelope, String nodeName) {
        try {
            return SoapUtil.readBodyNodeFrom(envelope, nodeName);
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("Cannot parse from envelope");
        }
    }

    public static XmlObject readBodyNodeFrom(EnvelopeDocument envelope, String nodeName) throws XmlException {
        Body soapBody = envelope.getEnvelope().getBody();
        if (nodeName == null) {
            XmlCursor bodyCursor = soapBody.newCursor();
            return bodyCursor.toFirstChild() ? bodyCursor.getObject() : null;
        }
        return SoapUtil.getXmlFromDomNode(soapBody, nodeName);
    }

    public static XmlObject getXmlFromDomNode(XmlObject xml, String nodeName) throws XmlException {
        Node bodyNode = XmlUtil.getDomNode(xml, nodeName);
        return bodyNode == null ? null : XmlObject.Factory.parse(bodyNode);
    }

    public static QName getElementType(XmlObject xml) {
        return xml == null ? null : xml.schemaType().getDocumentElementName();
    }

    public static String getTextContentFromXml(XmlObject xmlElement) {
        Node node = xmlElement.getDomNode();
        return node.getFirstChild().getFirstChild().getNodeValue();
    }

    public static String getTextContentFromAnyNode(XmlObject xmlAnyElement) {
        Node node = xmlAnyElement.getDomNode();
        return node.getFirstChild().getNodeValue();
    }

    public static XmlObject setTextContent(XmlObject xmlObject, String content) {
        XmlCursor cursor = xmlObject.newCursor();
        cursor.toFirstChild();
        cursor.setTextValue(content);
        cursor.dispose();
        return xmlObject;
    }

    public static EnvelopeDocument wrapToSoapEnvelope(XmlObject bodyContent) {
        EnvelopeDocument envelopeDoc = EnvelopeDocument.Factory.newInstance();
        Envelope envelope = envelopeDoc.addNewEnvelope();
        Body body = envelope.addNewBody();
        body.set(bodyContent);
        return envelopeDoc;
    }

    public static void addWsaRecipientTo(EnvelopeDocument envelopeDoc, String recipient) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        ToDocument toDoc = ToDocument.Factory.newInstance();
        toDoc.addNewTo().setStringValue(recipient);
        SoapUtil.addToHeader(header, toDoc.getTo().getDomNode());
    }

    public static void addWsaReplyTo(EnvelopeDocument envelopeDoc, String replyTo) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        ReplyToDocument replyToDoc = ReplyToDocument.Factory.newInstance();
        replyToDoc.addNewReplyTo().addNewAddress().setStringValue(replyTo);
        SoapUtil.addToHeader(header, replyToDoc.getReplyTo().getDomNode());
    }

    public static void addWsaFrom(EnvelopeDocument envelopeDoc, String from) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        FromDocument fromDoc = FromDocument.Factory.newInstance();
        fromDoc.addNewFrom().addNewAddress().setStringValue(from);
        SoapUtil.addToHeader(header, fromDoc.getFrom().getDomNode());
    }

    public static void addWsaAction(EnvelopeDocument envelopeDoc, String action) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        ActionDocument actionDoc = ActionDocument.Factory.newInstance();
        actionDoc.addNewAction().setStringValue(action);
        SoapUtil.addToHeader(header, actionDoc.getAction().getDomNode());
    }

    public static void addRelatedWsaMessageId(EnvelopeDocument envelopeDoc, String relatedMessageId) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        RelatesToDocument relatesToDoc = RelatesToDocument.Factory.newInstance();
        relatesToDoc.addNewRelatesTo().setStringValue(relatedMessageId);
        SoapUtil.addToHeader(header, relatesToDoc.getRelatesTo().getDomNode());
    }

    public static void addNewWsaMessageId(EnvelopeDocument envelopeDoc) {
        SoapUtil.addNewWsaMessageId(envelopeDoc, null);
    }

    public static void addNewWsaMessageId(EnvelopeDocument envelopeDoc, String messageIdPrefix) {
        SoapUtil.addWsaMessageId(envelopeDoc, SoapUtil.generateSoapMessageId(messageIdPrefix));
    }

    private static String generateSoapMessageId(String messageIdPrefix) {
        String randomId = UUID.randomUUID().toString();
        return messageIdPrefix == null ? randomId : messageIdPrefix + randomId;
    }

    public static void addWsaMessageId(EnvelopeDocument envelopeDoc, String messageId) {
        Envelope envelope = envelopeDoc.getEnvelope();
        if (!envelope.isSetHeader()) {
            envelope.addNewHeader();
        }
        Header header = envelope.getHeader();
        MessageIDDocument messageIdDoc = MessageIDDocument.Factory.newInstance();
        messageIdDoc.addNewMessageID().setStringValue(messageId);
        SoapUtil.addToHeader(header, messageIdDoc.getMessageID().getDomNode());
    }

    private static void addToHeader(Header header, Node nodeToAdd) {
        Document ownerDocument = header.getDomNode().getOwnerDocument();
        Node importedNode = ownerDocument.importNode(nodeToAdd, true);
        header.getDomNode().appendChild(importedNode);
    }

    public static boolean validateXml(XmlObject xml) throws XMLHandlingException {
        Collection<XmlError> errors = XMLBeansParser.validate(xml);
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("Invalid request/response:");
            for (XmlError xmlError : errors) {
                sb.append("\n[xmlError] ").append(xmlError.toString());
            }
            throw new XMLHandlingException(sb.toString());
        }
        return true;
    }
}

