/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.om;

import java.io.IOException;
import net.opengis.om.x20.OMObservationType;
import net.opengis.waterml.x20.MeasurementTimeseriesDocument;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ogc.MarshallingUtil;
import ucar.nc2.ogc.gml.NcFeaturePropertyType;
import ucar.nc2.ogc.gml.NcReferenceType;
import ucar.nc2.ogc.gml.NcTimeInstantPropertyType;
import ucar.nc2.ogc.om.NcOMProcessPropertyType;
import ucar.nc2.ogc.om.NcTimeObjectPropertyType;
import ucar.nc2.ogc.waterml.NcMeasurementTimeseriesType;

public abstract class NcOMObservationType {
    public static OMObservationType initOmObservation(OMObservationType omObservation, StationTimeSeriesFeature stationFeat, VariableSimpleIF dataVar) throws IOException {
        String id = MarshallingUtil.createIdForType(OMObservationType.class);
        omObservation.setId(id);
        NcTimeObjectPropertyType.initPhenomenonTime(omObservation.addNewPhenomenonTime(), stationFeat);
        NcTimeInstantPropertyType.initResultTime(omObservation.addNewResultTime());
        NcReferenceType.initObservedProperty(omObservation.addNewObservedProperty(), dataVar);
        NcOMProcessPropertyType.initProcedure(omObservation.addNewProcedure());
        NcFeaturePropertyType.initFeatureOfInterest(omObservation.addNewFeatureOfInterest(), stationFeat);
        MeasurementTimeseriesDocument measurementTimeseriesDoc = MeasurementTimeseriesDocument.Factory.newInstance();
        NcMeasurementTimeseriesType.initMeasurementTimeseries(measurementTimeseriesDoc.addNewMeasurementTimeseries(), stationFeat, dataVar);
        omObservation.setResult(measurementTimeseriesDoc);
        return omObservation;
    }

    private NcOMObservationType() {
    }
}

