/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import com.google.common.base.Preconditions;
import java.io.File;

public class S3URI {
    public static final String S3_PREFIX = "s3://";
    public static final String S3_DELIMITER = "/";
    private final String bucket;
    private final String key;

    public S3URI(String uri) {
        if (uri.startsWith(S3_PREFIX)) {
            int delimPos = (uri = uri.substring(S3_PREFIX.length(), uri.length())).indexOf(S3_DELIMITER);
            if (delimPos == -1) {
                this.bucket = S3URI.checkBucket(uri);
                this.key = S3URI.checkKey(null);
            } else {
                this.bucket = S3URI.checkBucket(uri.substring(0, delimPos));
                this.key = S3URI.checkKey(uri.substring(delimPos + 1, uri.length()));
            }
        } else {
            throw new IllegalArgumentException(String.format("S3 URI '%s' does not start with the expected prefix '%s'.", uri, S3_PREFIX));
        }
    }

    public S3URI(String bucket, String key) throws IllegalArgumentException {
        this.bucket = S3URI.checkBucket(bucket);
        this.key = S3URI.checkKey(key);
    }

    private static String checkBucket(String bucket) throws IllegalArgumentException {
        Preconditions.checkNotNull(bucket, "Bucket must be non-null.");
        if (bucket.length() < 3) {
            throw new IllegalArgumentException(String.format("Bucket name '%s' must be at least 3 characters.", bucket));
        }
        return bucket;
    }

    private static String checkKey(String key) throws IllegalArgumentException {
        if (key == null) {
            return null;
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("Key may not be the empty string.");
        }
        if (key.contains("//")) {
            throw new IllegalArgumentException(String.format("Key '%s' contains consecutive delimiters.", key));
        }
        if (key.endsWith(S3_DELIMITER)) {
            return key.substring(0, key.length() - 1);
        }
        return key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyWithTrailingDelimiter() {
        if (this.key == null) {
            return null;
        }
        assert (!this.key.endsWith(S3_DELIMITER)) : "Didn't we strip this in the ctor?";
        return this.key + S3_DELIMITER;
    }

    public String getBaseName() {
        if (this.key == null) {
            return null;
        }
        return new File(this.key).getName();
    }

    public S3URI getParent() {
        if (this.key == null) {
            return null;
        }
        int lastDelimPos = this.key.lastIndexOf(S3_DELIMITER);
        if (lastDelimPos == -1) {
            return new S3URI(this.bucket, null);
        }
        return new S3URI(this.bucket, this.key.substring(0, lastDelimPos));
    }

    public S3URI getChild(String relativePath) throws IllegalArgumentException {
        Preconditions.checkNotNull(relativePath, "relativePath must be non-null.");
        Preconditions.checkArgument(!relativePath.isEmpty(), "relativePath must be non-empty");
        if (relativePath.startsWith(S3_DELIMITER)) {
            throw new IllegalArgumentException(String.format("Path '%s' should be relative but begins with the delimiter string '%s'.", relativePath, S3_DELIMITER));
        }
        if (this.key == null) {
            return new S3URI(this.bucket, relativePath);
        }
        return new S3URI(this.bucket, this.key + S3_DELIMITER + relativePath);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(S3_PREFIX);
        strBuilder.append(this.bucket);
        if (this.key != null) {
            strBuilder.append(S3_DELIMITER);
            strBuilder.append(this.key);
        }
        return strBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3URI other = (S3URI)o;
        return this.bucket.equals(other.bucket) && this.key == null ? other.key == null : this.key.equals(other.key);
    }

    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

