/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import thredds.logs.LogCategorizer;
import thredds.logs.LogReader;
import thredds.ui.monitor.AccessLogTable;
import thredds.ui.monitor.LogLocalManager;
import thredds.ui.monitor.ManageForm;
import thredds.ui.monitor.ServletLogTable;
import thredds.ui.monitor.TdsDownloader;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPSession;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.ui.widget.URLDumpPane;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.HttpClientManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class TdsMonitor
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private PreferencesExt mainPrefs;
    private JTabbedPane tabbedPane;
    private ManagePanel managePanel;
    private AccessLogPanel accessLogPanel;
    private ServletLogPanel servletLogPanel;
    private URLDumpPane urlDump;
    private JFrame parentFrame;
    private FileManager fileChooser;
    private ManageForm manage;
    private static TdsMonitor ui;
    private static boolean done;
    private static File ehLocation;
    private static String config;
    private CacheManager cacheManager;
    private Cache dnsCache;
    String filterIP = "128.117.156,128.117.140,128.117.149";

    public TdsMonitor(PreferencesExt prefs, JFrame parentFrame) throws HTTPException {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        this.makeCache();
        this.fileChooser = new FileManager(parentFrame, null, null, (PreferencesExt)prefs.node("FileManager"));
        this.tabbedPane = new JTabbedPane(1);
        this.managePanel = new ManagePanel((PreferencesExt)this.mainPrefs.node("ManageLogs"));
        this.accessLogPanel = new AccessLogPanel((PreferencesExt)this.mainPrefs.node("LogTable"));
        this.servletLogPanel = new ServletLogPanel((PreferencesExt)this.mainPrefs.node("ServletLogPanel"));
        this.urlDump = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
        this.tabbedPane.addTab("ManageLogs", this.managePanel);
        this.tabbedPane.addTab("AccessLogs", this.accessLogPanel);
        this.tabbedPane.addTab("ServletLogs", this.servletLogPanel);
        this.tabbedPane.addTab("UrlDump", this.urlDump);
        this.tabbedPane.setSelectedIndex(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        UrlAuthenticatorDialog provider = new UrlAuthenticatorDialog(null);
        try {
            HTTPSession.setGlobalCredentialsProvider(provider, "Basic");
        }
        catch (HTTPException e) {
            System.err.println("Failed to set credentials");
        }
        HTTPSession.setGlobalUserAgent("TdsMonitor");
    }

    public void exit() {
        if (this.dnsCache != null) {
            System.out.printf(" cache= %s%n", this.dnsCache.toString());
            System.out.printf(" cache.size= %d%n", this.dnsCache.getSize());
            System.out.printf(" cache.memorySize= %d%n", this.dnsCache.getMemoryStoreSize());
            Statistics stats = this.dnsCache.getStatistics();
            System.out.printf(" stats= %s%n", stats.toString());
        }
        this.cacheManager.shutdown();
        this.fileChooser.save();
        this.managePanel.save();
        this.accessLogPanel.save();
        this.servletLogPanel.save();
        this.urlDump.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        System.exit(0);
    }

    private void gotoUrlDump(String urlString) {
        this.urlDump.setURL(urlString);
        this.tabbedPane.setSelectedIndex(3);
    }

    void makeCache() {
        this.cacheManager = new CacheManager(new StringBufferInputStream(config));
        this.dnsCache = this.cacheManager.getCache("dns");
    }

    public static void main(String[] args) throws HTTPException {
        try {
            String prefStore = XMLStore.makeStandardFilename(".unidata", "TdsMonitor.xml");
            store = XMLStore.createFromFile(prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore(prefs.node("Debug"));
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        BAMutil.setResourcePath("/resources/nj22/ui/icons/");
        frame = new JFrame("TDS Monitor");
        ui = new TdsMonitor(prefs, frame);
        frame.setIconImage(BAMutil.getImage("netcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ui.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
    }

    static {
        done = false;
        ehLocation = LogLocalManager.getDirectory("cache", "dns");
        config = "<ehcache>\n    <diskStore path='" + ehLocation.getPath() + "'/>\n" + "    <defaultCache\n" + "              maxElementsInMemory='10000'\n" + "              eternal='false'\n" + "              timeToIdleSeconds='120'\n" + "              timeToLiveSeconds='120'\n" + "              overflowToDisk='true'\n" + "              maxElementsOnDisk='10000000'\n" + "              diskPersistent='false'\n" + "              diskExpiryThreadIntervalSeconds='120'\n" + "              memoryStoreEvictionPolicy='LRU'\n" + "              />\n" + "    <cache name='dns'\n" + "            maxElementsInMemory='5000'\n" + "            eternal='false'\n" + "            timeToIdleSeconds='86400'\n" + "            timeToLiveSeconds='864000'\n" + "            overflowToDisk='true'\n" + "            maxElementsOnDisk='0'\n" + "            diskPersistent='true'\n" + "            diskExpiryThreadIntervalSeconds='3600'\n" + "            memoryStoreEvictionPolicy='LRU'\n" + "            />\n" + "</ehcache>";
    }

    private class ServletLogPanel
    extends OpPanel {
        ServletLogTable logTable;

        ServletLogPanel(PreferencesExt p) {
            super(p, false);
            this.logTable = new ServletLogTable(this.startDateField, this.endDateField, p, TdsMonitor.this.dnsCache);
            this.add((Component)this.logTable, "Center");
        }

        @Override
        void setLocalManager(LogLocalManager manager) {
            this.logTable.setLocalManager(manager);
        }

        @Override
        void showLogs() {
            ServletLogTable.MergeFilter filter = null;
            if (this.removeTestReq) {
                filter = new ServletLogTable.IpFilter(TdsMonitor.this.filterIP.split(","), filter);
            }
            if (this.problemsOnly) {
                filter = new ServletLogTable.ErrorOnlyFilter(filter);
            }
            this.logTable.showLogs(filter);
        }

        @Override
        void resetLogs() {
        }

        @Override
        void showInfo(Formatter f) {
            this.logTable.showInfo(f);
        }

        @Override
        void save() {
            this.logTable.exit();
            super.save();
        }
    }

    private class AccessLogPanel
    extends OpPanel {
        AccessLogTable logTable;

        AccessLogPanel(PreferencesExt p) {
            super(p, true);
            this.logTable = new AccessLogTable(this.startDateField, this.endDateField, p, TdsMonitor.this.dnsCache);
            this.logTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("UrlDump")) {
                        String path = (String)e.getNewValue();
                        TdsMonitor.this.gotoUrlDump(path);
                    }
                }
            });
            AbstractAction allAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessLogPanel.this.resetLogs();
                }
            };
            BAMutil.setActionProperties(allAction, "Refresh", "show All Logs", false, 65, -1);
            BAMutil.addActionToContainer(this.topPanel, allAction);
            AbstractAction dnsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessLogPanel.this.showDNS();
                }
            };
            BAMutil.setActionProperties(dnsAction, "Dataset", "lookup DNS", false, 68, -1);
            BAMutil.addActionToContainer(this.topPanel, dnsAction);
            this.add((Component)this.logTable, "Center");
        }

        @Override
        void setLocalManager(LogLocalManager manager) {
            this.logTable.setLocalManager(manager);
        }

        @Override
        void showLogs() {
            LogReader.LogFilter filter = null;
            if (this.removeTestReq) {
                filter = new LogReader.IpFilter(TdsMonitor.this.filterIP.split(","), filter);
            }
            if (this.problemsOnly) {
                filter = new LogReader.ErrorOnlyFilter(filter);
            }
            this.logTable.showLogs(filter);
        }

        @Override
        void showInfo(Formatter f) {
            this.logTable.showInfo(f);
        }

        @Override
        void resetLogs() {
            this.logTable.resetLogs();
        }

        void showDNS() {
            this.logTable.showDNS();
        }

        @Override
        void save() {
            this.logTable.exit();
            super.save();
        }
    }

    private abstract class OpPanel
    extends JPanel {
        PreferencesExt prefs;
        TextHistoryPane ta;
        IndependentWindow infoWindow;
        JComboBox serverCB;
        JTextArea startDateField;
        JTextArea endDateField;
        JPanel topPanel;
        boolean isAccess;
        boolean removeTestReq;
        boolean problemsOnly;
        private LogLocalManager manager;

        OpPanel(PreferencesExt prefs, boolean isAccess) {
            this.prefs = prefs;
            this.isAccess = isAccess;
            this.ta = new TextHistoryPane(true);
            this.infoWindow = new IndependentWindow("Details", BAMutil.getImage("netcdfUI"), new JScrollPane(this.ta));
            Rectangle bounds = (Rectangle)prefs.getBean(TdsMonitor.FRAME_SIZE, new Rectangle(200, 50, 500, 700));
            this.infoWindow.setBounds(bounds);
            this.topPanel = new JPanel(new FlowLayout(0, 5, 0));
            this.serverCB = new JComboBox();
            this.serverCB.setModel(TdsMonitor.this.manage.getServersCB().getModel());
            this.serverCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String server = (String)OpPanel.this.serverCB.getSelectedItem();
                    OpPanel.this.setServer(server);
                }
            });
            this.topPanel.add(new JLabel("server:"));
            this.topPanel.add(this.serverCB);
            this.startDateField = new JTextArea("                    ");
            this.endDateField = new JTextArea("                    ");
            this.topPanel.add(new JLabel("Start Date:"));
            this.topPanel.add(this.startDateField);
            this.topPanel.add(new JLabel("End Date:"));
            this.topPanel.add(this.endDateField);
            AbstractAction showAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpPanel.this.showLogs();
                }
            };
            BAMutil.setActionProperties(showAction, "Import", "get logs", false, 71, -1);
            BAMutil.addActionToContainer(this.topPanel, showAction);
            AbstractAction filterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    OpPanel.this.removeTestReq = state;
                }
            };
            BAMutil.setActionProperties(filterAction, "time", "remove test Requests", true, 70, -1);
            BAMutil.addActionToContainer(this.topPanel, filterAction);
            AbstractAction filter2Action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    OpPanel.this.problemsOnly = state;
                }
            };
            BAMutil.setActionProperties(filter2Action, "time", "only show problems", true, 70, -1);
            BAMutil.addActionToContainer(this.topPanel, filter2Action);
            AbstractAction infoAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    OpPanel.this.showInfo(f);
                    OpPanel.this.ta.setText(f.toString());
                    OpPanel.this.infoWindow.show();
                }
            };
            BAMutil.setActionProperties(infoAction, "Information", "info on selected logs", false, 73, -1);
            BAMutil.addActionToContainer(this.topPanel, infoAction);
            this.setLayout(new BorderLayout());
            this.add((Component)this.topPanel, "North");
        }

        public void setServer(String server) {
            this.manager = new LogLocalManager(server, this.isAccess);
            this.manager.getLocalFiles(null, null);
            this.setLocalManager(this.manager);
        }

        abstract void setLocalManager(LogLocalManager var1);

        abstract void showLogs();

        abstract void showInfo(Formatter var1);

        abstract void resetLogs();

        void save() {
            if (this.infoWindow != null) {
                this.prefs.putBeanObject(TdsMonitor.FRAME_SIZE, this.infoWindow.getBounds());
            }
        }
    }

    private class ManagePanel
    extends JPanel {
        PreferencesExt prefs;

        ManagePanel(PreferencesExt p) {
            this.prefs = p;
            TdsMonitor.this.manage = new ManageForm(this.prefs);
            this.setLayout(new BorderLayout());
            this.add((Component)TdsMonitor.this.manage, "Center");
            TdsMonitor.this.manage.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!evt.getPropertyName().equals("Download")) {
                        return;
                    }
                    ManageForm.Data data = (ManageForm.Data)evt.getNewValue();
                    try {
                        TdsDownloader logManager;
                        TdsMonitor.this.manage.getTextArea().setText("");
                        TdsMonitor.this.manage.getStopButton().setCancel(false);
                        if (data.wantAccess) {
                            logManager = new TdsDownloader(TdsMonitor.this.manage.getTextArea(), data, TdsDownloader.Type.access);
                            logManager.getRemoteFiles(TdsMonitor.this.manage.getStopButton());
                        }
                        if (data.wantServlet) {
                            logManager = new TdsDownloader(TdsMonitor.this.manage.getTextArea(), data, TdsDownloader.Type.thredds);
                            logManager.getRemoteFiles(TdsMonitor.this.manage.getStopButton());
                        }
                        if (data.wantRoots) {
                            String urls = data.getServerPrefix() + "/thredds/admin/log/dataroots.txt";
                            File localDir = LogLocalManager.getDirectory(data.server, "");
                            boolean ok = localDir.mkdirs();
                            File file = new File(localDir, "roots.txt");
                            HTTPSession session = HTTPFactory.newSession(urls);
                            session.setUserAgent("TdsMonitor");
                            JTextArea ta = TdsMonitor.this.manage.getTextArea();
                            try {
                                HttpClientManager.copyUrlContentsToFile(session, urls, file);
                                String roots = IO.readFile(file.getPath());
                                ta.append("\nRoots:\n");
                                ta.append(roots);
                                LogCategorizer.setRoots(roots);
                            }
                            catch (IOException ioe) {
                                StringWriter sw = new StringWriter(5000);
                                ioe.printStackTrace(new PrintWriter(sw));
                                ta.setText(sw.toString());
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    if (TdsMonitor.this.manage.getStopButton().isCancel()) {
                        TdsMonitor.this.manage.getTextArea().append("\nDownload canceled by user");
                    }
                }
            });
        }

        void save() {
            ComboBox servers = TdsMonitor.this.manage.getServersCB();
            servers.save();
        }
    }
}

