/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.http.Header;
import org.apache.http.entity.StringEntity;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.constants.CDM;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.util.IO;
import ucar.unidata.util.Urlencoded;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;

public class URLDumpPane
extends TextHistoryPane {
    private ComboBox cb;
    private JComboBox implCB;
    private HttpURLConnection currentConnection = null;
    private static XMLStore xstore;
    private static URLDumpPane main;

    public URLDumpPane(PreferencesExt prefs) {
        super(true);
        this.cb = new ComboBox(prefs);
        this.implCB = new JComboBox();
        for (Library e : Library.values()) {
            this.implCB.addItem(e);
        }
        JButton buttHead = new JButton("Head");
        buttHead.setToolTipText("Open URL connection, Headers only");
        buttHead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.process(urlString, Command.HEAD);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton buttRead = new JButton("Get");
        buttRead.setToolTipText("Open URL connection, Get content");
        buttRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.process(urlString, Command.GET);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton buttOpt = new JButton("Options");
        buttOpt.setToolTipText("Server options using HttpClient");
        buttOpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.process(urlString, Command.OPTIONS);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JButton buttPut = new JButton("Put");
        buttPut.setToolTipText("Put using HttpClient");
        buttPut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlString = (String)URLDumpPane.this.cb.getSelectedItem();
                URLDumpPane.this.process(urlString, Command.PUT);
                URLDumpPane.this.gotoTop();
                URLDumpPane.this.cb.addItem(urlString);
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(this.implCB);
        buttPanel.add(buttHead);
        buttPanel.add(buttRead);
        buttPanel.add(buttOpt);
        buttPanel.add(buttPut);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("URL:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add((Component)topPanel, "North");
    }

    private void process(String urlString, Command cmd) {
        this.clear();
        Library impl = (Library)((Object)this.implCB.getSelectedItem());
        if (impl == Library.Commons) {
            this.openURL2(urlString, cmd);
        } else if (impl == Library.java) {
            if (cmd == Command.GET) {
                this.readURL(urlString);
            } else if (cmd == Command.PUT) {
                this.putURL(urlString);
            } else {
                this.openURL(urlString, cmd);
            }
        }
    }

    private HTTPMethod processMethod(HTTPSession httpclient, String url, Command cmd) throws HTTPException, UnsupportedEncodingException {
        HTTPMethod m = null;
        if (cmd == Command.GET) {
            m = HTTPFactory.Get(httpclient, url);
        } else if (cmd == Command.HEAD) {
            m = HTTPFactory.Head(httpclient, url);
        } else if (cmd == Command.OPTIONS) {
            m = HTTPFactory.Options(httpclient, url);
        } else if (cmd == Command.PUT) {
            m = HTTPFactory.Put(httpclient, url);
            m.setRequestContent(new StringEntity(this.ta.getText()));
        }
        return m;
    }

    @Urlencoded
    private void openURL2(String urlString, Command cmd) {
        try (HTTPSession httpclient = HTTPFactory.newSession(urlString);){
            HTTPMethod m;
            if (cmd == Command.GET) {
                m = HTTPFactory.Get(httpclient, urlString);
            } else if (cmd == Command.HEAD) {
                m = HTTPFactory.Head(httpclient);
            } else if (cmd == Command.OPTIONS) {
                m = HTTPFactory.Options(httpclient);
            } else if (cmd == Command.PUT) {
                m = HTTPFactory.Put(httpclient);
                m.setRequestContent(new StringEntity(this.ta.getText()));
            } else {
                throw new IOException("Unsupported command: " + (Object)((Object)cmd));
            }
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            this.printHeaders("Request Headers = ", m.getRequestHeaders());
            this.appendLine(" ");
            m.execute();
            this.printHeaders("Request Headers2 = ", m.getRequestHeaders());
            this.appendLine(" ");
            this.appendLine("Status = " + m.getStatusCode() + " " + m.getStatusText());
            this.appendLine("Status Line = " + m.getStatusLine());
            this.printHeaders("Response Headers = ", m.getResponseHeaders());
            if (cmd == Command.GET) {
                String contents;
                Header h;
                String encoding;
                this.appendLine("\nResponseBody---------------");
                String charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
                if (encoding != null && encoding.equals("deflate")) {
                    byte[] body = m.getResponseAsBytes();
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                    contents = IO.readContents(is, charset);
                    double ratio = (double)contents.length() / (double)body.length;
                    this.appendLine("  deflate encoded=" + body.length + " decoded=" + contents.length() + " ratio= " + ratio);
                } else if (encoding != null && encoding.equals("gzip")) {
                    byte[] body = m.getResponseAsBytes();
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
                    contents = IO.readContents(is, charset);
                    double ratio = (double)contents.length() / (double)body.length;
                    this.appendLine("  gzip encoded=" + body.length + " decoded=" + contents.length() + " ratio= " + ratio);
                } else {
                    byte[] body = m.getResponseAsBytes(50000);
                    contents = new String(body, charset);
                }
                if (contents.length() > 50000) {
                    contents = contents.substring(0, 50000);
                }
                this.appendLine(contents);
            } else if (cmd == Command.OPTIONS) {
                this.printSet("AllowedMethods = ", HTTPMethod.getAllowedMethods());
            }
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.appendLine(sw.toString());
        }
    }

    private void printHeaders(String title, Header[] heads) {
        if (heads == null) {
            return;
        }
        this.appendLine(title);
        for (Header head : heads) {
            this.append("  " + head.toString() + "\n");
        }
    }

    private void printSet(String title, Set<String> en) {
        this.appendLine(title);
        for (String s : en) {
            this.append("  " + s);
        }
        this.appendLine("");
    }

    private void openURL(String urlString, Command command) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.currentConnection.setRequestMethod(command.toString());
            this.currentConnection.setAllowUserInteraction(true);
            this.clear();
            this.appendLine((Object)((Object)command) + " request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (Map.Entry<String, List<String>> ent : reqs.entrySet()) {
                this.append(" " + ent.getKey() + ": ");
                for (String v : ent.getValue()) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            this.appendLine("getFollowRedirects=" + HttpURLConnection.getFollowRedirects());
            this.appendLine("getInstanceFollowRedirects=" + this.currentConnection.getInstanceFollowRedirects());
            this.appendLine("AllowUserInteraction=" + this.currentConnection.getAllowUserInteraction());
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            this.appendLine(" content-length: " + this.currentConnection.getContentLength());
            this.appendLine(" content-encoding: " + this.currentConnection.getContentEncoding());
            this.appendLine(" content-type: " + this.currentConnection.getContentType());
            this.appendLine("\nHeaders: ");
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            this.appendLine("contents:");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy(is, bout);
            is.close();
            this.append(new String(bout.toByteArray(), CDM.utf8Charset));
            this.appendLine("end contents");
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readURL(String urlString) {
        try {
            URL u = new URL(urlString);
            this.currentConnection = (HttpURLConnection)u.openConnection();
            this.clear();
            this.appendLine("GET request for " + urlString);
            Map<String, List<String>> reqs = this.currentConnection.getRequestProperties();
            for (Map.Entry<String, List<String>> ent : reqs.entrySet()) {
                this.append(" " + ent.getKey() + ": ");
                for (String v : ent.getValue()) {
                    this.append(v + " ");
                }
                this.appendLine("");
            }
            this.appendLine("");
            int code = this.currentConnection.getResponseCode();
            String response = this.currentConnection.getResponseMessage();
            this.appendLine(" HTTP/1.x " + code + " " + response);
            int j = 1;
            while (true) {
                String header = this.currentConnection.getHeaderField(j);
                String key = this.currentConnection.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                this.appendLine(" " + key + ": " + header);
                ++j;
            }
            this.appendLine("");
            InputStream is = this.currentConnection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(200000);
            IO.copy(is, bout);
            is.close();
            this.append(new String(bout.toByteArray(), CDM.utf8Charset));
        }
        catch (MalformedURLException e) {
            this.append(urlString + " is not a parseable URL");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e);
            this.appendLine(e.getMessage());
        }
    }

    public void setURL(String urlString) {
        if (urlString == null) {
            return;
        }
        this.cb.addItem(urlString);
        this.clear();
    }

    void putURL(String urlString) {
        if (urlString == null) {
            return;
        }
        String contents = this.ta.getText();
        IO.HttpResult result = IO.putToURL(urlString, contents);
        JOptionPane.showMessageDialog(this, "Status code= " + result.statusCode + "\n" + result.message);
    }

    public void save() {
        this.cb.save();
    }

    public void append(String text) {
        this.ta.append(text);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("URL Dump Pane");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    main.save();
                    xstore.save();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                System.exit(0);
            }
        });
        Authenticator.setDefault(new UrlAuthenticatorDialog(frame));
        try {
            String storeFilename = XMLStore.makeStandardFilename(".unidata", "URLDumpPane.xml");
            xstore = XMLStore.createFromFile(storeFilename, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PreferencesExt store = xstore.getPreferences();
        main = new URLDumpPane(store);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(200, 200);
        frame.setSize(900, 700);
        frame.setVisible(true);
    }

    private static enum Command {
        GET,
        PUT,
        HEAD,
        OPTIONS;

    }

    private static enum Library {
        Commons,
        java;

    }
}

