/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.StringEntity;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.IO;
import ucar.unidata.util.Urlencoded;

public class HttpClientManager {
    private static boolean debug = false;
    private static int timeout = 0;

    public static void init(CredentialsProvider provider, String userAgent) {
        if (provider != null) {
            try {
                HTTPSession.setGlobalCredentialsProvider(provider, "Basic");
            }
            catch (HTTPException hTTPException) {
                // empty catch block
            }
        }
        if (userAgent != null) {
            HTTPSession.setGlobalUserAgent(userAgent + "/NetcdfJava/HttpClient");
        } else {
            HTTPSession.setGlobalUserAgent("NetcdfJava/HttpClient");
        }
    }

    @Urlencoded
    public static String getContentAsString(String urlencoded) throws IOException {
        return HttpClientManager.getContentAsString(null, urlencoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Urlencoded
    public static String getContentAsString(HTTPSession session, String urlencoded) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get(useSession, urlencoded);
            m.execute();
            String string = m.getResponseAsString();
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static int putContent(String urlencoded, String content) throws IOException {
        try (HTTPMethod m = HTTPFactory.Put(urlencoded);){
            Header locationHeader;
            m.setRequestContent(new StringEntity(content, "application/text", "UTF-8"));
            m.execute();
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
    }

    public static String getUrlContentsAsString(String urlencoded, int maxKbytes) throws IOException {
        return HttpClientManager.getUrlContentsAsString(null, urlencoded, maxKbytes);
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static String getUrlContentsAsString(HTTPSession session, String urlencoded, int maxKbytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy(is, bout, 1000 * maxKbytes);
        return bout.toString(charset);
    }

    public static void copyUrlContentsToFile(String urlencoded, File file) throws IOException {
        HttpClientManager.copyUrlContentsToFile(null, urlencoded, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyUrlContentsToFile(HTTPSession session, String urlencoded, File file) throws IOException {
        HTTPSession useSession = session;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get(useSession, urlencoded);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            int status = m.execute();
            if (status != 200) {
                throw new IOException(urlencoded + ": failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile(is, file.getPath());
            } else if (encoding != null && encoding.equals("gzip")) {
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile(is, file.getPath());
            } else {
                IO.writeToFile(m.getResponseAsStream(), file.getPath());
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static long appendUrlContentsToFile(String urlencoded, File file, long start, long end) throws IOException {
        return HttpClientManager.appendUrlContentsToFile(null, urlencoded, file, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long appendUrlContentsToFile(HTTPSession session, String urlencoded, File file, long start, long end) throws IOException {
        HTTPSession useSession = session;
        long nbytes = 0L;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession(urlencoded);
            }
            try (HTTPMethod m = HTTPFactory.Get(useSession, urlencoded);){
                Header h;
                String encoding;
                m.setRequestHeader("Accept-Encoding", "gzip,deflate");
                m.setRequestHeader("Range", "bytes=" + start + "-" + end);
                int status = m.execute();
                if (status != 200 && status != 206) {
                    throw new RuntimeException("failed status = " + status);
                }
                String charset = m.getResponseCharSet();
                if (charset == null) {
                    charset = "UTF-8";
                }
                String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
                if (encoding != null && encoding.equals("deflate")) {
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                    nbytes = IO.appendToFile(is, file.getPath());
                } else if (encoding != null && encoding.equals("gzip")) {
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                    nbytes = IO.appendToFile(is, file.getPath());
                } else {
                    nbytes = IO.appendToFile(m.getResponseAsStream(), file.getPath());
                }
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
        return nbytes;
    }
}

