/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethodStream;
import ucar.httpservices.HTTPSession;
import ucar.httpservices.HTTPUtil;

public class HTTPMethod
implements Closeable {
    protected HTTPSession session = null;
    protected boolean localsession = false;
    protected URI methodurl = null;
    protected String userinfo = null;
    protected HttpEntity content = null;
    protected HTTPSession.Methods methodkind = null;
    protected HTTPMethodStream methodstream = null;
    protected boolean closed = false;
    protected HttpUriRequest debugrequest = null;
    protected HttpResponse response = null;
    protected long[] range = null;
    protected List<Header> headers = new ArrayList<Header>();

    public static Set<String> getAllowedMethods() {
        BasicHttpResponse rs = new BasicHttpResponse(new ProtocolVersion("http", 1, 1), 0, "");
        Set<String> set = new HttpOptions().getAllowedMethods(rs);
        return set;
    }

    HTTPMethod() throws HTTPException {
    }

    HTTPMethod(HTTPSession.Methods m, String url) throws HTTPException {
        this(m, null, url);
    }

    HTTPMethod(HTTPSession.Methods m, HTTPSession session) throws HTTPException {
        this(m, session, null);
    }

    HTTPMethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        url = HTTPUtil.nullify(url);
        if (url == null && session != null) {
            url = session.getSessionURI();
        }
        if (url == null) {
            throw new HTTPException("HTTPMethod: cannot find usable url");
        }
        try {
            this.methodurl = HTTPUtil.parseToURI(url);
        }
        catch (URISyntaxException mue) {
            throw new HTTPException("Malformed URL: " + url, mue);
        }
        if (session == null) {
            session = HTTPFactory.newSession(url);
            this.localsession = true;
        }
        this.session = session;
        this.userinfo = HTTPUtil.nullify(this.methodurl.getUserInfo());
        if (this.userinfo != null) {
            this.methodurl = HTTPUtil.uriExclude(this.methodurl, HTTPUtil.URIPart.USERINFO);
            this.session.setCredentials(new UsernamePasswordCredentials(this.userinfo));
        }
        this.session.addMethod(this);
        this.methodkind = m;
    }

    protected RequestBuilder buildrequest() throws HTTPException {
        if (this.methodurl == null) {
            throw new HTTPException("Null url");
        }
        RequestBuilder rb = null;
        switch (this.methodkind) {
            case Put: {
                rb = RequestBuilder.put();
                break;
            }
            case Post: {
                rb = RequestBuilder.post();
                break;
            }
            case Head: {
                rb = RequestBuilder.head();
                break;
            }
            case Options: {
                rb = RequestBuilder.options();
                break;
            }
            default: {
                rb = RequestBuilder.get();
            }
        }
        rb.setUri(this.methodurl);
        return rb;
    }

    protected void setheaders(RequestBuilder rb) {
        if (this.range != null) {
            rb.addHeader("Range", "bytes=" + this.range[0] + "-" + this.range[1]);
            this.range = null;
        }
        if (this.headers.size() > 0) {
            for (Header h : this.headers) {
                rb.addHeader(h);
            }
        }
    }

    protected void setcontent(RequestBuilder rb) {
        switch (this.methodkind) {
            case Put: {
                if (this.content == null) break;
                rb.setEntity(this.content);
                break;
            }
            case Post: {
                if (this.content == null) break;
                rb.setEntity(this.content);
                break;
            }
        }
        this.content = null;
    }

    public int execute() throws HTTPException {
        if (this.closed) {
            throw new HTTPException("HTTPMethod: attempt to execute closed method");
        }
        if (this.methodurl == null) {
            throw new HTTPException("HTTPMethod: no url specified");
        }
        if (!this.localsession && !this.sessionCompatible(this.methodurl)) {
            throw new HTTPException("HTTPMethod: session incompatible url: " + this.methodurl);
        }
        RequestBuilder rb = this.buildrequest();
        try {
            this.setcontent(rb);
            this.setheaders(rb);
            this.response = this.session.execute(this, this.methodurl, rb);
            HttpClientContext execcontext = this.session.getExecutionContext();
            this.debugrequest = (HttpUriRequest)execcontext.getRequest();
            int code = this.response.getStatusLine().getStatusCode();
            return code;
        }
        catch (Exception ie) {
            throw new HTTPException(ie);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.methodstream != null) {
            try {
                this.methodstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.methodstream = null;
        }
        if (this.session != null) {
            this.session.removeMethod(this);
            if (this.localsession) {
                this.session.close();
                this.session = null;
            }
        }
    }

    public String getMethodKind() {
        return this.methodkind.name();
    }

    public int getStatusCode() {
        return this.response == null ? 0 : this.response.getStatusLine().getStatusCode();
    }

    public String getStatusLine() {
        return this.response == null ? null : this.response.getStatusLine().toString();
    }

    public String getRequestLine() {
        throw new UnsupportedOperationException("getrequestline not implemented");
    }

    public String getPath() {
        return this.methodurl.toString();
    }

    public boolean canHoldContent() {
        return this.methodkind == HTTPSession.Methods.Head;
    }

    public InputStream getResponseBodyAsStream() {
        return this.getResponseAsStream();
    }

    public InputStream getResponseAsStream() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        if (this.methodstream != null) {
            HTTPSession.log.warn("HTTPRequest.getResponseBodyAsStream: Getting method stream multiple times");
        } else {
            HTTPMethodStream stream = null;
            try {
                if (this.response == null) {
                    return null;
                }
                stream = new HTTPMethodStream(this.response.getEntity().getContent(), this);
            }
            catch (Exception e) {
                stream = null;
            }
            this.methodstream = stream;
        }
        return this.methodstream;
    }

    public byte[] getResponseAsBytes(int maxbytes) {
        byte[] contents = this.getResponseAsBytes();
        if (contents != null && contents.length > maxbytes) {
            byte[] result = new byte[maxbytes];
            System.arraycopy(contents, 0, result, 0, maxbytes);
            contents = result;
        }
        return contents;
    }

    public byte[] getResponseAsBytes() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        byte[] content = null;
        if (this.response != null) {
            try {
                content = EntityUtils.toByteArray(this.response.getEntity());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return content;
    }

    public String getResponseAsString(String charset) {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        String content = null;
        if (this.response != null) {
            try {
                Charset cset = Charset.forName(charset);
                content = EntityUtils.toString(this.response.getEntity(), cset);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.close();
        return content;
    }

    public String getResponseAsString() {
        return this.getResponseAsString("UTF-8");
    }

    public Header getRequestHeader(String name) {
        Header[] hdrs;
        for (Header h : hdrs = this.getRequestHeaders()) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public Header getResponseHeader(String name) {
        try {
            return this.response.getFirstHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseHeaders() {
        try {
            Header[] hs = this.response.getAllHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public HTTPMethod setRequestContent(HttpEntity content) {
        this.content = content;
        return this;
    }

    public String getCharSet() {
        return "UTF-8";
    }

    public String getURL() {
        return this.methodurl.toString();
    }

    public String getStatusText() {
        return this.getStatusLine();
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public HTTPSession getSession() {
        return this.session;
    }

    public boolean isSessionLocal() {
        return this.localsession;
    }

    public boolean hasStreamOpen() {
        return this.methodstream != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public HTTPMethod setRange(long lo, long hi) {
        this.range = new long[]{lo, hi};
        return this;
    }

    public Header[] getRequestHeaders() {
        return this.session.getRequestHeaders();
    }

    public RequestConfig getDebugConfig() {
        return this.session.getDebugConfig();
    }

    public HTTPMethod setCompression(String compressors) {
        HTTPSession.setGlobalCompression(compressors);
        return this;
    }

    public HTTPMethod setFollowRedirects(boolean tf) {
        this.session.setFollowRedirects(tf);
        return this;
    }

    public HTTPMethod setUserAgent(String agent) {
        this.session.setUserAgent(agent);
        return this;
    }

    public HTTPMethod setUseSessions(boolean tf) {
        this.session.setUseSessions(tf);
        return this;
    }

    protected boolean sessionCompatible(AuthScope other) {
        return HTTPAuthUtil.authscopeCompatible(this.session.getAuthScope(), other);
    }

    protected boolean sessionCompatible(URI otheruri) {
        AuthScope other = HTTPAuthUtil.uriToAuthScope(otheruri);
        return this.sessionCompatible(other);
    }

    @Deprecated
    protected boolean sessionCompatible(HttpHost otherhost) {
        AuthScope other = HTTPAuthUtil.hostToAuthScope(otherhost);
        return this.sessionCompatible(other);
    }

    public HttpMessage debugRequest() {
        return this.debugrequest;
    }

    public HttpResponse debugResponse() {
        return this.response;
    }

    @Deprecated
    public String getName() {
        return this.getMethodKind();
    }

    @Deprecated
    public HTTPMethod setMethodHeaders(List<Header> headers) throws HTTPException {
        try {
            for (Header h : headers) {
                this.headers.add(h);
            }
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
        return this;
    }

    @Deprecated
    public HTTPMethod setRequestHeader(String name, String value) throws HTTPException {
        return this.setRequestHeader(new BasicHeader(name, value));
    }

    @Deprecated
    protected HTTPMethod setRequestHeader(Header h) throws HTTPException {
        try {
            this.headers.add(h);
        }
        catch (Exception e) {
            throw new HTTPException("cause", e);
        }
        return this;
    }
}

