/*
 * Decompiled with CFR 0.152.
 */
package org.n52.oxf.xmlbeans.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.oxf.xmlbeans.parser.GMLAbstractFeatureCase;
import org.n52.oxf.xmlbeans.parser.LaxValidationCase;
import org.n52.oxf.xmlbeans.parser.XMLHandlingException;
import org.n52.oxf.xmlbeans.parser.sosexample.ExceptionCode;
import org.n52.oxf.xmlbeans.parser.sosexample.OwsExceptionReport;
import org.w3c.dom.Node;

public class XMLBeansParser {
    private static List<LaxValidationCase> laxValidationCases;
    private static boolean validationGlobally;

    public static void setValidationGloballyEnabled(boolean b) {
        validationGlobally = b;
    }

    public static void registerLaxValidationCase(LaxValidationCase lvc) {
        laxValidationCases.add(lvc);
    }

    public static List<LaxValidationCase> getRegisteredLaxValidationCases() {
        return laxValidationCases;
    }

    public static XmlObject parse(String source) throws XMLHandlingException {
        return XMLBeansParser.parse(source, true);
    }

    public static XmlObject parse(String source, boolean validate) throws XMLHandlingException {
        XmlObject doc;
        try {
            doc = XmlObject.Factory.parse(source);
        }
        catch (XmlException e) {
            throw new XMLHandlingException("Cannot parse xml: " + e.getMessage(), e);
        }
        if (validate) {
            XMLBeansParser.validateOnParse(doc);
        }
        return doc;
    }

    public static XmlObject parse(InputStream resourceAsStream) throws XMLHandlingException {
        return XMLBeansParser.parse(resourceAsStream, true);
    }

    public static XmlObject parse(InputStream resourceAsStream, boolean validate) throws XMLHandlingException {
        XmlObject doc;
        try {
            doc = XmlObject.Factory.parse(resourceAsStream);
        }
        catch (XmlException e) {
            doc = XMLBeansParser.parseAsStringDueToXmlBeansStreamIssues(resourceAsStream, e);
        }
        catch (IOException e) {
            throw new XMLHandlingException("Cannot read the document: Transmission interrupted!", e);
        }
        if (validate) {
            XMLBeansParser.validateOnParse(doc);
        }
        return doc;
    }

    private static XmlObject parseAsStringDueToXmlBeansStreamIssues(InputStream resourceAsStream, XmlException e) throws XMLHandlingException {
        BufferedReader b = new BufferedReader(new InputStreamReader(resourceAsStream));
        StringWriter w = new StringWriter();
        try {
            while (b.ready()) {
                w.write(b.readLine());
            }
        }
        catch (IOException e2) {
            throw new XMLHandlingException("Cannot read the document: Transmission interrupted!", e);
        }
        try {
            return XmlObject.Factory.parse(w.toString());
        }
        catch (XmlException e1) {
            throw new XMLHandlingException("The document you supplied was incomplete. Please try again.", e);
        }
    }

    public static XmlObject parse(Node xmlnode) throws XMLHandlingException {
        return XMLBeansParser.parse(xmlnode, true);
    }

    public static XmlObject parse(Node xmlnode, boolean validate) throws XMLHandlingException {
        XmlObject doc;
        try {
            doc = XmlObject.Factory.parse(xmlnode);
        }
        catch (XmlException e) {
            throw new XMLHandlingException("Cannot read the node", e);
        }
        if (validate) {
            XMLBeansParser.validateOnParse(doc);
        }
        return doc;
    }

    private static void validateOnParse(XmlObject doc) throws XMLHandlingException {
        if (!validationGlobally) {
            return;
        }
        String errorString = XMLBeansParser.createErrorMessage(XMLBeansParser.validate(doc));
        if (errorString.length() > 0) {
            throw new XMLHandlingException(errorString);
        }
    }

    private static String createErrorMessage(Collection<XmlError> errors) {
        StringBuilder errorBuilder = new StringBuilder();
        for (XmlError xmlError : errors) {
            errorBuilder.append(xmlError.getMessage()).append(";");
        }
        if (!errors.isEmpty()) {
            errorBuilder.deleteCharAt(errorBuilder.length() - 1);
        }
        return errorBuilder.toString();
    }

    public static void strictValidate(XmlObject doc) throws XMLHandlingException {
        if (!validationGlobally) {
            return;
        }
        ArrayList validationErrors = new ArrayList();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = doc.validate(validationOptions);
        if (!isValid) {
            throw new XMLHandlingException("Invalid xml content\n", validationErrors);
        }
    }

    public static Collection<XmlError> validate(XmlObject doc) {
        HashSet<XmlError> validationErrors = new HashSet<XmlError>();
        if (!validationGlobally) {
            return validationErrors;
        }
        ArrayList<XmlError> allValidationErrors = new ArrayList<XmlError>();
        XmlOptions validationOptions = new XmlOptions();
        validationOptions.setErrorListener(allValidationErrors);
        boolean isValid = doc.validate(validationOptions);
        if (!isValid) {
            XMLBeansParser.filterValidationErrors(validationErrors, allValidationErrors);
        }
        return validationErrors;
    }

    private static void filterValidationErrors(Set<XmlError> validationErrors, List<XmlError> allValidationErrors) {
        if (laxValidationCases.isEmpty()) {
            validationErrors.addAll(allValidationErrors);
            return;
        }
        for (XmlError validationError : allValidationErrors) {
            boolean shouldPass = false;
            for (LaxValidationCase lvc : laxValidationCases) {
                if (!lvc.shouldPass(validationError)) continue;
                shouldPass = true;
                break;
            }
            if (shouldPass) continue;
            validationErrors.add(validationError);
        }
    }

    public void sosValidateExample(XmlObject xb_doc) throws OwsExceptionReport {
        XMLBeansParser.registerLaxValidationCase(GMLAbstractFeatureCase.getInstance());
        Collection<XmlError> exs = XMLBeansParser.validate(xb_doc);
        String message = null;
        String parameterName = null;
        for (XmlError error : exs) {
            String[] messAndElements;
            String[] messAndAttribute;
            ExceptionCode exCode = null;
            message = error.getMessage();
            if (message == null) continue;
            if (message.startsWith("The value")) {
                exCode = ExceptionCode.InvalidParameterValue;
                messAndAttribute = message.split("attribute '");
                if (messAndAttribute.length == 2) {
                    parameterName = messAndAttribute[1].replace("'", "");
                }
            } else if (message.contains("not a valid enumeration value")) {
                exCode = ExceptionCode.InvalidParameterValue;
                messAndAttribute = message.split(" ");
                parameterName = messAndAttribute[10];
            } else if (message.startsWith("Expected attribute")) {
                String[] attrAndRest;
                exCode = ExceptionCode.MissingParameterValue;
                messAndAttribute = message.split("attribute: ");
                if (messAndAttribute.length == 2 && (attrAndRest = messAndAttribute[1].split(" in")).length == 2) {
                    parameterName = attrAndRest[0];
                }
            } else if (message.startsWith("Expected element")) {
                exCode = ExceptionCode.MissingParameterValue;
                messAndElements = message.split(" '");
                if (messAndElements.length >= 2) {
                    String elements = messAndElements[1];
                    if (elements.contains("offering")) {
                        parameterName = "offering";
                    } else if (elements.contains("observedProperty")) {
                        parameterName = "observedProperty";
                    } else if (elements.contains("responseFormat")) {
                        parameterName = "responseFormat";
                    } else if (elements.contains("procedure")) {
                        parameterName = "procedure";
                    } else if (elements.contains("featureOfInterest")) {
                        parameterName = "featureOfInterest";
                    }
                }
            } else if (message.startsWith("Element")) {
                exCode = ExceptionCode.InvalidParameterValue;
                messAndElements = message.split(" '");
                if (messAndElements.length >= 2) {
                    String elements = messAndElements[1];
                    if (elements.contains("offering")) {
                        parameterName = "offering";
                    } else if (elements.contains("observedProperty")) {
                        parameterName = "observedProperty";
                    } else if (elements.contains("responseFormat")) {
                        parameterName = "responseFormat";
                    } else if (elements.contains("procedure")) {
                        parameterName = "procedure";
                    } else if (elements.contains("featureOfInterest")) {
                        parameterName = "featureOfInterest";
                    }
                }
            } else {
                OwsExceptionReport se = new OwsExceptionReport();
                se.addCodedException(ExceptionCode.InvalidRequest, null, "[XmlBeans validation error:] " + message);
                throw se;
            }
            OwsExceptionReport se = new OwsExceptionReport();
            se.addCodedException(exCode, parameterName, "[XmlBeans validation error:] " + message);
            throw se;
        }
    }

    static {
        validationGlobally = true;
        laxValidationCases = new ArrayList<LaxValidationCase>();
    }
}

