/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.waterml.x20.CollectionDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.joda.time.DateTime;
import org.n52.oxf.xmlbeans.parser.LaxValidationCase;
import org.n52.oxf.xmlbeans.parser.XMLBeansParser;
import org.n52.oxf.xmlbeans.parser.XMLHandlingException;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ogc.waterml.NcCollectionType;

public class MarshallingUtil {
    public static DateTime fixedGenerationDate = null;
    public static DateTime fixedResultTime = null;
    private static Map<Class<?>, Integer> idsMap = new HashMap();

    public static String createIdForType(Class<?> clazz) {
        Integer numIds = idsMap.get(clazz);
        if (numIds == null) {
            numIds = 0;
        }
        numIds = numIds + 1;
        String id = clazz.getSimpleName() + "." + numIds;
        idsMap.put(clazz, numIds);
        return id;
    }

    public static void resetIds() {
        idsMap.clear();
    }

    public static void marshalPointDataset(FeatureDatasetPoint fdPoint, OutputStream outputStream) throws IOException, XMLHandlingException {
        MarshallingUtil.marshalPointDataset(fdPoint, fdPoint.getDataVariables(), outputStream);
    }

    public static void marshalPointDataset(FeatureDatasetPoint fdPoint, List<VariableSimpleIF> dataVars, OutputStream outputStream) throws IOException, XMLHandlingException {
        MarshallingUtil.resetIds();
        CollectionDocument collectionDoc = CollectionDocument.Factory.newInstance();
        NcCollectionType.initCollection(collectionDoc.addNewCollection(), fdPoint, dataVars);
        MarshallingUtil.writeObject(collectionDoc, outputStream, true);
    }

    public static void writeObject(XmlObject doc, OutputStream out, boolean validate) throws IOException, XMLHandlingException {
        XmlCursor cursor = doc.newCursor();
        if (cursor.toFirstChild()) {
            String location = "http://www.opengis.net/waterml/2.0 http://schemas.opengis.net/waterml/2.0/waterml2.xsd";
            cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), location);
        }
        if (validate) {
            MarshallingUtil.validate(doc, false);
        }
        doc.save(out, MarshallingUtil.makeOptions());
    }

    private static XmlOptions makeOptions() {
        XmlOptions options = new XmlOptions();
        options.setSaveNamespacesFirst();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        options.setSaveAggressiveNamespaces();
        options.setSaveSuggestedPrefixes(MarshallingUtil.getSuggestedPrefixes());
        return options;
    }

    private static Map<String, String> getSuggestedPrefixes() {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        prefixMap.put("http://www.w3.org/1999/xlink", "xlink");
        prefixMap.put("http://www.opengis.net/gml/3.2", "gml");
        prefixMap.put("http://www.opengis.net/om/2.0", "om");
        prefixMap.put("http://www.opengis.net/sampling/2.0", "sam");
        prefixMap.put("http://www.opengis.net/samplingSpatial/2.0", "sams");
        prefixMap.put("http://www.opengis.net/swe/2.0", "swe");
        prefixMap.put("http://www.opengis.net/waterml/2.0", "wml2");
        prefixMap.put("http://www.opengis.net/waterml-dr/2.0", "wml2dr");
        prefixMap.put("http://www.opengis.net/gmlcov/1.0", "gmlcov");
        return prefixMap;
    }

    public static void validate(XmlObject doc, boolean strict) throws XMLHandlingException {
        String errorString;
        XMLBeansParser.getRegisteredLaxValidationCases().clear();
        if (!strict) {
            XMLBeansParser.registerLaxValidationCase(new GML32AbstractFeatureCase());
        }
        if ((errorString = MarshallingUtil.createErrorMessage(XMLBeansParser.validate(doc))).length() > 0) {
            throw new XMLHandlingException(errorString);
        }
    }

    private static String createErrorMessage(Collection<XmlError> errors) {
        StringBuilder errorBuilder = new StringBuilder();
        for (XmlError xmlError : errors) {
            errorBuilder.append(xmlError.getMessage()).append(";");
        }
        if (!errors.isEmpty()) {
            errorBuilder.deleteCharAt(errorBuilder.length() - 1);
        }
        return errorBuilder.toString();
    }

    private MarshallingUtil() {
    }

    private static class GML32AbstractFeatureCase
    implements LaxValidationCase {
        private static final Object FEATURE_QN = new QName("http://www.opengis.net/gml/3.2", "AbstractFeature");

        private GML32AbstractFeatureCase() {
        }

        @Override
        public boolean shouldPass(XmlValidationError xve) {
            return xve.getExpectedQNames() != null && xve.getExpectedQNames().contains(FEATURE_QN);
        }

        @Override
        public boolean shouldPass(XmlError validationError) {
            if (!(validationError instanceof XmlValidationError)) {
                return false;
            }
            XmlValidationError xve = (XmlValidationError)validationError;
            return this.shouldPass(xve);
        }
    }
}

