/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class MSRLECodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("MSRLE compression not supported.");
    }

    public byte[] decompress(byte[] data, Object options) throws FormatException {
        if (options == null || !(options instanceof Object[])) {
            return null;
        }
        Object[] o = (Object[])options;
        byte[] prev = (byte[])o[1];
        int[] dims = (int[])o[0];
        int x = dims[0];
        int y = dims[1];
        int pt = 0;
        short code = 0;
        short extra = 0;
        short stream = 0;
        int pixelPt = 0;
        int row = x;
        int rowPt = (y - 1) * row;
        int frameSize = y * row;
        if (prev == null) {
            prev = new byte[frameSize];
        }
        block0: while (rowPt >= 0 && pt < data.length && pixelPt < prev.length) {
            if ((stream = (short)data[pt++]) < 0) {
                stream = (short)(stream + 256);
            }
            if ((code = stream) == 0) {
                if ((stream = (short)data[pt++]) < 0) {
                    stream = (short)(stream + 256);
                }
                if (stream == 0) {
                    rowPt -= row;
                    pixelPt = 0;
                    continue;
                }
                if (stream == 1) {
                    return prev;
                }
                if (stream == 2) {
                    if ((stream = (short)data[pt++]) < 0) {
                        stream = (short)(stream + 256);
                    }
                    pixelPt += stream;
                    if ((stream = (short)data[pt++]) < 0) {
                        stream = (short)(stream + 256);
                    }
                    rowPt -= stream * row;
                    continue;
                }
                if (rowPt + pixelPt + stream > frameSize || rowPt < 0) {
                    return prev;
                }
                code = stream;
                extra = (short)(stream & 1);
                if (stream + code + extra > data.length) {
                    return prev;
                }
                while (true) {
                    short s2 = code;
                    code = (short)(code - 1);
                    if (s2 <= 0) break;
                    stream = data[pt++];
                    prev[rowPt + pixelPt] = (byte)stream;
                    ++pixelPt;
                }
                if (extra == 0) continue;
                ++pt;
                continue;
            }
            if (rowPt + pixelPt + stream > frameSize || rowPt < 0) {
                return prev;
            }
            stream = data[pt++];
            while (true) {
                short s3 = code;
                code = (short)(code - 1);
                if (s3 <= 0) continue block0;
                prev[rowPt + pixelPt] = (byte)stream;
                ++pixelPt;
            }
        }
        return prev;
    }
}

