/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection;

public class TransverseMercator
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "transverse_mercator";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        ProjectionImpl proj;
        double lon0;
        double scale = this.readAttributeDouble(ctv, "scale_factor_at_central_meridian", Double.NaN);
        if (Double.isNaN(scale)) {
            scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin", Double.NaN);
        }
        if (Double.isNaN(lon0 = this.readAttributeDouble(ctv, "longitude_of_central_meridian", Double.NaN))) {
            lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        }
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", Double.NaN);
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = TransverseMercator.getFalseEastingScaleFactor(geoCoordinateUnits);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        double earth_radius = this.getEarthRadiusInKm(ctv);
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        double inverse_flattening = this.readAttributeDouble(ctv, "inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new TransverseMercatorProjection(earth, lon0, lat0, scale, false_easting, false_northing);
        } else {
            proj = new ucar.unidata.geoloc.projection.TransverseMercator(lat0, lon0, scale, false_easting, false_northing, earth_radius);
        }
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

