/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.SparseArray;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.ui.MFileTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class CdmIndexPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(CdmIndexPanel.class);
    private PreferencesExt prefs;
    private BeanTable groupTable;
    private BeanTable varTable;
    private BeanTable coordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoTA;
    private TextHistoryPane extraTA;
    private IndependentWindow infoWindow;
    private IndependentWindow extraWindow;
    private MFileTable fileTable;
    Path indexFile;
    GribCollectionImmutable gc;
    Collection<MFile> gcFiles;
    FeatureCollectionConfig config = new FeatureCollectionConfig();

    public CdmIndexPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        if (buttPanel != null) {
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndexPanel.this.showInfo(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            });
            buttPanel.add(infoButton);
            AbstractButton filesButton = BAMutil.makeButtcon("catalog", "Show Files", false);
            filesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CdmIndexPanel.this.gc != null) {
                        CdmIndexPanel.this.showFileTable(CdmIndexPanel.this.gc, null);
                    }
                }
            });
            buttPanel.add(filesButton);
            AbstractButton rawButton = BAMutil.makeButtcon("TableAppearence", "Estimate memory use", false);
            rawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndexPanel.this.showMemoryEst(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            });
            buttPanel.add(rawButton);
            AbstractButton checkAllButton = BAMutil.makeButtcon("Select", "Check entire file", false);
            rawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndexPanel.this.checkAll(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            });
            buttPanel.add(checkAllButton);
        }
        this.groupTable = new BeanTable(GroupBean.class, (PreferencesExt)prefs.node("GroupBean"), false, "GDS group", "GribCollectionImmutable.GroupHcs", null);
        this.groupTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GroupBean bean = (GroupBean)CdmIndexPanel.this.groupTable.getSelectedBean();
                if (bean != null) {
                    CdmIndexPanel.this.setGroup(bean);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.groupTable.getJTable(), "Options");
        varPopup.addAction("Show Group Info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndexPanel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    Formatter f = new Formatter();
                    bean.group.show(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Files Used", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndexPanel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    CdmIndexPanel.this.showFileTable(CdmIndexPanel.this.gc, bean.group);
                }
            }
        });
        this.varTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Grib2Bean"), false, "Variables in group", "GribCollectionImmutable.VariableIndex", null);
        varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Variable(s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndexPanel.this.varTable.getSelectedBeans();
                CdmIndexPanel.this.infoTA.clear();
                for (VarBean bean : beans) {
                    CdmIndexPanel.this.infoTA.appendLine(bean.v.toStringFrom());
                }
                CdmIndexPanel.this.infoTA.gotoTop();
                CdmIndexPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show Sparse Array", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean bean = (VarBean)CdmIndexPanel.this.varTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showSparseArray(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Make Variable(s) GribConfig", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndexPanel.this.varTable.getSelectedBeans();
                CdmIndexPanel.this.infoTA.clear();
                Formatter f = new Formatter();
                for (VarBean bean : beans) {
                    bean.makeGribConfig(f);
                }
                CdmIndexPanel.this.infoTA.appendLine(f.toString());
                CdmIndexPanel.this.infoTA.gotoTop();
                CdmIndexPanel.this.infoWindow.show();
            }
        });
        this.coordTable = new BeanTable(CoordBean.class, (PreferencesExt)prefs.node("CoordBean"), false, "Coordinates in group", "Coordinates", null);
        varPopup = new PopupMenu(this.coordTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndexPanel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showCoords(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("ShowCompact", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndexPanel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showInfo(f, new Indent(2));
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Test Time2D isOrthogonal", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndexPanel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    CdmIndexPanel.this.testOrthogonal(f, bean.coord);
                    CdmIndexPanel.this.extraTA.setText(f.toString());
                    CdmIndexPanel.this.extraTA.gotoTop();
                    CdmIndexPanel.this.extraWindow.show();
                }
            }
        });
        varPopup.addAction("Test Time2D isRegular", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndexPanel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    CdmIndexPanel.this.testRegular(f, bean.coord);
                    CdmIndexPanel.this.extraTA.setText(f.toString());
                    CdmIndexPanel.this.extraTA.gotoTop();
                    CdmIndexPanel.this.extraWindow.show();
                }
            }
        });
        varPopup.addAction("Show Resolution distribution", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndexPanel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showResolution(f);
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Compare", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndexPanel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndexPanel.this.compareCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        CdmIndexPanel.this.compareCoords(f, bean1.coord, bean2.coord);
                    }
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Try to Merge", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndexPanel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndexPanel.this.mergeCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        f.format("CoordinateTime2D only", new Object[0]);
                    }
                    CdmIndexPanel.this.infoTA.setText(f.toString());
                    CdmIndexPanel.this.infoTA.gotoTop();
                    CdmIndexPanel.this.infoWindow.show();
                }
            }
        });
        this.fileTable = new MFileTable((PreferencesExt)prefs.node("MFileTable"), true);
        this.fileTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CdmIndexPanel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.extraTA = new TextHistoryPane();
        this.extraWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.extraTA);
        this.extraWindow.setBounds((Rectangle)prefs.getBean("ExtraWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split3 = new JSplitPane(0, false, this.groupTable, this.varTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 800));
        this.split2 = new JSplitPane(0, false, this.split3, this.coordTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.groupTable.saveState(false);
        this.varTable.saveState(false);
        this.coordTable.saveState(false);
        this.fileTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("ExtraWindowBounds", this.extraWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.split3 != null) {
            this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
        }
    }

    public void clear() {
        if (this.gc != null) {
            try {
                this.gc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.gc = null;
        this.groupTable.clearBeans();
        this.varTable.clearBeans();
        this.coordTable.clearBeans();
    }

    public void showInfo(Formatter f) {
        if (this.gc == null) {
            return;
        }
        this.gc.showIndex(f);
        f.format("%n", new Object[0]);
        f.format("Groups%n", new Object[0]);
        List groups = this.groupTable.getBeans();
        for (GroupBean bean : groups) {
            f.format("%-50s %-50s %d%n", bean.getGroupId(), bean.getDescription(), bean.getGdsHash());
            bean.group.show(f);
        }
        f.format("%n", new Object[0]);
    }

    private void showFileTable(GribCollectionImmutable gc, GribCollectionImmutable.GroupGC group) {
        File dir = gc.getDirectory();
        Collection<MFile> files = group == null ? gc.getFiles() : group.getFiles();
        this.fileTable.setFiles(dir, files);
    }

    private void checkAll(Formatter f) {
        if (this.gc == null) {
            return;
        }
        for (GribCollectionImmutable.Dataset ds : this.gc.getDatasets()) {
            f.format("Dataset %s%n", new Object[]{ds.getType()});
            int bytesTotal = 0;
            int bytesSATotal = 0;
            int coordsAllTotal = 0;
            for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                f.format(" Group %s%n", g2.getDescription());
                int count = 0;
                for (GribCollectionImmutable.VariableIndex v : g2.getVariables()) {
                    VarBean bean = new VarBean(v, g2);
                    if (v instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
                        if (count == 0) {
                            f.format(" total   VariablePartitioned%n", new Object[0]);
                        }
                        PartitionCollectionImmutable.VariableIndexPartitioned vip = (PartitionCollectionImmutable.VariableIndexPartitioned)v;
                        int nparts = vip.getNparts();
                        int memEstBytes = 368 + nparts * 4;
                        bytesTotal += memEstBytes;
                        f.format("%6d %-50s nparts=%6d%n", memEstBytes, bean.getName(), nparts);
                    } else {
                        if (count == 0) {
                            f.format(" total   SA  Variable%n", new Object[0]);
                        }
                        try {
                            v.readRecords();
                            SparseArray<GribCollectionImmutable.Record> sa = v.getSparseArray();
                            int ntracks = sa.getTotalSize();
                            int nrecords = sa.getContent().size();
                            int memEstForSA = 276 + nrecords * 40 + ntracks * 4;
                            int memEstBytes = 280 + memEstForSA;
                            f.format("%6d %6d %-50s nrecords=%6d%n", memEstBytes, memEstForSA, bean.getName(), nrecords);
                            bytesTotal += memEstBytes;
                            bytesSATotal += memEstForSA;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ++count;
                }
            }
            int noSA = bytesTotal - bytesSATotal;
            f.format("%n total KBytes=%d kbSATotal=%d kbNoSA=%d coordsAllTotal=%d%n", bytesTotal / 1000, bytesSATotal / 1000, noSA / 1000, coordsAllTotal / 1000);
            f.format("%n", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void showMemoryEst(Formatter f) {
        if (this.gc == null) {
            return;
        }
        for (GribCollectionImmutable.Dataset ds : this.gc.getDatasets()) {
            f.format("Dataset %s%n", new Object[]{ds.getType()});
            int bytesTotal = 0;
            int bytesSATotal = 0;
            int coordsAllTotal = 0;
            for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                f.format(" Group %s%n", g2.getDescription());
                ArrayList<SortBySize> sortList = new ArrayList<SortBySize>(g2.getCoordinates().size());
                for (Coordinate coordinate : g2.getCoordinates()) {
                    sortList.add(new SortBySize(coordinate, coordinate.estMemorySize()));
                }
                Collections.sort(sortList);
                int coordsTotal = 0;
                f.format("  totalKB  type Coordinate%n", new Object[0]);
                for (SortBySize ss : sortList) {
                    Coordinate vc3 = (Coordinate)ss.obj;
                    f.format("  %6d %-8s %-40s%n", new Object[]{vc3.estMemorySize() / 1000, vc3.getType(), vc3.getName()});
                    bytesTotal += vc3.estMemorySize();
                    coordsTotal += vc3.estMemorySize();
                }
                f.format(" %7d KBytes%n", coordsTotal / 1000);
                f.format("%n", new Object[0]);
                coordsAllTotal += coordsTotal;
                boolean bl = false;
                for (GribCollectionImmutable.VariableIndex v : g2.getVariables()) {
                    void var11_13;
                    VarBean bean = new VarBean(v, g2);
                    if (v instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
                        if (var11_13 == false) {
                            f.format(" total   VariablePartitioned%n", new Object[0]);
                        }
                        PartitionCollectionImmutable.VariableIndexPartitioned vip = (PartitionCollectionImmutable.VariableIndexPartitioned)v;
                        int nparts = vip.getNparts();
                        int memEstBytes = 368 + nparts * 4;
                        bytesTotal += memEstBytes;
                        f.format("%6d %-50s nparts=%6d%n", memEstBytes, bean.getName(), nparts);
                    } else {
                        if (var11_13 == false) {
                            f.format(" total   SA  Variable%n", new Object[0]);
                        }
                        try {
                            v.readRecords();
                            SparseArray<GribCollectionImmutable.Record> sa = v.getSparseArray();
                            int ntracks = sa.getTotalSize();
                            int nrecords = sa.getContent().size();
                            int memEstForSA = 276 + nrecords * 40 + ntracks * 4;
                            int memEstBytes = 280 + memEstForSA;
                            f.format("%6d %6d %-50s nrecords=%6d%n", memEstBytes, memEstForSA, bean.getName(), nrecords);
                            bytesTotal += memEstBytes;
                            bytesSATotal += memEstForSA;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ++var11_13;
                }
            }
            int noSA = bytesTotal - bytesSATotal;
            f.format("%n total KBytes=%d kbSATotal=%d kbNoSA=%d coordsAllTotal=%d%n", bytesTotal / 1000, bytesSATotal / 1000, noSA / 1000, coordsAllTotal / 1000);
            f.format("%n", new Object[0]);
        }
    }

    private void compareCoords(Formatter f, Coordinate coord1, Coordinate coord2) {
        List<? extends Object> vals1 = coord1.getValues();
        List<? extends Object> vals2 = coord2.getValues();
        f.format("Coordinate %s%n", coord1.getName());
        for (Object object : vals1) {
            if (vals2.contains(object)) continue;
            f.format(" %s ", object);
            if (object instanceof Long) {
                f.format("(%s) ", CalendarDate.of((Long)object));
            }
            f.format("MISSING IN 2%n", new Object[0]);
        }
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object object : vals2) {
            if (vals1.contains(object)) continue;
            f.format(" %s ", object);
            if (object instanceof Long) {
                f.format("(%s) ", CalendarDate.of((Long)object));
            }
            f.format("MISSING IN 1%n", new Object[0]);
        }
    }

    private void compareCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min2 = Math.min(n1, n2);
        for (int idx = 0; idx < min2; ++idx) {
            CoordinateTimeAbstract time1 = coord1.getTimeCoordinate(idx);
            CoordinateTimeAbstract time2 = coord2.getTimeCoordinate(idx);
            f.format("Run %d %n", idx);
            if (!runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) {
                f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
            }
            this.compareCoords(f, time1, time2);
        }
    }

    private void mergeCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        if (coord1.isTimeInterval() != coord2.isTimeInterval()) {
            f.format("Coordinate 1 isTimeInterval %s != Coordinate 2 isTimeInterval %s %n", coord1.isTimeInterval(), coord2.isTimeInterval());
            return;
        }
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min2 = Math.min(n1, n2);
        for (int idx = 0; idx < min2; ++idx) {
            if (runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) continue;
            f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
        }
        Set<Object> set1 = this.makeCoordSet(coord1);
        List<? extends Object> list1 = coord1.getOffsetsSorted();
        Set<Object> set2 = this.makeCoordSet(coord2);
        List<? extends Object> list2 = coord2.getOffsetsSorted();
        f.format("%nCoordinate %s%n", coord1.getName());
        for (Object object : list1) {
            f.format(" %s,", object);
        }
        f.format(" n=(%d)%n", list1.size());
        this.testMissing(f, list1, set2);
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object object : list2) {
            f.format(" %s,", object);
        }
        f.format(" (n=%d)%n", list2.size());
        this.testMissing(f, list2, set1);
    }

    private Set<Object> makeCoordSet(CoordinateTime2D time2D) {
        HashSet<Object> result = new HashSet<Object>(100);
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            for (Object object : coord.getValues()) {
                result.add(object);
            }
        }
        return result;
    }

    private void testMissing(Formatter f, List<? extends Object> test, Set<Object> against) {
        int countMissing = 0;
        for (Object object : test) {
            if (against.contains(object)) continue;
            f.format(" %d: %s MISSING%n", countMissing++, object);
        }
        f.format("TOTAL MISSING %s%n", countMissing);
    }

    private boolean testOrthogonal(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("testOrthogonal only on CoordinateTime2D%n", new Object[0]);
            return false;
        }
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        ArrayList<CoordinateTimeAbstract> coords = new ArrayList<CoordinateTimeAbstract>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            coords.add(time2D.getTimeCoordinate(runIdx));
        }
        return this.testOrthogonal(f, coords, true);
    }

    private boolean testOrthogonal(Formatter f, List<CoordinateTimeAbstract> times, boolean show) {
        boolean isOrthogonal;
        int max = 0;
        HashMap<Object, Integer> allCoords = new HashMap<Object, Integer>(1000);
        for (CoordinateTimeAbstract coord : times) {
            max = Math.max(max, coord.getSize());
            for (Object object : coord.getValues()) {
                Integer count = (Integer)allCoords.get(object);
                if (count == null) {
                    allCoords.put(object, 1);
                    continue;
                }
                allCoords.put(object, count + 1);
            }
        }
        int totalMax = allCoords.size();
        boolean bl = isOrthogonal = totalMax == max;
        if (show) {
            f.format("isOrthogonal %s : allCoords.size = %d max of coords=%d%nAllCoords=%n", isOrthogonal, totalMax, max);
            ArrayList allList = new ArrayList(allCoords.keySet());
            Collections.sort(allList);
            for (Object coord : allList) {
                Integer count = (Integer)allCoords.get(coord);
                f.format("  %4d %s%n", count, coord);
            }
        }
        return isOrthogonal;
    }

    private boolean testRegular(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("testOrthogonal only on CoordinateTime2D%n", new Object[0]);
            return false;
        }
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        HashMap<Integer, ArrayList<CoordinateTimeAbstract>> hourMap = new HashMap<Integer, ArrayList<CoordinateTimeAbstract>>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            CalendarDate runDate = coord.getRefDate();
            int hour = runDate.getHourOfDay();
            ArrayList<CoordinateTimeAbstract> hg = (ArrayList<CoordinateTimeAbstract>)hourMap.get(hour);
            if (hg == null) {
                hg = new ArrayList<CoordinateTimeAbstract>();
                hourMap.put(hour, hg);
            }
            hg.add(coord);
        }
        boolean ok = true;
        Iterator iterator = hourMap.keySet().iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            List hg = (List)hourMap.get(hour);
            boolean isOrthogonal = this.testOrthogonal(f, hg, false);
            f.format("Hour %d: isOrthogonal=%s%n", hour, isOrthogonal);
            ok &= isOrthogonal;
        }
        f.format("%nAll are orthogonal: %s%n", ok);
        if (ok) {
            return true;
        }
        iterator = hourMap.keySet().iterator();
        while (iterator.hasNext()) {
            int hour = (Integer)iterator.next();
            List hg = (List)hourMap.get(hour);
            f.format("Hour %d: %n", hour);
            this.testOrthogonal(f, hg, true);
            f.format("%n", new Object[0]);
        }
        return false;
    }

    private boolean testOrthogonal(Formatter f, List<CoordinateTimeAbstract> times) {
        int max = 0;
        HashSet<Object> allCoords = new HashSet<Object>(100);
        for (CoordinateTimeAbstract coord : times) {
            max = Math.max(max, coord.getSize());
            for (Object object : coord.getValues()) {
                allCoords.add(object);
            }
        }
        int totalMax = allCoords.size();
        boolean isOrthogonal = totalMax == max;
        f.format("isOrthogonal %s : allCoords.size = %d max of coords=%d%nAllCoords=%n", isOrthogonal, totalMax, max);
        for (Object object : allCoords) {
            f.format("  %s%n", object);
        }
        return isOrthogonal;
    }

    private void compareSortedList(Formatter f, Iterator<String> i1, Iterator<String> i2) {
        String s1 = null;
        String s2 = null;
        boolean need1 = true;
        boolean need2 = true;
        while (true) {
            if (need1) {
                String string = s1 = i1.hasNext() ? i1.next() : null;
            }
            if (need2) {
                s2 = i2.hasNext() ? i2.next() : null;
            }
            need1 = true;
            need2 = true;
            if (s1 == null && s2 == null) break;
            if (s1 == null) {
                f.format(" extra file = %s%n", s2);
                continue;
            }
            if (s2 == null) {
                f.format(" missing file = %s%n", s1);
                continue;
            }
            int pos = s1.lastIndexOf("/");
            String name1 = s1.substring(pos);
            name1 = name1.substring(1, name1.indexOf("gdas"));
            String name2 = s2.substring(pos);
            int val = name1.compareTo(name2 = name2.substring(1, name2.indexOf("gdas")));
            if (val < 0) {
                f.format(" missing file = %s%n", s1);
                need2 = false;
                continue;
            }
            if (val <= 0) continue;
            f.format(" extra file = %s%n", s2);
            need1 = false;
        }
    }

    public void setIndexFile(Path indexFile, FeatureCollectionConfig config) throws IOException {
        if (this.gc != null) {
            this.gc.close();
        }
        this.indexFile = indexFile;
        this.config = config;
        this.gc = GribCdmIndex.openCdmIndex(indexFile.toString(), config, false, logger);
        if (this.gc == null) {
            throw new IOException("File not a grib collection index file");
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (GribCollectionImmutable.Dataset ds : this.gc.getDatasets()) {
            for (GribCollectionImmutable.GroupGC g2 : ds.getGroups()) {
                groups.add(new GroupBean(g2, ds.getType().toString()));
            }
        }
        if (groups.size() > 0) {
            this.setGroup((GroupBean)groups.get(0));
        } else {
            this.varTable.clearBeans();
            this.coordTable.clearBeans();
        }
        this.groupTable.setBeans(groups);
        this.groupTable.setHeader(indexFile.toString());
        this.gcFiles = this.gc.getFiles();
    }

    private void setGroup(GroupBean bean) {
        bean.clear();
        ArrayList<VarBean> vars = new ArrayList<VarBean>();
        for (GribCollectionImmutable.VariableIndex v : bean.group.getVariables()) {
            VarBean vbean = new VarBean(v, bean.group);
            vars.add(vbean);
            bean.nrecords += vbean.getNrecords();
            bean.ndups += vbean.getNdups();
            bean.nmissing += vbean.getNmissing();
        }
        this.varTable.setBeans(vars);
        int count = 0;
        ArrayList<CoordBean> coords = new ArrayList<CoordBean>();
        for (Coordinate vc : bean.group.getCoordinates()) {
            coords.add(new CoordBean(vc, count++));
        }
        this.coordTable.setBeans(coords);
    }

    public class VarBean {
        GribCollectionImmutable.VariableIndex v;
        GribCollectionImmutable.GroupGC group;
        String name;

        public VarBean() {
        }

        public VarBean(GribCollectionImmutable.VariableIndex vindex, GribCollectionImmutable.GroupGC group) {
            this.v = vindex;
            this.group = group;
            this.name = vindex.makeVariableName();
        }

        public String getIndexes() {
            Formatter f = new Formatter();
            for (int idx : this.v.getCoordinateIndex()) {
                f.format("%d,", idx);
            }
            return f.toString();
        }

        public String getIntvName() {
            return this.v.getIntvName();
        }

        public int getCdmHash() {
            return this.v.hashCode();
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public String getVariableId() {
            return this.v.getDiscipline() + "-" + this.v.getCategory() + "-" + this.v.getParameter();
        }

        public String getName() {
            return this.name;
        }

        public int getNdups() {
            return this.v.getNdups();
        }

        public int getNrecords() {
            return this.v.getNrecords();
        }

        public int getNmissing() {
            int n = this.v.getSize();
            return n - this.v.getNrecords();
        }

        public int getSize() {
            return this.v.getSize();
        }

        public void makeGribConfig(Formatter f) {
            f.format("<variable id='%s'/>%n", this.getVariableId());
        }

        private void showSparseArray(Formatter f) {
            if (this.v instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
                PartitionCollectionImmutable.VariableIndexPartitioned vip = (PartitionCollectionImmutable.VariableIndexPartitioned)this.v;
                vip.show(f);
            } else {
                try {
                    this.v.readRecords();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                if (this.v.getSparseArray() != null) {
                    SparseArray<GribCollectionImmutable.Record> sa = this.v.getSparseArray();
                    sa.showInfo(f, null);
                    f.format("%n", new Object[0]);
                    sa.showTracks(f);
                    f.format("%n", new Object[0]);
                    sa.showContent(f);
                }
            }
        }
    }

    public class CoordBean
    implements Comparable<CoordBean> {
        Coordinate coord;
        int idx;
        double start;
        double end;
        double resol;
        Comparable resolMode;
        Counters counters;

        public CoordBean() {
        }

        public CoordBean(Coordinate coord, int idx) {
            this.coord = coord;
            this.idx = idx;
            this.counters = coord.calcDistributions();
            this.resolMode = this.counters.get("resol").getMode();
            if (coord instanceof CoordinateRuntime) {
                CoordinateRuntime runtime = (CoordinateRuntime)coord;
                List<Double> offsets = runtime.getOffsetsInTimeUnits();
                double offsetFromMaster = runtime.getOffsetInTimeUnits(CdmIndexPanel.this.gc.getMasterFirstDate());
                int n = offsets.size();
                this.start = offsets.get(0) + offsetFromMaster;
                this.end = offsets.get(n - 1) + offsetFromMaster;
                this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
            } else if (coord instanceof CoordinateTime2D) {
                CoordinateTime2D time = (CoordinateTime2D)coord;
                List<? extends Object> offsets = time.getOffsetsSorted();
                int n = offsets.size();
                if (time.isTimeInterval()) {
                    this.start = ((TimeCoord.Tinv)offsets.get(0)).getBounds1();
                    this.end = ((TimeCoord.Tinv)offsets.get(n - 1)).getBounds2();
                    this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
                } else {
                    this.start = ((Integer)offsets.get(0)).intValue();
                    this.end = ((Integer)offsets.get(n - 1)).intValue();
                    this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
                }
            } else if (coord instanceof CoordinateTime) {
                CoordinateTime time = (CoordinateTime)coord;
                List<Integer> offsets = time.getOffsetSorted();
                int n = offsets.size();
                double offsetFromMaster = time.getOffsetInTimeUnits(CdmIndexPanel.this.gc.getMasterFirstDate());
                this.start = (double)offsets.get(0).intValue() + offsetFromMaster;
                this.end = (double)offsets.get(n - 1).intValue() + offsetFromMaster;
                this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
            } else if (coord instanceof CoordinateTimeIntv) {
                CoordinateTimeIntv time = (CoordinateTimeIntv)coord;
                List<TimeCoord.Tinv> offsets = time.getTimeIntervals();
                double offsetFromMaster = time.getOffsetInTimeUnits(CdmIndexPanel.this.gc.getMasterFirstDate());
                int n = offsets.size();
                this.start = (double)offsets.get(0).getBounds1() + offsetFromMaster;
                this.end = (double)offsets.get(n - 1).getBounds2() + offsetFromMaster;
            } else if (coord instanceof CoordinateVert) {
                CoordinateVert vert = (CoordinateVert)coord;
                List<VertCoord.Level> offsets = vert.getLevelSorted();
                int n = offsets.size();
                if (vert.isLayer()) {
                    this.start = offsets.get(0).getValue1();
                    this.end = offsets.get(n - 1).getValue2();
                    this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
                } else {
                    this.start = offsets.get(0).getValue1();
                    this.end = offsets.get(n - 1).getValue1();
                    this.resol = n > 1 ? (this.end - this.start) / (double)(n - 1) : 0.0;
                }
            }
        }

        private void showResolution(Formatter f) {
            this.counters.show(f);
        }

        public double getStart() {
            return this.start;
        }

        public double getEnd() {
            return this.end;
        }

        public double getResol() {
            return this.resol;
        }

        public String getResolMode() {
            return this.resolMode == null ? "null" : this.resolMode.toString();
        }

        public String getValues() {
            Formatter f = new Formatter();
            if (this.coord instanceof CoordinateRuntime) {
                CoordinateRuntime runtime = (CoordinateRuntime)this.coord;
                f.format("%s %s", runtime.getFirstDate(), runtime.getLastDate());
            } else if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
                CalendarDateRange calendarDateRange = coord2D.makeCalendarDateRange(null);
                f.format("%s %s", calendarDateRange.getStart(), calendarDateRange.getEnd());
            } else {
                if (this.coord.getValues() == null) {
                    return "";
                }
                for (Object object : this.coord.getValues()) {
                    f.format("%s,", object);
                }
            }
            return f.toString();
        }

        public String getType() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%s %s", new Object[]{this.coord.getType(), c2d.isTimeInterval() ? "intv" : "offs"});
                if (c2d.isOrthogonal()) {
                    f.format(" ort", new Object[0]);
                }
                if (c2d.isRegular()) {
                    f.format(" reg", new Object[0]);
                }
                return f.toString();
            }
            return this.coord.getType().toString();
        }

        public String getSize() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%d X %d (%d)", c2d.getRuntimeCoordinate().getSize(), c2d.getNtimes(), this.coord.getSize());
                return f.toString();
            }
            return Integer.toString(this.coord.getSize());
        }

        public int getCode() {
            return this.coord.getCode();
        }

        public int getIndex() {
            return this.idx;
        }

        public String getUnit() {
            return this.coord.getUnit();
        }

        public String getRefDate() {
            if (this.coord instanceof CoordinateTimeAbstract) {
                return ((CoordinateTimeAbstract)this.coord).getRefDate().toString();
            }
            if (this.coord instanceof CoordinateRuntime) {
                return ((CoordinateRuntime)this.coord).getFirstDate().toString();
            }
            return "";
        }

        public String getName() {
            CoordinateTimeAbstract timeiCoord;
            String intvName = null;
            if (this.coord instanceof CoordinateTimeIntv) {
                timeiCoord = (CoordinateTimeIntv)this.coord;
                intvName = ((CoordinateTimeIntv)timeiCoord).getTimeIntervalName();
            }
            if (this.coord instanceof CoordinateTime2D) {
                timeiCoord = (CoordinateTime2D)this.coord;
                intvName = ((CoordinateTime2D)timeiCoord).getTimeIntervalName();
            }
            return intvName == null ? this.coord.getName() : this.coord.getName() + " (" + intvName + ")";
        }

        @Override
        public int compareTo(CoordBean o) {
            return this.getType().compareTo(o.getType());
        }

        void showCoords(Formatter f) {
            this.coord.showCoords(f);
        }
    }

    public class GroupBean {
        GribCollectionImmutable.GroupGC group;
        String type;
        int nrecords;
        int nmissing;
        int ndups;

        public GroupBean() {
        }

        public GroupBean(GribCollectionImmutable.GroupGC g2, String type) {
            this.group = g2;
            this.type = type;
            for (GribCollectionImmutable.VariableIndex vi : this.group.getVariables()) {
                this.nrecords += vi.getNrecords();
                this.ndups += vi.getNdups();
                this.nmissing += vi.getNmissing();
            }
        }

        void clear() {
            this.nmissing = 0;
            this.ndups = 0;
            this.nrecords = 0;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.getGdsHash().hashCode();
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public String getType() {
            return this.type;
        }

        public int getNFiles() {
            int n = this.group.getNFiles();
            if (n == 0 && CdmIndexPanel.this.gc instanceof PartitionCollectionImmutable) {
                n = ((PartitionCollectionImmutable)CdmIndexPanel.this.gc).getPartitionSize();
            }
            return n;
        }

        public int getNruntimes() {
            return this.group.getNruntimes();
        }

        public int getNCoords() {
            return this.group.getCoordinates().size();
        }

        public int getNVariables() {
            return this.group.getVariables().size();
        }

        public String getDescription() {
            return this.group.getDescription();
        }

        public int getNmissing() {
            return this.nmissing;
        }

        public int getNdups() {
            return this.ndups;
        }
    }

    private static class SortBySize
    implements Comparable<SortBySize> {
        Object obj;
        int size;

        private SortBySize(Object obj, int size) {
            this.obj = obj;
            this.size = size;
        }

        @Override
        public int compareTo(SortBySize o) {
            return Integer.compare(this.size, o.size);
        }
    }
}

