/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeListener;
import ucar.util.prefs.PersistenceManager;

public class PersistentBean
implements PersistenceManager {
    private BeanMap beanMap;
    private boolean debugBean = false;

    public PersistentBean(Object bean) {
        this.beanMap = new BeanMap(bean);
    }

    @Override
    public Object getObject(String name) {
        return this.beanMap.getObject(name);
    }

    @Override
    public void putObject(String name, Object value) {
        this.beanMap.putObject(name, value);
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
    }

    @Override
    public String get(String key, String def) {
        Object value = this.getObject(key);
        return value == null ? def : value.toString();
    }

    @Override
    public void put(String key, String value) {
        this.putObject(key, value);
    }

    @Override
    public double getDouble(String key, double def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).doubleValue();
    }

    @Override
    public void putDouble(String key, double value) {
        this.putObject(key, new Double(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        Object value = this.getObject(key);
        return value == null ? def : (Boolean)value;
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.putObject(key, value);
    }

    @Override
    public int getInt(String key, int def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).intValue();
    }

    @Override
    public void putInt(String key, int value) {
        this.putObject(key, new Integer(value));
    }

    @Override
    public long getLong(String key, long def) {
        Object value = this.getObject(key);
        return value == null ? def : ((Number)value).longValue();
    }

    @Override
    public void putLong(String key, long value) {
        this.putObject(key, new Long(value));
    }

    @Override
    public List getList(String key, List def) {
        Object value = this.getObject(key);
        return value == null ? def : (List)value;
    }

    @Override
    public void putList(String key, List value) {
        this.putObject(key, value);
    }

    private static class PropertyMap {
        private static boolean debugBeanParser = false;
        private static boolean debugBeanParserDetail = false;
        private static Map<Class, PropertyMap> parsers = new HashMap<Class, PropertyMap>();
        private Map<String, PropertyDescriptor> properties = new LinkedHashMap<String, PropertyDescriptor>();

        static PropertyMap getParser(Class beanClass) {
            PropertyMap parser = parsers.get(beanClass);
            if (null == parser) {
                parser = new PropertyMap(beanClass);
                parsers.put(beanClass, parser);
            }
            return parser;
        }

        PropertyMap(Class beanClass) {
            PropertyDescriptor[] pds;
            BeanInfo info;
            try {
                info = Introspector.getBeanInfo(beanClass, Object.class);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                return;
            }
            if (debugBeanParser) {
                System.out.println("Bean " + beanClass.getName());
            }
            for (PropertyDescriptor prop : pds = info.getPropertyDescriptors()) {
                Class<?> propClass = prop.getPropertyType();
                if (prop.getReadMethod() == null) continue;
                this.properties.put(prop.getName(), prop);
                if (!debugBeanParser) continue;
                System.out.println(" read/write property " + prop.getName() + " " + propClass.getName() + " prim= " + propClass.isPrimitive());
            }
            if (debugBeanParserDetail) {
                System.out.println(" Properties:");
                for (PropertyDescriptor pd : pds) {
                    String name = pd.getName();
                    Class<?> type = pd.getPropertyType();
                    Method rm = pd.getReadMethod();
                    Method wm = pd.getWriteMethod();
                    System.out.println("  " + name + " " + type.getName() + " read= " + rm + " write= " + wm + " " + pd.isPreferred());
                    System.out.println("     displayname= " + pd.getDisplayName());
                }
            }
        }

        Iterator<PropertyDescriptor> getProperties() {
            return this.properties.values().iterator();
        }

        PropertyDescriptor findProperty(String name) {
            return this.properties.get(name);
        }
    }

    private static class ProxyProp {
        private PropertyDescriptor prop;
        private BeanMap nested;
        private String childrenName;

        ProxyProp(PropertyDescriptor prop, BeanMap nested, String childrenName) {
            this.prop = prop;
            this.nested = nested;
            this.childrenName = childrenName;
        }
    }

    private class BeanMap {
        private Object bean;
        private PropertyMap pmap;
        private Map<String, BeanMap> beanMaps = new HashMap<String, BeanMap>();
        private Object[] args = new Object[1];

        BeanMap(Object bean) {
            this.bean = bean;
            this.pmap = PropertyMap.getParser(bean.getClass());
        }

        private ProxyProp getPropertyDescriptor(String name) {
            PropertyDescriptor prop = this.pmap.findProperty(name);
            if (prop != null) {
                return new ProxyProp(prop, null, null);
            }
            int pos = name.indexOf(".");
            if (pos < 0) {
                throw new IllegalArgumentException("PersistentBean: no property named " + name);
            }
            String parentName = name.substring(0, pos);
            String childrenName = name.substring(pos + 1);
            prop = this.pmap.findProperty(parentName);
            if (prop == null) {
                throw new IllegalArgumentException("PersistentBean: no property named " + parentName);
            }
            BeanMap nested = this.beanMaps.get(parentName);
            if (nested == null) {
                Object bean = this.getObject(parentName);
                if (bean == null) {
                    bean = this.createObject(prop);
                    this.putObject(parentName, bean);
                }
                nested = new BeanMap(bean);
                this.beanMaps.put(parentName, nested);
            }
            return new ProxyProp(null, nested, childrenName);
        }

        private Object createObject(PropertyDescriptor prop) {
            Class<?> propClass = prop.getPropertyType();
            try {
                return propClass.newInstance();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                throw new IllegalArgumentException("PersistentBean error createObject: " + prop.getName() + " " + ee.getMessage());
            }
        }

        public Object getObject(String name) {
            ProxyProp proxy;
            if (PersistentBean.this.debugBean) {
                System.out.println("PersistentBean read " + name);
            }
            if ((proxy = this.getPropertyDescriptor(name)).prop == null) {
                return proxy.nested.getObject(proxy.childrenName);
            }
            PropertyDescriptor prop = proxy.prop;
            Object value = null;
            try {
                Method m3 = prop.getReadMethod();
                if (m3 == null) {
                    System.out.println("PersistentBean no read method for: " + name);
                    return null;
                }
                value = m3.invoke(this.bean, (Object[])null);
            }
            catch (InvocationTargetException ee) {
                System.out.println("PersistentBean error read: " + name + " " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception ee) {
                System.out.println("PersistentBean error read: " + name + " " + ee);
                ee.printStackTrace();
            }
            return value;
        }

        public void putObject(String name, Object value) {
            ProxyProp proxy;
            if (PersistentBean.this.debugBean) {
                System.out.println("PersistentBean write " + name + " = " + value + " " + value.getClass().getName());
            }
            if ((proxy = this.getPropertyDescriptor(name)).prop == null) {
                proxy.nested.putObject(proxy.childrenName, value);
                return;
            }
            PropertyDescriptor prop = proxy.prop;
            this.args[0] = value;
            try {
                Method m3 = prop.getWriteMethod();
                if (m3 == null) {
                    System.out.println("PersistentBean no write method for: " + name);
                    return;
                }
                m3.invoke(this.bean, this.args);
            }
            catch (InvocationTargetException ee) {
                System.out.println("PersistentBean error write: " + name + " " + ee.getCause());
                ee.getCause().printStackTrace();
            }
            catch (Exception ee) {
                System.out.println("PersistentBean error write: " + name + " " + ee);
                ee.printStackTrace();
            }
        }
    }
}

