/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import loci.formats.FormatException;
import loci.formats.IFormatHandler;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.gui.GUITools;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.ImageFlatField;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.MetadataReader;
import visad.java2d.DisplayImplJ2D;
import visad.util.AnimationWidget;
import visad.util.DataUtility;
import visad.util.LabeledColorWidget;
import visad.util.RangeWidget;

public class LociForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer,
MetadataReader {
    private static int formCount = 0;
    protected IFormatReader reader;
    protected IFormatWriter writer;
    protected double percent;
    protected FileFilter[] rFilters;
    protected FileFilter[] wFilters;

    public LociForm() {
        this(new ImageReader(), new ImageWriter());
    }

    public LociForm(IFormatReader reader) {
        this(reader, null);
    }

    public LociForm(IFormatWriter writer) {
        this(null, writer);
    }

    public LociForm(IFormatReader reader, IFormatWriter writer) {
        super("LociForm" + formCount++);
        this.reader = reader;
        this.writer = writer;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public IFormatWriter getWriter() {
        return this.writer;
    }

    public void setFrameRate(int fps) {
        if (this.writer == null) {
            return;
        }
        this.writer.setFramesPerSecond(fps);
    }

    public void testRead(String[] args) throws VisADException, IOException {
        RealType[] realTypeArray;
        MathType range;
        if (this.reader == null) {
            return;
        }
        String className = this.getClass().getName();
        String format = this.reader.getFormat();
        if (args == null || args.length < 1) {
            System.out.println("To test read a file in " + format + " format, run:");
            System.out.println("  java " + className + " in_file");
            return;
        }
        String id = args[0];
        System.out.print("Checking " + format + " format ");
        System.out.println(this.isThisType(id) ? "[yes]" : "[no]");
        System.out.print("Reading " + id + " pixel data ");
        DataImpl data = this.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        FunctionType ftype = (FunctionType)data.getType();
        RealTupleType domain = ftype.getDomain();
        RealType[] xy = domain.getRealComponents();
        RealType time = null;
        if (xy.length == 1) {
            time = xy[0];
            ftype = (FunctionType)ftype.getRange();
            domain = ftype.getDomain();
            xy = domain.getRealComponents();
        }
        if ((range = ftype.getRange()) instanceof RealType) {
            RealType[] realTypeArray2 = new RealType[1];
            realTypeArray = realTypeArray2;
            realTypeArray2[0] = (RealType)range;
        } else {
            realTypeArray = ((RealTupleType)range).getRealComponents();
        }
        RealType[] values = realTypeArray;
        DisplayImplJ2D display = new DisplayImplJ2D("display");
        ScalarMap timeMap = null;
        if (time != null) {
            timeMap = new ScalarMap(time, Display.Animation);
            display.addMap(timeMap);
        }
        display.addMap(new ScalarMap(xy[0], Display.XAxis));
        display.addMap(new ScalarMap(xy[1], Display.YAxis));
        ScalarMap colorMap = null;
        if (values.length == 2 || values.length == 3) {
            display.addMap(new ScalarMap(values[0], Display.Red));
            display.addMap(new ScalarMap(values[1], Display.Green));
            if (values.length == 3) {
                display.addMap(new ScalarMap(values[2], Display.Blue));
            }
        } else {
            colorMap = new ScalarMap(values[0], Display.RGB);
            display.addMap(colorMap);
        }
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(data);
        display.addReference(ref);
        ((DisplayImpl)display).getGraphicsModeControl().setScaleEnable(true);
        JFrame frame = new JFrame(format + " Results");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel p = new JPanel();
        frame.setContentPane(p);
        p.setLayout(new BorderLayout());
        p.add(display.getComponent());
        if (timeMap != null) {
            AnimationWidget aw = new AnimationWidget(timeMap);
            p.add("South", aw);
        }
        if (colorMap != null) {
            RangeWidget rw = new RangeWidget(colorMap);
            LabeledColorWidget lcw = new LabeledColorWidget(colorMap);
            p.add("North", rw);
            p.add("East", lcw);
        }
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }

    public FileFilter[] getReaderFilters() {
        if (this.reader == null) {
            return null;
        }
        if (this.rFilters == null) {
            this.rFilters = GUITools.buildFileFilters(this.reader);
        }
        return this.rFilters;
    }

    public FileFilter[] getWriterFilters() {
        if (this.writer == null) {
            return null;
        }
        if (this.wFilters == null) {
            this.wFilters = GUITools.buildFileFilters(this.writer);
        }
        return this.wFilters;
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        for (int i = 0; i < nImages; ++i) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = Double.NaN;
        return data;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        if (this.writer == null) {
            throw new BadFormException("No writer");
        }
        this.percent = 0.0;
        FlatField[] fields = DataUtility.getImageFields(data);
        try {
            this.initHandler(this.writer, id);
            for (int i = 0; i < fields.length; ++i) {
                Image image = fields[i] instanceof ImageFlatField ? ((ImageFlatField)fields[i]).getImage() : DataUtility.extractImage(fields[i], false);
                this.writer.saveImage(image, i == fields.length - 1);
                this.percent = (double)(i + 1) / (double)fields.length;
            }
        }
        catch (FormatException exc) {
            throw new BadFormException(exc);
        }
        this.percent = Double.NaN;
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("LociForm.add");
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new UnimplementedException("LociForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        BufferedImage image;
        if (this.reader == null) {
            throw new BadFormException("No reader");
        }
        try {
            this.initHandler(this.reader, id);
            image = this.reader.openImage(block_number);
        }
        catch (FormatException exc) {
            throw new BadFormException(exc);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int num = image.getRaster().getNumBands();
        RealType x = RealType.getRealType("ImageElement");
        RealType y = RealType.getRealType("ImageLine");
        RealType[] v = new RealType[num];
        for (int i = 0; i < num; ++i) {
            v[i] = RealType.getRealType("value" + i);
        }
        RealTupleType domain = new RealTupleType(x, y);
        RealTupleType range = new RealTupleType(v);
        FunctionType fieldType = new FunctionType(domain, range);
        Linear2DSet fieldSet = new Linear2DSet((MathType)domain, 0.0, (double)(width - 1), width, height - 1, 0.0, height);
        ImageFlatField field = new ImageFlatField(fieldType, fieldSet);
        field.setImage(image);
        return field;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (this.reader == null) {
            throw new BadFormException("No reader");
        }
        this.initHandler(this.reader, id);
        return this.reader.getImageCount();
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.reader == null) {
            throw new BadFormException("No reader");
        }
        this.reader.close();
    }

    public boolean isThisType(String name) {
        if (this.reader == null) {
            return false;
        }
        return this.reader.isThisType(name);
    }

    public boolean isThisType(byte[] block) {
        if (this.reader == null) {
            return false;
        }
        return this.reader.isThisType(block);
    }

    public String[] getDefaultSuffixes() {
        if (this.reader != null) {
            return this.reader.getSuffixes();
        }
        if (this.writer != null) {
            return this.writer.getSuffixes();
        }
        return null;
    }

    public double getPercentComplete() {
        return this.percent;
    }

    public Object getMetadataValue(String id, String field) throws BadFormException, IOException, VisADException {
        if (this.reader == null) {
            throw new BadFormException("No reader");
        }
        this.initHandler(this.reader, id);
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getMetadata(String id) throws BadFormException, IOException, VisADException {
        if (this.reader == null) {
            throw new BadFormException("No reader");
        }
        this.initHandler(this.reader, id);
        return this.reader.getMetadata();
    }

    public static void main(String[] args) throws Exception {
        new LociForm().testRead(args);
    }

    public void initHandler(IFormatHandler h2, String id) throws BadFormException, IOException {
        try {
            h2.setId(id);
        }
        catch (FormatException exc) {
            throw new BadFormException(exc);
        }
    }
}

