/*
 * Decompiled with CFR 0.152.
 */
package visad.data.jai;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class JAIForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"bmp", "gif", "flashpix", "jpg", "jpeg", "jpe", "png", "pnm", "tif", "tiff"};
    private static boolean noJai = false;
    private static ReflectedUniverse r = JAIForm.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import javax.media.jai.JAI");
            r.exec("import javax.media.jai.PlanarImage");
        }
        catch (VisADException exc) {
            noJai = true;
        }
        return r;
    }

    private static BufferedImage createImage(String s2, Object o) {
        BufferedImage bi = null;
        try {
            r.setVar("s", s2);
            r.setVar("o", o);
            r.exec("pi = JAI.create(s, o)");
            bi = (BufferedImage)r.exec("pi.getAsBufferedImage()");
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return bi;
    }

    public JAIForm() {
        super("JAIForm" + num++);
    }

    public boolean isThisType(String name) {
        if (noJai) {
            return false;
        }
        for (int i = 0; i < suffixes.length; ++i) {
            if (!name.toLowerCase().endsWith(suffixes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s2 = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s2, 0, suffixes.length);
        return s2;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new BadFormException("JAIForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("JAIForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        if (noJai) {
            throw new BadFormException("you need to install JAI from http://java.sun.com/products/java-media/jai/index.html");
        }
        BufferedImage bi = JAIForm.createImage("fileload", id);
        return this.open(bi);
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        if (noJai) {
            throw new BadFormException("you need to install JAI from http://java.sun.com/products/java-media/jai/index.html");
        }
        BufferedImage bi = JAIForm.createImage("URL", url);
        return this.open(bi);
    }

    private DataImpl open(BufferedImage image) throws BadFormException, IOException, VisADException {
        if (image == null) {
            throw new BadFormException("JAI could not read the file as an image");
        }
        return DataUtility.makeField(image);
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read an image file, run:");
            System.out.println("  java visad.data.jai.JAIForm in_file");
            System.exit(2);
        }
        JAIForm form = new JAIForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType().prettyString());
        System.exit(0);
    }
}

